/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.signer.model.EncryptionAlgorithmOptions;
import software.amazon.awssdk.services.signer.model.HashAlgorithmOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SigningConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SigningConfiguration> {
    private static final SdkField<EncryptionAlgorithmOptions> ENCRYPTION_ALGORITHM_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("encryptionAlgorithmOptions").getter(SigningConfiguration.getter(SigningConfiguration::encryptionAlgorithmOptions)).setter(SigningConfiguration.setter(Builder::encryptionAlgorithmOptions)).constructor(EncryptionAlgorithmOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionAlgorithmOptions").build()}).build();
    private static final SdkField<HashAlgorithmOptions> HASH_ALGORITHM_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("hashAlgorithmOptions").getter(SigningConfiguration.getter(SigningConfiguration::hashAlgorithmOptions)).setter(SigningConfiguration.setter(Builder::hashAlgorithmOptions)).constructor(HashAlgorithmOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hashAlgorithmOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_ALGORITHM_OPTIONS_FIELD, HASH_ALGORITHM_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("encryptionAlgorithmOptions", ENCRYPTION_ALGORITHM_OPTIONS_FIELD);
            this.put("hashAlgorithmOptions", HASH_ALGORITHM_OPTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final EncryptionAlgorithmOptions encryptionAlgorithmOptions;
    private final HashAlgorithmOptions hashAlgorithmOptions;

    private SigningConfiguration(BuilderImpl builder) {
        this.encryptionAlgorithmOptions = builder.encryptionAlgorithmOptions;
        this.hashAlgorithmOptions = builder.hashAlgorithmOptions;
    }

    public final EncryptionAlgorithmOptions encryptionAlgorithmOptions() {
        return this.encryptionAlgorithmOptions;
    }

    public final HashAlgorithmOptions hashAlgorithmOptions() {
        return this.hashAlgorithmOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionAlgorithmOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hashAlgorithmOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SigningConfiguration)) {
            return false;
        }
        SigningConfiguration other = (SigningConfiguration)obj;
        return Objects.equals(this.encryptionAlgorithmOptions(), other.encryptionAlgorithmOptions()) && Objects.equals(this.hashAlgorithmOptions(), other.hashAlgorithmOptions());
    }

    public final String toString() {
        return ToString.builder((String)"SigningConfiguration").add("EncryptionAlgorithmOptions", (Object)this.encryptionAlgorithmOptions()).add("HashAlgorithmOptions", (Object)this.hashAlgorithmOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "encryptionAlgorithmOptions": {
                return Optional.ofNullable(clazz.cast(this.encryptionAlgorithmOptions()));
            }
            case "hashAlgorithmOptions": {
                return Optional.ofNullable(clazz.cast(this.hashAlgorithmOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SigningConfiguration, T> g) {
        return obj -> g.apply((SigningConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private EncryptionAlgorithmOptions encryptionAlgorithmOptions;
        private HashAlgorithmOptions hashAlgorithmOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(SigningConfiguration model) {
            this.encryptionAlgorithmOptions(model.encryptionAlgorithmOptions);
            this.hashAlgorithmOptions(model.hashAlgorithmOptions);
        }

        public final EncryptionAlgorithmOptions.Builder getEncryptionAlgorithmOptions() {
            return this.encryptionAlgorithmOptions != null ? this.encryptionAlgorithmOptions.toBuilder() : null;
        }

        public final void setEncryptionAlgorithmOptions(EncryptionAlgorithmOptions.BuilderImpl encryptionAlgorithmOptions) {
            this.encryptionAlgorithmOptions = encryptionAlgorithmOptions != null ? encryptionAlgorithmOptions.build() : null;
        }

        @Override
        public final Builder encryptionAlgorithmOptions(EncryptionAlgorithmOptions encryptionAlgorithmOptions) {
            this.encryptionAlgorithmOptions = encryptionAlgorithmOptions;
            return this;
        }

        public final HashAlgorithmOptions.Builder getHashAlgorithmOptions() {
            return this.hashAlgorithmOptions != null ? this.hashAlgorithmOptions.toBuilder() : null;
        }

        public final void setHashAlgorithmOptions(HashAlgorithmOptions.BuilderImpl hashAlgorithmOptions) {
            this.hashAlgorithmOptions = hashAlgorithmOptions != null ? hashAlgorithmOptions.build() : null;
        }

        @Override
        public final Builder hashAlgorithmOptions(HashAlgorithmOptions hashAlgorithmOptions) {
            this.hashAlgorithmOptions = hashAlgorithmOptions;
            return this;
        }

        public SigningConfiguration build() {
            return new SigningConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SigningConfiguration> {
        public Builder encryptionAlgorithmOptions(EncryptionAlgorithmOptions var1);

        default public Builder encryptionAlgorithmOptions(Consumer<EncryptionAlgorithmOptions.Builder> encryptionAlgorithmOptions) {
            return this.encryptionAlgorithmOptions((EncryptionAlgorithmOptions)((EncryptionAlgorithmOptions.Builder)EncryptionAlgorithmOptions.builder().applyMutation(encryptionAlgorithmOptions)).build());
        }

        public Builder hashAlgorithmOptions(HashAlgorithmOptions var1);

        default public Builder hashAlgorithmOptions(Consumer<HashAlgorithmOptions.Builder> hashAlgorithmOptions) {
            return this.hashAlgorithmOptions((HashAlgorithmOptions)((HashAlgorithmOptions.Builder)HashAlgorithmOptions.builder().applyMutation(hashAlgorithmOptions)).build());
        }
    }
}

