/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.signer.model.SignerResponse;
import software.amazon.awssdk.services.signer.model.SigningPlatform;
import software.amazon.awssdk.services.signer.model.SigningPlatformsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSigningPlatformsResponse
extends SignerResponse
implements ToCopyableBuilder<Builder, ListSigningPlatformsResponse> {
    private static final SdkField<List<SigningPlatform>> PLATFORMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("platforms").getter(ListSigningPlatformsResponse.getter(ListSigningPlatformsResponse::platforms)).setter(ListSigningPlatformsResponse.setter(Builder::platforms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platforms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SigningPlatform::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSigningPlatformsResponse.getter(ListSigningPlatformsResponse::nextToken)).setter(ListSigningPlatformsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORMS_FIELD, NEXT_TOKEN_FIELD));
    private final List<SigningPlatform> platforms;
    private final String nextToken;

    private ListSigningPlatformsResponse(BuilderImpl builder) {
        super(builder);
        this.platforms = builder.platforms;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPlatforms() {
        return this.platforms != null && !(this.platforms instanceof SdkAutoConstructList);
    }

    public final List<SigningPlatform> platforms() {
        return this.platforms;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlatforms() ? this.platforms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSigningPlatformsResponse)) {
            return false;
        }
        ListSigningPlatformsResponse other = (ListSigningPlatformsResponse)((Object)obj);
        return this.hasPlatforms() == other.hasPlatforms() && Objects.equals(this.platforms(), other.platforms()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSigningPlatformsResponse").add("Platforms", this.hasPlatforms() ? this.platforms() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "platforms": {
                return Optional.ofNullable(clazz.cast(this.platforms()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSigningPlatformsResponse, T> g) {
        return obj -> g.apply((ListSigningPlatformsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SignerResponse.BuilderImpl
    implements Builder {
        private List<SigningPlatform> platforms = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSigningPlatformsResponse model) {
            super(model);
            this.platforms(model.platforms);
            this.nextToken(model.nextToken);
        }

        public final List<SigningPlatform.Builder> getPlatforms() {
            List<SigningPlatform.Builder> result = SigningPlatformsCopier.copyToBuilder(this.platforms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder platforms(Collection<SigningPlatform> platforms) {
            this.platforms = SigningPlatformsCopier.copy(platforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platforms(SigningPlatform ... platforms) {
            this.platforms(Arrays.asList(platforms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platforms(Consumer<SigningPlatform.Builder> ... platforms) {
            this.platforms(Stream.of(platforms).map(c -> (SigningPlatform)((SigningPlatform.Builder)SigningPlatform.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPlatforms(Collection<SigningPlatform.BuilderImpl> platforms) {
            this.platforms = SigningPlatformsCopier.copyFromBuilder(platforms);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSigningPlatformsResponse build() {
            return new ListSigningPlatformsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SignerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSigningPlatformsResponse> {
        public Builder platforms(Collection<SigningPlatform> var1);

        public Builder platforms(SigningPlatform ... var1);

        public Builder platforms(Consumer<SigningPlatform.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

