/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ValidityType {
    DAYS("DAYS"),
    MONTHS("MONTHS"),
    YEARS("YEARS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ValidityType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ValidityType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ValidityType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ValidityType> knownValues() {
        return Stream.of(ValidityType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

