/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.signer.model.Permission;
import software.amazon.awssdk.services.signer.model.PermissionsCopier;
import software.amazon.awssdk.services.signer.model.SignerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProfilePermissionsResponse
extends SignerResponse
implements ToCopyableBuilder<Builder, ListProfilePermissionsResponse> {
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revisionId").getter(ListProfilePermissionsResponse.getter(ListProfilePermissionsResponse::revisionId)).setter(ListProfilePermissionsResponse.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()}).build();
    private static final SdkField<Integer> POLICY_SIZE_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("policySizeBytes").getter(ListProfilePermissionsResponse.getter(ListProfilePermissionsResponse::policySizeBytes)).setter(ListProfilePermissionsResponse.setter(Builder::policySizeBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policySizeBytes").build()}).build();
    private static final SdkField<List<Permission>> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("permissions").getter(ListProfilePermissionsResponse.getter(ListProfilePermissionsResponse::permissions)).setter(ListProfilePermissionsResponse.setter(Builder::permissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Permission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListProfilePermissionsResponse.getter(ListProfilePermissionsResponse::nextToken)).setter(ListProfilePermissionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REVISION_ID_FIELD, POLICY_SIZE_BYTES_FIELD, PERMISSIONS_FIELD, NEXT_TOKEN_FIELD));
    private final String revisionId;
    private final Integer policySizeBytes;
    private final List<Permission> permissions;
    private final String nextToken;

    private ListProfilePermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.revisionId = builder.revisionId;
        this.policySizeBytes = builder.policySizeBytes;
        this.permissions = builder.permissions;
        this.nextToken = builder.nextToken;
    }

    public final String revisionId() {
        return this.revisionId;
    }

    public final Integer policySizeBytes() {
        return this.policySizeBytes;
    }

    public final boolean hasPermissions() {
        return this.permissions != null && !(this.permissions instanceof SdkAutoConstructList);
    }

    public final List<Permission> permissions() {
        return this.permissions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policySizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPermissions() ? this.permissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProfilePermissionsResponse)) {
            return false;
        }
        ListProfilePermissionsResponse other = (ListProfilePermissionsResponse)((Object)obj);
        return Objects.equals(this.revisionId(), other.revisionId()) && Objects.equals(this.policySizeBytes(), other.policySizeBytes()) && this.hasPermissions() == other.hasPermissions() && Objects.equals(this.permissions(), other.permissions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListProfilePermissionsResponse").add("RevisionId", (Object)this.revisionId()).add("PolicySizeBytes", (Object)this.policySizeBytes()).add("Permissions", this.hasPermissions() ? this.permissions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "revisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
            case "policySizeBytes": {
                return Optional.ofNullable(clazz.cast(this.policySizeBytes()));
            }
            case "permissions": {
                return Optional.ofNullable(clazz.cast(this.permissions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProfilePermissionsResponse, T> g) {
        return obj -> g.apply((ListProfilePermissionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SignerResponse.BuilderImpl
    implements Builder {
        private String revisionId;
        private Integer policySizeBytes;
        private List<Permission> permissions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProfilePermissionsResponse model) {
            super(model);
            this.revisionId(model.revisionId);
            this.policySizeBytes(model.policySizeBytes);
            this.permissions(model.permissions);
            this.nextToken(model.nextToken);
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        public final Integer getPolicySizeBytes() {
            return this.policySizeBytes;
        }

        @Override
        public final Builder policySizeBytes(Integer policySizeBytes) {
            this.policySizeBytes = policySizeBytes;
            return this;
        }

        public final void setPolicySizeBytes(Integer policySizeBytes) {
            this.policySizeBytes = policySizeBytes;
        }

        public final Collection<Permission.Builder> getPermissions() {
            if (this.permissions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.permissions != null ? (Collection)this.permissions.stream().map(Permission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder permissions(Collection<Permission> permissions) {
            this.permissions = PermissionsCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Permission ... permissions) {
            this.permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Consumer<Permission.Builder> ... permissions) {
            this.permissions(Stream.of(permissions).map(c -> (Permission)((Permission.Builder)Permission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPermissions(Collection<Permission.BuilderImpl> permissions) {
            this.permissions = PermissionsCopier.copyFromBuilder(permissions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListProfilePermissionsResponse build() {
            return new ListProfilePermissionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SignerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProfilePermissionsResponse> {
        public Builder revisionId(String var1);

        public Builder policySizeBytes(Integer var1);

        public Builder permissions(Collection<Permission> var1);

        public Builder permissions(Permission ... var1);

        public Builder permissions(Consumer<Permission.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

