/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.signer.model.EncryptionAlgorithm;
import software.amazon.awssdk.services.signer.model.EncryptionAlgorithmsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EncryptionAlgorithmOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EncryptionAlgorithmOptions> {
    private static final SdkField<List<String>> ALLOWED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(EncryptionAlgorithmOptions.getter(EncryptionAlgorithmOptions::allowedValuesAsStrings)).setter(EncryptionAlgorithmOptions.setter(Builder::allowedValuesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EncryptionAlgorithmOptions.getter(EncryptionAlgorithmOptions::defaultValueAsString)).setter(EncryptionAlgorithmOptions.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_VALUES_FIELD, DEFAULT_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> allowedValues;
    private final String defaultValue;

    private EncryptionAlgorithmOptions(BuilderImpl builder) {
        this.allowedValues = builder.allowedValues;
        this.defaultValue = builder.defaultValue;
    }

    public List<EncryptionAlgorithm> allowedValues() {
        return EncryptionAlgorithmsCopier.copyStringToEnum(this.allowedValues);
    }

    public List<String> allowedValuesAsStrings() {
        return this.allowedValues;
    }

    public EncryptionAlgorithm defaultValue() {
        return EncryptionAlgorithm.fromValue(this.defaultValue);
    }

    public String defaultValueAsString() {
        return this.defaultValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedValuesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValueAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionAlgorithmOptions)) {
            return false;
        }
        EncryptionAlgorithmOptions other = (EncryptionAlgorithmOptions)obj;
        return Objects.equals(this.allowedValuesAsStrings(), other.allowedValuesAsStrings()) && Objects.equals(this.defaultValueAsString(), other.defaultValueAsString());
    }

    public String toString() {
        return ToString.builder((String)"EncryptionAlgorithmOptions").add("AllowedValues", this.allowedValuesAsStrings()).add("DefaultValue", (Object)this.defaultValueAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "allowedValues": {
                return Optional.ofNullable(clazz.cast(this.allowedValuesAsStrings()));
            }
            case "defaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValueAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EncryptionAlgorithmOptions, T> g) {
        return obj -> g.apply((EncryptionAlgorithmOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> allowedValues = DefaultSdkAutoConstructList.getInstance();
        private String defaultValue;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionAlgorithmOptions model) {
            this.allowedValuesWithStrings(model.allowedValues);
            this.defaultValue(model.defaultValue);
        }

        public final Collection<String> getAllowedValuesAsStrings() {
            return this.allowedValues;
        }

        @Override
        public final Builder allowedValuesWithStrings(Collection<String> allowedValues) {
            this.allowedValues = EncryptionAlgorithmsCopier.copy(allowedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedValuesWithStrings(String ... allowedValues) {
            this.allowedValuesWithStrings(Arrays.asList(allowedValues));
            return this;
        }

        @Override
        public final Builder allowedValues(Collection<EncryptionAlgorithm> allowedValues) {
            this.allowedValues = EncryptionAlgorithmsCopier.copyEnumToString(allowedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedValues(EncryptionAlgorithm ... allowedValues) {
            this.allowedValues(Arrays.asList(allowedValues));
            return this;
        }

        public final void setAllowedValuesWithStrings(Collection<String> allowedValues) {
            this.allowedValues = EncryptionAlgorithmsCopier.copy(allowedValues);
        }

        public final String getDefaultValueAsString() {
            return this.defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @Override
        public final Builder defaultValue(EncryptionAlgorithm defaultValue) {
            this.defaultValue(defaultValue == null ? null : defaultValue.toString());
            return this;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public EncryptionAlgorithmOptions build() {
            return new EncryptionAlgorithmOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EncryptionAlgorithmOptions> {
        public Builder allowedValuesWithStrings(Collection<String> var1);

        public Builder allowedValuesWithStrings(String ... var1);

        public Builder allowedValues(Collection<EncryptionAlgorithm> var1);

        public Builder allowedValues(EncryptionAlgorithm ... var1);

        public Builder defaultValue(String var1);

        public Builder defaultValue(EncryptionAlgorithm var1);
    }
}

