/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProtectionGroupRequest extends ShieldRequest implements
        ToCopyableBuilder<CreateProtectionGroupRequest.Builder, CreateProtectionGroupRequest> {
    private static final SdkField<String> PROTECTION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtectionGroupId").getter(getter(CreateProtectionGroupRequest::protectionGroupId))
            .setter(setter(Builder::protectionGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectionGroupId").build()).build();

    private static final SdkField<String> AGGREGATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Aggregation").getter(getter(CreateProtectionGroupRequest::aggregationAsString))
            .setter(setter(Builder::aggregation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregation").build()).build();

    private static final SdkField<String> PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Pattern")
            .getter(getter(CreateProtectionGroupRequest::patternAsString)).setter(setter(Builder::pattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pattern").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(CreateProtectionGroupRequest::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<List<String>> MEMBERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Members")
            .getter(getter(CreateProtectionGroupRequest::members))
            .setter(setter(Builder::members))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Members").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateProtectionGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTECTION_GROUP_ID_FIELD,
            AGGREGATION_FIELD, PATTERN_FIELD, RESOURCE_TYPE_FIELD, MEMBERS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String protectionGroupId;

    private final String aggregation;

    private final String pattern;

    private final String resourceType;

    private final List<String> members;

    private final List<Tag> tags;

    private CreateProtectionGroupRequest(BuilderImpl builder) {
        super(builder);
        this.protectionGroupId = builder.protectionGroupId;
        this.aggregation = builder.aggregation;
        this.pattern = builder.pattern;
        this.resourceType = builder.resourceType;
        this.members = builder.members;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the protection group. You use this to identify the protection group in lists and to manage the
     * protection group, for example to update, delete, or describe it.
     * </p>
     * 
     * @return The name of the protection group. You use this to identify the protection group in lists and to manage
     *         the protection group, for example to update, delete, or describe it.
     */
    public final String protectionGroupId() {
        return protectionGroupId;
    }

    /**
     * <p>
     * Defines how Shield combines resource data for the group in order to detect, mitigate, and report events.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Sum - Use the total traffic across the group. This is a good choice for most cases. Examples include Elastic IP
     * addresses for EC2 instances that scale manually or automatically.
     * </p>
     * </li>
     * <li>
     * <p>
     * Mean - Use the average of the traffic across the group. This is a good choice for resources that share traffic
     * uniformly. Examples include accelerators and load balancers.
     * </p>
     * </li>
     * <li>
     * <p>
     * Max - Use the highest traffic from each resource. This is useful for resources that don't share traffic and for
     * resources that share that traffic in a non-uniform way. Examples include Amazon CloudFront and origin resources
     * for CloudFront distributions.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregation} will
     * return {@link ProtectionGroupAggregation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #aggregationAsString}.
     * </p>
     * 
     * @return Defines how Shield combines resource data for the group in order to detect, mitigate, and report
     *         events.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Sum - Use the total traffic across the group. This is a good choice for most cases. Examples include
     *         Elastic IP addresses for EC2 instances that scale manually or automatically.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Mean - Use the average of the traffic across the group. This is a good choice for resources that share
     *         traffic uniformly. Examples include accelerators and load balancers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Max - Use the highest traffic from each resource. This is useful for resources that don't share traffic
     *         and for resources that share that traffic in a non-uniform way. Examples include Amazon CloudFront and
     *         origin resources for CloudFront distributions.
     *         </p>
     *         </li>
     * @see ProtectionGroupAggregation
     */
    public final ProtectionGroupAggregation aggregation() {
        return ProtectionGroupAggregation.fromValue(aggregation);
    }

    /**
     * <p>
     * Defines how Shield combines resource data for the group in order to detect, mitigate, and report events.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Sum - Use the total traffic across the group. This is a good choice for most cases. Examples include Elastic IP
     * addresses for EC2 instances that scale manually or automatically.
     * </p>
     * </li>
     * <li>
     * <p>
     * Mean - Use the average of the traffic across the group. This is a good choice for resources that share traffic
     * uniformly. Examples include accelerators and load balancers.
     * </p>
     * </li>
     * <li>
     * <p>
     * Max - Use the highest traffic from each resource. This is useful for resources that don't share traffic and for
     * resources that share that traffic in a non-uniform way. Examples include Amazon CloudFront and origin resources
     * for CloudFront distributions.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregation} will
     * return {@link ProtectionGroupAggregation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #aggregationAsString}.
     * </p>
     * 
     * @return Defines how Shield combines resource data for the group in order to detect, mitigate, and report
     *         events.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Sum - Use the total traffic across the group. This is a good choice for most cases. Examples include
     *         Elastic IP addresses for EC2 instances that scale manually or automatically.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Mean - Use the average of the traffic across the group. This is a good choice for resources that share
     *         traffic uniformly. Examples include accelerators and load balancers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Max - Use the highest traffic from each resource. This is useful for resources that don't share traffic
     *         and for resources that share that traffic in a non-uniform way. Examples include Amazon CloudFront and
     *         origin resources for CloudFront distributions.
     *         </p>
     *         </li>
     * @see ProtectionGroupAggregation
     */
    public final String aggregationAsString() {
        return aggregation;
    }

    /**
     * <p>
     * The criteria to use to choose the protected resources for inclusion in the group. You can include all resources
     * that have protections, provide a list of resource Amazon Resource Names (ARNs), or include all resources of a
     * specified resource type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pattern} will
     * return {@link ProtectionGroupPattern#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #patternAsString}.
     * </p>
     * 
     * @return The criteria to use to choose the protected resources for inclusion in the group. You can include all
     *         resources that have protections, provide a list of resource Amazon Resource Names (ARNs), or include all
     *         resources of a specified resource type.
     * @see ProtectionGroupPattern
     */
    public final ProtectionGroupPattern pattern() {
        return ProtectionGroupPattern.fromValue(pattern);
    }

    /**
     * <p>
     * The criteria to use to choose the protected resources for inclusion in the group. You can include all resources
     * that have protections, provide a list of resource Amazon Resource Names (ARNs), or include all resources of a
     * specified resource type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pattern} will
     * return {@link ProtectionGroupPattern#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #patternAsString}.
     * </p>
     * 
     * @return The criteria to use to choose the protected resources for inclusion in the group. You can include all
     *         resources that have protections, provide a list of resource Amazon Resource Names (ARNs), or include all
     *         resources of a specified resource type.
     * @see ProtectionGroupPattern
     */
    public final String patternAsString() {
        return pattern;
    }

    /**
     * <p>
     * The resource type to include in the protection group. All protected resources of this type are included in the
     * protection group. Newly protected resources of this type are automatically added to the group. You must set this
     * when you set <code>Pattern</code> to <code>BY_RESOURCE_TYPE</code> and you must not set it for any other
     * <code>Pattern</code> setting.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ProtectedResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type to include in the protection group. All protected resources of this type are included
     *         in the protection group. Newly protected resources of this type are automatically added to the group. You
     *         must set this when you set <code>Pattern</code> to <code>BY_RESOURCE_TYPE</code> and you must not set it
     *         for any other <code>Pattern</code> setting.
     * @see ProtectedResourceType
     */
    public final ProtectedResourceType resourceType() {
        return ProtectedResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The resource type to include in the protection group. All protected resources of this type are included in the
     * protection group. Newly protected resources of this type are automatically added to the group. You must set this
     * when you set <code>Pattern</code> to <code>BY_RESOURCE_TYPE</code> and you must not set it for any other
     * <code>Pattern</code> setting.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ProtectedResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type to include in the protection group. All protected resources of this type are included
     *         in the protection group. Newly protected resources of this type are automatically added to the group. You
     *         must set this when you set <code>Pattern</code> to <code>BY_RESOURCE_TYPE</code> and you must not set it
     *         for any other <code>Pattern</code> setting.
     * @see ProtectedResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Members property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMembers() {
        return members != null && !(members instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of the resources to include in the protection group. You must set this when you
     * set <code>Pattern</code> to <code>ARBITRARY</code> and you must not set it for any other <code>Pattern</code>
     * setting.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMembers} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of the resources to include in the protection group. You must set this
     *         when you set <code>Pattern</code> to <code>ARBITRARY</code> and you must not set it for any other
     *         <code>Pattern</code> setting.
     */
    public final List<String> members() {
        return members;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more tag key-value pairs for the protection group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return One or more tag key-value pairs for the protection group.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(protectionGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(patternAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasMembers() ? members() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProtectionGroupRequest)) {
            return false;
        }
        CreateProtectionGroupRequest other = (CreateProtectionGroupRequest) obj;
        return Objects.equals(protectionGroupId(), other.protectionGroupId())
                && Objects.equals(aggregationAsString(), other.aggregationAsString())
                && Objects.equals(patternAsString(), other.patternAsString())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString()) && hasMembers() == other.hasMembers()
                && Objects.equals(members(), other.members()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateProtectionGroupRequest").add("ProtectionGroupId", protectionGroupId())
                .add("Aggregation", aggregationAsString()).add("Pattern", patternAsString())
                .add("ResourceType", resourceTypeAsString()).add("Members", hasMembers() ? members() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProtectionGroupId":
            return Optional.ofNullable(clazz.cast(protectionGroupId()));
        case "Aggregation":
            return Optional.ofNullable(clazz.cast(aggregationAsString()));
        case "Pattern":
            return Optional.ofNullable(clazz.cast(patternAsString()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "Members":
            return Optional.ofNullable(clazz.cast(members()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProtectionGroupId", PROTECTION_GROUP_ID_FIELD);
        map.put("Aggregation", AGGREGATION_FIELD);
        map.put("Pattern", PATTERN_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("Members", MEMBERS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProtectionGroupRequest, T> g) {
        return obj -> g.apply((CreateProtectionGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ShieldRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateProtectionGroupRequest> {
        /**
         * <p>
         * The name of the protection group. You use this to identify the protection group in lists and to manage the
         * protection group, for example to update, delete, or describe it.
         * </p>
         * 
         * @param protectionGroupId
         *        The name of the protection group. You use this to identify the protection group in lists and to manage
         *        the protection group, for example to update, delete, or describe it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectionGroupId(String protectionGroupId);

        /**
         * <p>
         * Defines how Shield combines resource data for the group in order to detect, mitigate, and report events.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Sum - Use the total traffic across the group. This is a good choice for most cases. Examples include Elastic
         * IP addresses for EC2 instances that scale manually or automatically.
         * </p>
         * </li>
         * <li>
         * <p>
         * Mean - Use the average of the traffic across the group. This is a good choice for resources that share
         * traffic uniformly. Examples include accelerators and load balancers.
         * </p>
         * </li>
         * <li>
         * <p>
         * Max - Use the highest traffic from each resource. This is useful for resources that don't share traffic and
         * for resources that share that traffic in a non-uniform way. Examples include Amazon CloudFront and origin
         * resources for CloudFront distributions.
         * </p>
         * </li>
         * </ul>
         * 
         * @param aggregation
         *        Defines how Shield combines resource data for the group in order to detect, mitigate, and report
         *        events.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Sum - Use the total traffic across the group. This is a good choice for most cases. Examples include
         *        Elastic IP addresses for EC2 instances that scale manually or automatically.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Mean - Use the average of the traffic across the group. This is a good choice for resources that share
         *        traffic uniformly. Examples include accelerators and load balancers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Max - Use the highest traffic from each resource. This is useful for resources that don't share
         *        traffic and for resources that share that traffic in a non-uniform way. Examples include Amazon
         *        CloudFront and origin resources for CloudFront distributions.
         *        </p>
         *        </li>
         * @see ProtectionGroupAggregation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectionGroupAggregation
         */
        Builder aggregation(String aggregation);

        /**
         * <p>
         * Defines how Shield combines resource data for the group in order to detect, mitigate, and report events.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Sum - Use the total traffic across the group. This is a good choice for most cases. Examples include Elastic
         * IP addresses for EC2 instances that scale manually or automatically.
         * </p>
         * </li>
         * <li>
         * <p>
         * Mean - Use the average of the traffic across the group. This is a good choice for resources that share
         * traffic uniformly. Examples include accelerators and load balancers.
         * </p>
         * </li>
         * <li>
         * <p>
         * Max - Use the highest traffic from each resource. This is useful for resources that don't share traffic and
         * for resources that share that traffic in a non-uniform way. Examples include Amazon CloudFront and origin
         * resources for CloudFront distributions.
         * </p>
         * </li>
         * </ul>
         * 
         * @param aggregation
         *        Defines how Shield combines resource data for the group in order to detect, mitigate, and report
         *        events.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Sum - Use the total traffic across the group. This is a good choice for most cases. Examples include
         *        Elastic IP addresses for EC2 instances that scale manually or automatically.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Mean - Use the average of the traffic across the group. This is a good choice for resources that share
         *        traffic uniformly. Examples include accelerators and load balancers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Max - Use the highest traffic from each resource. This is useful for resources that don't share
         *        traffic and for resources that share that traffic in a non-uniform way. Examples include Amazon
         *        CloudFront and origin resources for CloudFront distributions.
         *        </p>
         *        </li>
         * @see ProtectionGroupAggregation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectionGroupAggregation
         */
        Builder aggregation(ProtectionGroupAggregation aggregation);

        /**
         * <p>
         * The criteria to use to choose the protected resources for inclusion in the group. You can include all
         * resources that have protections, provide a list of resource Amazon Resource Names (ARNs), or include all
         * resources of a specified resource type.
         * </p>
         * 
         * @param pattern
         *        The criteria to use to choose the protected resources for inclusion in the group. You can include all
         *        resources that have protections, provide a list of resource Amazon Resource Names (ARNs), or include
         *        all resources of a specified resource type.
         * @see ProtectionGroupPattern
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectionGroupPattern
         */
        Builder pattern(String pattern);

        /**
         * <p>
         * The criteria to use to choose the protected resources for inclusion in the group. You can include all
         * resources that have protections, provide a list of resource Amazon Resource Names (ARNs), or include all
         * resources of a specified resource type.
         * </p>
         * 
         * @param pattern
         *        The criteria to use to choose the protected resources for inclusion in the group. You can include all
         *        resources that have protections, provide a list of resource Amazon Resource Names (ARNs), or include
         *        all resources of a specified resource type.
         * @see ProtectionGroupPattern
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectionGroupPattern
         */
        Builder pattern(ProtectionGroupPattern pattern);

        /**
         * <p>
         * The resource type to include in the protection group. All protected resources of this type are included in
         * the protection group. Newly protected resources of this type are automatically added to the group. You must
         * set this when you set <code>Pattern</code> to <code>BY_RESOURCE_TYPE</code> and you must not set it for any
         * other <code>Pattern</code> setting.
         * </p>
         * 
         * @param resourceType
         *        The resource type to include in the protection group. All protected resources of this type are
         *        included in the protection group. Newly protected resources of this type are automatically added to
         *        the group. You must set this when you set <code>Pattern</code> to <code>BY_RESOURCE_TYPE</code> and
         *        you must not set it for any other <code>Pattern</code> setting.
         * @see ProtectedResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectedResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The resource type to include in the protection group. All protected resources of this type are included in
         * the protection group. Newly protected resources of this type are automatically added to the group. You must
         * set this when you set <code>Pattern</code> to <code>BY_RESOURCE_TYPE</code> and you must not set it for any
         * other <code>Pattern</code> setting.
         * </p>
         * 
         * @param resourceType
         *        The resource type to include in the protection group. All protected resources of this type are
         *        included in the protection group. Newly protected resources of this type are automatically added to
         *        the group. You must set this when you set <code>Pattern</code> to <code>BY_RESOURCE_TYPE</code> and
         *        you must not set it for any other <code>Pattern</code> setting.
         * @see ProtectedResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectedResourceType
         */
        Builder resourceType(ProtectedResourceType resourceType);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the resources to include in the protection group. You must set this when
         * you set <code>Pattern</code> to <code>ARBITRARY</code> and you must not set it for any other
         * <code>Pattern</code> setting.
         * </p>
         * 
         * @param members
         *        The Amazon Resource Names (ARNs) of the resources to include in the protection group. You must set
         *        this when you set <code>Pattern</code> to <code>ARBITRARY</code> and you must not set it for any other
         *        <code>Pattern</code> setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder members(Collection<String> members);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the resources to include in the protection group. You must set this when
         * you set <code>Pattern</code> to <code>ARBITRARY</code> and you must not set it for any other
         * <code>Pattern</code> setting.
         * </p>
         * 
         * @param members
         *        The Amazon Resource Names (ARNs) of the resources to include in the protection group. You must set
         *        this when you set <code>Pattern</code> to <code>ARBITRARY</code> and you must not set it for any other
         *        <code>Pattern</code> setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder members(String... members);

        /**
         * <p>
         * One or more tag key-value pairs for the protection group.
         * </p>
         * 
         * @param tags
         *        One or more tag key-value pairs for the protection group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * One or more tag key-value pairs for the protection group.
         * </p>
         * 
         * @param tags
         *        One or more tag key-value pairs for the protection group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * One or more tag key-value pairs for the protection group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.shield.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.shield.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.shield.model.Tag.Builder#build()}
         * is called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.shield.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ShieldRequest.BuilderImpl implements Builder {
        private String protectionGroupId;

        private String aggregation;

        private String pattern;

        private String resourceType;

        private List<String> members = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProtectionGroupRequest model) {
            super(model);
            protectionGroupId(model.protectionGroupId);
            aggregation(model.aggregation);
            pattern(model.pattern);
            resourceType(model.resourceType);
            members(model.members);
            tags(model.tags);
        }

        public final String getProtectionGroupId() {
            return protectionGroupId;
        }

        public final void setProtectionGroupId(String protectionGroupId) {
            this.protectionGroupId = protectionGroupId;
        }

        @Override
        public final Builder protectionGroupId(String protectionGroupId) {
            this.protectionGroupId = protectionGroupId;
            return this;
        }

        public final String getAggregation() {
            return aggregation;
        }

        public final void setAggregation(String aggregation) {
            this.aggregation = aggregation;
        }

        @Override
        public final Builder aggregation(String aggregation) {
            this.aggregation = aggregation;
            return this;
        }

        @Override
        public final Builder aggregation(ProtectionGroupAggregation aggregation) {
            this.aggregation(aggregation == null ? null : aggregation.toString());
            return this;
        }

        public final String getPattern() {
            return pattern;
        }

        public final void setPattern(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public final Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        @Override
        public final Builder pattern(ProtectionGroupPattern pattern) {
            this.pattern(pattern == null ? null : pattern.toString());
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ProtectedResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final Collection<String> getMembers() {
            if (members instanceof SdkAutoConstructList) {
                return null;
            }
            return members;
        }

        public final void setMembers(Collection<String> members) {
            this.members = ProtectionGroupMembersCopier.copy(members);
        }

        @Override
        public final Builder members(Collection<String> members) {
            this.members = ProtectionGroupMembersCopier.copy(members);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(String... members) {
            members(Arrays.asList(members));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProtectionGroupRequest build() {
            return new CreateProtectionGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
