/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.shield.model.AttackVolumeStatistics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttackVolume
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AttackVolume> {
    private static final SdkField<AttackVolumeStatistics> BITS_PER_SECOND_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BitsPerSecond").getter(AttackVolume.getter(AttackVolume::bitsPerSecond)).setter(AttackVolume.setter(Builder::bitsPerSecond)).constructor(AttackVolumeStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BitsPerSecond").build()}).build();
    private static final SdkField<AttackVolumeStatistics> PACKETS_PER_SECOND_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PacketsPerSecond").getter(AttackVolume.getter(AttackVolume::packetsPerSecond)).setter(AttackVolume.setter(Builder::packetsPerSecond)).constructor(AttackVolumeStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PacketsPerSecond").build()}).build();
    private static final SdkField<AttackVolumeStatistics> REQUESTS_PER_SECOND_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RequestsPerSecond").getter(AttackVolume.getter(AttackVolume::requestsPerSecond)).setter(AttackVolume.setter(Builder::requestsPerSecond)).constructor(AttackVolumeStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestsPerSecond").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BITS_PER_SECOND_FIELD, PACKETS_PER_SECOND_FIELD, REQUESTS_PER_SECOND_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AttackVolume.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AttackVolumeStatistics bitsPerSecond;
    private final AttackVolumeStatistics packetsPerSecond;
    private final AttackVolumeStatistics requestsPerSecond;

    private AttackVolume(BuilderImpl builder) {
        this.bitsPerSecond = builder.bitsPerSecond;
        this.packetsPerSecond = builder.packetsPerSecond;
        this.requestsPerSecond = builder.requestsPerSecond;
    }

    public final AttackVolumeStatistics bitsPerSecond() {
        return this.bitsPerSecond;
    }

    public final AttackVolumeStatistics packetsPerSecond() {
        return this.packetsPerSecond;
    }

    public final AttackVolumeStatistics requestsPerSecond() {
        return this.requestsPerSecond;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bitsPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(this.packetsPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestsPerSecond());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttackVolume)) {
            return false;
        }
        AttackVolume other = (AttackVolume)obj;
        return Objects.equals(this.bitsPerSecond(), other.bitsPerSecond()) && Objects.equals(this.packetsPerSecond(), other.packetsPerSecond()) && Objects.equals(this.requestsPerSecond(), other.requestsPerSecond());
    }

    public final String toString() {
        return ToString.builder((String)"AttackVolume").add("BitsPerSecond", (Object)this.bitsPerSecond()).add("PacketsPerSecond", (Object)this.packetsPerSecond()).add("RequestsPerSecond", (Object)this.requestsPerSecond()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BitsPerSecond": {
                return Optional.ofNullable(clazz.cast(this.bitsPerSecond()));
            }
            case "PacketsPerSecond": {
                return Optional.ofNullable(clazz.cast(this.packetsPerSecond()));
            }
            case "RequestsPerSecond": {
                return Optional.ofNullable(clazz.cast(this.requestsPerSecond()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<AttackVolumeStatistics>> map = new HashMap<String, SdkField<AttackVolumeStatistics>>();
        map.put("BitsPerSecond", BITS_PER_SECOND_FIELD);
        map.put("PacketsPerSecond", PACKETS_PER_SECOND_FIELD);
        map.put("RequestsPerSecond", REQUESTS_PER_SECOND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AttackVolume, T> g) {
        return obj -> g.apply((AttackVolume)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AttackVolumeStatistics bitsPerSecond;
        private AttackVolumeStatistics packetsPerSecond;
        private AttackVolumeStatistics requestsPerSecond;

        private BuilderImpl() {
        }

        private BuilderImpl(AttackVolume model) {
            this.bitsPerSecond(model.bitsPerSecond);
            this.packetsPerSecond(model.packetsPerSecond);
            this.requestsPerSecond(model.requestsPerSecond);
        }

        public final AttackVolumeStatistics.Builder getBitsPerSecond() {
            return this.bitsPerSecond != null ? this.bitsPerSecond.toBuilder() : null;
        }

        public final void setBitsPerSecond(AttackVolumeStatistics.BuilderImpl bitsPerSecond) {
            this.bitsPerSecond = bitsPerSecond != null ? bitsPerSecond.build() : null;
        }

        @Override
        public final Builder bitsPerSecond(AttackVolumeStatistics bitsPerSecond) {
            this.bitsPerSecond = bitsPerSecond;
            return this;
        }

        public final AttackVolumeStatistics.Builder getPacketsPerSecond() {
            return this.packetsPerSecond != null ? this.packetsPerSecond.toBuilder() : null;
        }

        public final void setPacketsPerSecond(AttackVolumeStatistics.BuilderImpl packetsPerSecond) {
            this.packetsPerSecond = packetsPerSecond != null ? packetsPerSecond.build() : null;
        }

        @Override
        public final Builder packetsPerSecond(AttackVolumeStatistics packetsPerSecond) {
            this.packetsPerSecond = packetsPerSecond;
            return this;
        }

        public final AttackVolumeStatistics.Builder getRequestsPerSecond() {
            return this.requestsPerSecond != null ? this.requestsPerSecond.toBuilder() : null;
        }

        public final void setRequestsPerSecond(AttackVolumeStatistics.BuilderImpl requestsPerSecond) {
            this.requestsPerSecond = requestsPerSecond != null ? requestsPerSecond.build() : null;
        }

        @Override
        public final Builder requestsPerSecond(AttackVolumeStatistics requestsPerSecond) {
            this.requestsPerSecond = requestsPerSecond;
            return this;
        }

        public AttackVolume build() {
            return new AttackVolume(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AttackVolume> {
        public Builder bitsPerSecond(AttackVolumeStatistics var1);

        default public Builder bitsPerSecond(Consumer<AttackVolumeStatistics.Builder> bitsPerSecond) {
            return this.bitsPerSecond((AttackVolumeStatistics)((AttackVolumeStatistics.Builder)AttackVolumeStatistics.builder().applyMutation(bitsPerSecond)).build());
        }

        public Builder packetsPerSecond(AttackVolumeStatistics var1);

        default public Builder packetsPerSecond(Consumer<AttackVolumeStatistics.Builder> packetsPerSecond) {
            return this.packetsPerSecond((AttackVolumeStatistics)((AttackVolumeStatistics.Builder)AttackVolumeStatistics.builder().applyMutation(packetsPerSecond)).build());
        }

        public Builder requestsPerSecond(AttackVolumeStatistics var1);

        default public Builder requestsPerSecond(Consumer<AttackVolumeStatistics.Builder> requestsPerSecond) {
            return this.requestsPerSecond((AttackVolumeStatistics)((AttackVolumeStatistics.Builder)AttackVolumeStatistics.builder().applyMutation(requestsPerSecond)).build());
        }
    }
}

