/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.shield.DefaultShieldBaseClientBuilder;
import software.amazon.awssdk.services.shield.DefaultShieldClient;
import software.amazon.awssdk.services.shield.ShieldClient;
import software.amazon.awssdk.services.shield.ShieldClientBuilder;
import software.amazon.awssdk.services.shield.ShieldServiceClientConfiguration;
import software.amazon.awssdk.services.shield.endpoints.ShieldEndpointProvider;

@SdkInternalApi
final class DefaultShieldClientBuilder
extends DefaultShieldBaseClientBuilder<ShieldClientBuilder, ShieldClient>
implements ShieldClientBuilder {
    DefaultShieldClientBuilder() {
    }

    @Override
    public DefaultShieldClientBuilder endpointProvider(ShieldEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ShieldClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultShieldClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        ShieldServiceClientConfiguration serviceClientConfiguration = ShieldServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultShieldClient(serviceClientConfiguration, clientConfiguration);
    }
}

