/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ProtectedResourceType {
    CLOUDFRONT_DISTRIBUTION("CLOUDFRONT_DISTRIBUTION"),
    ROUTE_53_HOSTED_ZONE("ROUTE_53_HOSTED_ZONE"),
    ELASTIC_IP_ALLOCATION("ELASTIC_IP_ALLOCATION"),
    CLASSIC_LOAD_BALANCER("CLASSIC_LOAD_BALANCER"),
    APPLICATION_LOAD_BALANCER("APPLICATION_LOAD_BALANCER"),
    GLOBAL_ACCELERATOR("GLOBAL_ACCELERATOR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ProtectedResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ProtectedResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ProtectedResourceType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ProtectedResourceType> knownValues() {
        return Stream.of(ProtectedResourceType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

