/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.shield.model.Limit;
import software.amazon.awssdk.services.shield.model.LimitsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProtectionLimits
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProtectionLimits> {
    private static final SdkField<List<Limit>> PROTECTED_RESOURCE_TYPE_LIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProtectedResourceTypeLimits").getter(ProtectionLimits.getter(ProtectionLimits::protectedResourceTypeLimits)).setter(ProtectionLimits.setter(Builder::protectedResourceTypeLimits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectedResourceTypeLimits").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Limit::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTECTED_RESOURCE_TYPE_LIMITS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Limit> protectedResourceTypeLimits;

    private ProtectionLimits(BuilderImpl builder) {
        this.protectedResourceTypeLimits = builder.protectedResourceTypeLimits;
    }

    public boolean hasProtectedResourceTypeLimits() {
        return this.protectedResourceTypeLimits != null && !(this.protectedResourceTypeLimits instanceof SdkAutoConstructList);
    }

    public List<Limit> protectedResourceTypeLimits() {
        return this.protectedResourceTypeLimits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProtectedResourceTypeLimits() ? this.protectedResourceTypeLimits() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectionLimits)) {
            return false;
        }
        ProtectionLimits other = (ProtectionLimits)obj;
        return this.hasProtectedResourceTypeLimits() == other.hasProtectedResourceTypeLimits() && Objects.equals(this.protectedResourceTypeLimits(), other.protectedResourceTypeLimits());
    }

    public String toString() {
        return ToString.builder((String)"ProtectionLimits").add("ProtectedResourceTypeLimits", this.hasProtectedResourceTypeLimits() ? this.protectedResourceTypeLimits() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProtectedResourceTypeLimits": {
                return Optional.ofNullable(clazz.cast(this.protectedResourceTypeLimits()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProtectionLimits, T> g) {
        return obj -> g.apply((ProtectionLimits)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Limit> protectedResourceTypeLimits = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectionLimits model) {
            this.protectedResourceTypeLimits(model.protectedResourceTypeLimits);
        }

        public final Collection<Limit.Builder> getProtectedResourceTypeLimits() {
            if (this.protectedResourceTypeLimits instanceof SdkAutoConstructList) {
                return null;
            }
            return this.protectedResourceTypeLimits != null ? (Collection)this.protectedResourceTypeLimits.stream().map(Limit::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder protectedResourceTypeLimits(Collection<Limit> protectedResourceTypeLimits) {
            this.protectedResourceTypeLimits = LimitsCopier.copy(protectedResourceTypeLimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protectedResourceTypeLimits(Limit ... protectedResourceTypeLimits) {
            this.protectedResourceTypeLimits(Arrays.asList(protectedResourceTypeLimits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protectedResourceTypeLimits(Consumer<Limit.Builder> ... protectedResourceTypeLimits) {
            this.protectedResourceTypeLimits(Stream.of(protectedResourceTypeLimits).map(c -> (Limit)((Limit.Builder)Limit.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProtectedResourceTypeLimits(Collection<Limit.BuilderImpl> protectedResourceTypeLimits) {
            this.protectedResourceTypeLimits = LimitsCopier.copyFromBuilder(protectedResourceTypeLimits);
        }

        public ProtectionLimits build() {
            return new ProtectionLimits(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProtectionLimits> {
        public Builder protectedResourceTypeLimits(Collection<Limit> var1);

        public Builder protectedResourceTypeLimits(Limit ... var1);

        public Builder protectedResourceTypeLimits(Consumer<Limit.Builder> ... var1);
    }
}

