/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The counter that describes a DDoS attack.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SummarizedCounter implements SdkPojo, Serializable,
        ToCopyableBuilder<SummarizedCounter.Builder, SummarizedCounter> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SummarizedCounter::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Double> MAX_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(SummarizedCounter::max)).setter(setter(Builder::max))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Max").build()).build();

    private static final SdkField<Double> AVERAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(SummarizedCounter::average)).setter(setter(Builder::average))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Average").build()).build();

    private static final SdkField<Double> SUM_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(SummarizedCounter::sum)).setter(setter(Builder::sum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sum").build()).build();

    private static final SdkField<Integer> N_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SummarizedCounter::n)).setter(setter(Builder::n))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("N").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SummarizedCounter::unit)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MAX_FIELD,
            AVERAGE_FIELD, SUM_FIELD, N_FIELD, UNIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Double max;

    private final Double average;

    private final Double sum;

    private final Integer n;

    private final String unit;

    private SummarizedCounter(BuilderImpl builder) {
        this.name = builder.name;
        this.max = builder.max;
        this.average = builder.average;
        this.sum = builder.sum;
        this.n = builder.n;
        this.unit = builder.unit;
    }

    /**
     * <p>
     * The counter name.
     * </p>
     * 
     * @return The counter name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The maximum value of the counter for a specified time period.
     * </p>
     * 
     * @return The maximum value of the counter for a specified time period.
     */
    public Double max() {
        return max;
    }

    /**
     * <p>
     * The average value of the counter for a specified time period.
     * </p>
     * 
     * @return The average value of the counter for a specified time period.
     */
    public Double average() {
        return average;
    }

    /**
     * <p>
     * The total of counter values for a specified time period.
     * </p>
     * 
     * @return The total of counter values for a specified time period.
     */
    public Double sum() {
        return sum;
    }

    /**
     * <p>
     * The number of counters for a specified time period.
     * </p>
     * 
     * @return The number of counters for a specified time period.
     */
    public Integer n() {
        return n;
    }

    /**
     * <p>
     * The unit of the counters.
     * </p>
     * 
     * @return The unit of the counters.
     */
    public String unit() {
        return unit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(max());
        hashCode = 31 * hashCode + Objects.hashCode(average());
        hashCode = 31 * hashCode + Objects.hashCode(sum());
        hashCode = 31 * hashCode + Objects.hashCode(n());
        hashCode = 31 * hashCode + Objects.hashCode(unit());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SummarizedCounter)) {
            return false;
        }
        SummarizedCounter other = (SummarizedCounter) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(max(), other.max())
                && Objects.equals(average(), other.average()) && Objects.equals(sum(), other.sum())
                && Objects.equals(n(), other.n()) && Objects.equals(unit(), other.unit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SummarizedCounter").add("Name", name()).add("Max", max()).add("Average", average())
                .add("Sum", sum()).add("N", n()).add("Unit", unit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Max":
            return Optional.ofNullable(clazz.cast(max()));
        case "Average":
            return Optional.ofNullable(clazz.cast(average()));
        case "Sum":
            return Optional.ofNullable(clazz.cast(sum()));
        case "N":
            return Optional.ofNullable(clazz.cast(n()));
        case "Unit":
            return Optional.ofNullable(clazz.cast(unit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SummarizedCounter, T> g) {
        return obj -> g.apply((SummarizedCounter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SummarizedCounter> {
        /**
         * <p>
         * The counter name.
         * </p>
         * 
         * @param name
         *        The counter name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The maximum value of the counter for a specified time period.
         * </p>
         * 
         * @param max
         *        The maximum value of the counter for a specified time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder max(Double max);

        /**
         * <p>
         * The average value of the counter for a specified time period.
         * </p>
         * 
         * @param average
         *        The average value of the counter for a specified time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder average(Double average);

        /**
         * <p>
         * The total of counter values for a specified time period.
         * </p>
         * 
         * @param sum
         *        The total of counter values for a specified time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sum(Double sum);

        /**
         * <p>
         * The number of counters for a specified time period.
         * </p>
         * 
         * @param n
         *        The number of counters for a specified time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder n(Integer n);

        /**
         * <p>
         * The unit of the counters.
         * </p>
         * 
         * @param unit
         *        The unit of the counters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unit(String unit);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Double max;

        private Double average;

        private Double sum;

        private Integer n;

        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(SummarizedCounter model) {
            name(model.name);
            max(model.max);
            average(model.average);
            sum(model.sum);
            n(model.n);
            unit(model.unit);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Double getMax() {
            return max;
        }

        @Override
        public final Builder max(Double max) {
            this.max = max;
            return this;
        }

        public final void setMax(Double max) {
            this.max = max;
        }

        public final Double getAverage() {
            return average;
        }

        @Override
        public final Builder average(Double average) {
            this.average = average;
            return this;
        }

        public final void setAverage(Double average) {
            this.average = average;
        }

        public final Double getSum() {
            return sum;
        }

        @Override
        public final Builder sum(Double sum) {
            this.sum = sum;
            return this;
        }

        public final void setSum(Double sum) {
            this.sum = sum;
        }

        public final Integer getN() {
            return n;
        }

        @Override
        public final Builder n(Integer n) {
            this.n = n;
            return this;
        }

        public final void setN(Integer n) {
            this.n = n;
        }

        public final String getUnit() {
            return unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public SummarizedCounter build() {
            return new SummarizedCounter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
