/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.shield.model.AssociateDrtLogBucketRequest;
import software.amazon.awssdk.services.shield.model.AssociateDrtLogBucketResponse;
import software.amazon.awssdk.services.shield.model.AssociateDrtRoleRequest;
import software.amazon.awssdk.services.shield.model.AssociateDrtRoleResponse;
import software.amazon.awssdk.services.shield.model.CreateProtectionRequest;
import software.amazon.awssdk.services.shield.model.CreateProtectionResponse;
import software.amazon.awssdk.services.shield.model.CreateSubscriptionRequest;
import software.amazon.awssdk.services.shield.model.CreateSubscriptionResponse;
import software.amazon.awssdk.services.shield.model.DeleteProtectionRequest;
import software.amazon.awssdk.services.shield.model.DeleteProtectionResponse;
import software.amazon.awssdk.services.shield.model.DescribeAttackRequest;
import software.amazon.awssdk.services.shield.model.DescribeAttackResponse;
import software.amazon.awssdk.services.shield.model.DescribeDrtAccessRequest;
import software.amazon.awssdk.services.shield.model.DescribeDrtAccessResponse;
import software.amazon.awssdk.services.shield.model.DescribeEmergencyContactSettingsRequest;
import software.amazon.awssdk.services.shield.model.DescribeEmergencyContactSettingsResponse;
import software.amazon.awssdk.services.shield.model.DescribeProtectionRequest;
import software.amazon.awssdk.services.shield.model.DescribeProtectionResponse;
import software.amazon.awssdk.services.shield.model.DescribeSubscriptionRequest;
import software.amazon.awssdk.services.shield.model.DescribeSubscriptionResponse;
import software.amazon.awssdk.services.shield.model.DisassociateDrtLogBucketRequest;
import software.amazon.awssdk.services.shield.model.DisassociateDrtLogBucketResponse;
import software.amazon.awssdk.services.shield.model.DisassociateDrtRoleRequest;
import software.amazon.awssdk.services.shield.model.DisassociateDrtRoleResponse;
import software.amazon.awssdk.services.shield.model.GetSubscriptionStateRequest;
import software.amazon.awssdk.services.shield.model.GetSubscriptionStateResponse;
import software.amazon.awssdk.services.shield.model.ListAttacksRequest;
import software.amazon.awssdk.services.shield.model.ListAttacksResponse;
import software.amazon.awssdk.services.shield.model.ListProtectionsRequest;
import software.amazon.awssdk.services.shield.model.ListProtectionsResponse;
import software.amazon.awssdk.services.shield.model.UpdateEmergencyContactSettingsRequest;
import software.amazon.awssdk.services.shield.model.UpdateEmergencyContactSettingsResponse;
import software.amazon.awssdk.services.shield.model.UpdateSubscriptionRequest;
import software.amazon.awssdk.services.shield.model.UpdateSubscriptionResponse;

/**
 * Service client for accessing AWS Shield asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <fullname>AWS Shield Advanced</fullname>
 * <p>
 * This is the <i>AWS Shield Advanced API Reference</i>. This guide is for developers who need detailed information
 * about the AWS Shield Advanced API actions, data types, and errors. For detailed information about AWS WAF and AWS
 * Shield Advanced features and an overview of how to use the AWS WAF and AWS Shield Advanced APIs, see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF and AWS Shield Developer Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface ShieldAsyncClient extends SdkClient {
    String SERVICE_NAME = "shield";

    /**
     * Create a {@link ShieldAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ShieldAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ShieldAsyncClient}.
     */
    static ShieldAsyncClientBuilder builder() {
        return new DefaultShieldAsyncClientBuilder();
    }

    /**
     * <p>
     * Authorizes the DDoS Response team (DRT) to access the specified Amazon S3 bucket containing your AWS WAF logs.
     * You can associate up to 10 Amazon S3 buckets with your subscription.
     * </p>
     * <p>
     * To use the services of the DRT and make an <code>AssociateDRTLogBucket</code> request, you must be subscribed to
     * the <a href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>.
     * </p>
     *
     * @param associateDrtLogBucketRequest
     * @return A Java Future containing the result of the AssociateDRTLogBucket operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>NoAssociatedRoleException The ARN of the role that you specifed does not exist.</li>
     *         <li>LimitsExceededException Exception that indicates that the operation would exceed a limit.</p>
     *         <p>
     *         <code>Type</code> is the type of limit that would be exceeded.
     *         </p>
     *         <p>
     *         <code>Limit</code> is the threshold that would be exceeded.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         </li>
     *         <li>AccessDeniedForDependencyException In order to grant the necessary access to the DDoS Response Team,
     *         the user submitting <code>AssociateDRTRole</code> must have the <code>iam:PassRole</code> permission.
     *         This error indicates the user did not have the appropriate permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a User
     *         Permissions to Pass a Role to an AWS Service</a>.</li>
     *         <li>OptimisticLockException Exception that indicates that the protection state has been modified by
     *         another client. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.AssociateDRTLogBucket
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/AssociateDRTLogBucket" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateDrtLogBucketResponse> associateDRTLogBucket(
            AssociateDrtLogBucketRequest associateDrtLogBucketRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Authorizes the DDoS Response team (DRT) to access the specified Amazon S3 bucket containing your AWS WAF logs.
     * You can associate up to 10 Amazon S3 buckets with your subscription.
     * </p>
     * <p>
     * To use the services of the DRT and make an <code>AssociateDRTLogBucket</code> request, you must be subscribed to
     * the <a href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateDrtLogBucketRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateDrtLogBucketRequest#builder()}
     * </p>
     *
     * @param associateDrtLogBucketRequest
     *        A {@link Consumer} that will call methods on {@link AssociateDRTLogBucketRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateDRTLogBucket operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>NoAssociatedRoleException The ARN of the role that you specifed does not exist.</li>
     *         <li>LimitsExceededException Exception that indicates that the operation would exceed a limit.</p>
     *         <p>
     *         <code>Type</code> is the type of limit that would be exceeded.
     *         </p>
     *         <p>
     *         <code>Limit</code> is the threshold that would be exceeded.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         </li>
     *         <li>AccessDeniedForDependencyException In order to grant the necessary access to the DDoS Response Team,
     *         the user submitting <code>AssociateDRTRole</code> must have the <code>iam:PassRole</code> permission.
     *         This error indicates the user did not have the appropriate permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a User
     *         Permissions to Pass a Role to an AWS Service</a>.</li>
     *         <li>OptimisticLockException Exception that indicates that the protection state has been modified by
     *         another client. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.AssociateDRTLogBucket
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/AssociateDRTLogBucket" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateDrtLogBucketResponse> associateDRTLogBucket(
            Consumer<AssociateDrtLogBucketRequest.Builder> associateDrtLogBucketRequest) {
        return associateDRTLogBucket(AssociateDrtLogBucketRequest.builder().applyMutation(associateDrtLogBucketRequest).build());
    }

    /**
     * <p>
     * Authorizes the DDoS Response team (DRT), using the specified role, to access your AWS account to assist with DDoS
     * attack mitigation during potential attacks. This enables the DRT to inspect your AWS WAF configuration and create
     * or update AWS WAF rules and web ACLs.
     * </p>
     * <p>
     * You can associate only one <code>RoleArn</code> with your subscription. If you submit an
     * <code>AssociateDRTRole</code> request for an account that already has an associated role, the new
     * <code>RoleArn</code> will replace the existing <code>RoleArn</code>.
     * </p>
     * <p>
     * Prior to making the <code>AssociateDRTRole</code> request, you must attach the <a href=
     * "https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy"
     * >AWSShieldDRTAccessPolicy</a> managed policy to the role you will specify in the request. For more information
     * see <a
     * href=" https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_manage-attach-detach.html">Attaching and
     * Detaching IAM Policies</a>. The role must also trust the service principal <code> drt.shield.amazonaws.com</code>
     * . For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html">IAM JSON
     * Policy Elements: Principal</a>.
     * </p>
     * <p>
     * The DRT will have access only to your AWS WAF and Shield resources. By submitting this request, you authorize the
     * DRT to inspect your AWS WAF and Shield configuration and create and update AWS WAF rules and web ACLs on your
     * behalf. The DRT takes these actions only if explicitly authorized by you.
     * </p>
     * <p>
     * You must have the <code>iam:PassRole</code> permission to make an <code>AssociateDRTRole</code> request. For more
     * information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a
     * User Permissions to Pass a Role to an AWS Service</a>.
     * </p>
     * <p>
     * To use the services of the DRT and make an <code>AssociateDRTRole</code> request, you must be subscribed to the
     * <a href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>.
     * </p>
     *
     * @param associateDrtRoleRequest
     * @return A Java Future containing the result of the AssociateDRTRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         </li>
     *         <li>AccessDeniedForDependencyException In order to grant the necessary access to the DDoS Response Team,
     *         the user submitting <code>AssociateDRTRole</code> must have the <code>iam:PassRole</code> permission.
     *         This error indicates the user did not have the appropriate permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a User
     *         Permissions to Pass a Role to an AWS Service</a>.</li>
     *         <li>OptimisticLockException Exception that indicates that the protection state has been modified by
     *         another client. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.AssociateDRTRole
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/AssociateDRTRole" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateDrtRoleResponse> associateDRTRole(AssociateDrtRoleRequest associateDrtRoleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Authorizes the DDoS Response team (DRT), using the specified role, to access your AWS account to assist with DDoS
     * attack mitigation during potential attacks. This enables the DRT to inspect your AWS WAF configuration and create
     * or update AWS WAF rules and web ACLs.
     * </p>
     * <p>
     * You can associate only one <code>RoleArn</code> with your subscription. If you submit an
     * <code>AssociateDRTRole</code> request for an account that already has an associated role, the new
     * <code>RoleArn</code> will replace the existing <code>RoleArn</code>.
     * </p>
     * <p>
     * Prior to making the <code>AssociateDRTRole</code> request, you must attach the <a href=
     * "https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy"
     * >AWSShieldDRTAccessPolicy</a> managed policy to the role you will specify in the request. For more information
     * see <a
     * href=" https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_manage-attach-detach.html">Attaching and
     * Detaching IAM Policies</a>. The role must also trust the service principal <code> drt.shield.amazonaws.com</code>
     * . For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html">IAM JSON
     * Policy Elements: Principal</a>.
     * </p>
     * <p>
     * The DRT will have access only to your AWS WAF and Shield resources. By submitting this request, you authorize the
     * DRT to inspect your AWS WAF and Shield configuration and create and update AWS WAF rules and web ACLs on your
     * behalf. The DRT takes these actions only if explicitly authorized by you.
     * </p>
     * <p>
     * You must have the <code>iam:PassRole</code> permission to make an <code>AssociateDRTRole</code> request. For more
     * information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a
     * User Permissions to Pass a Role to an AWS Service</a>.
     * </p>
     * <p>
     * To use the services of the DRT and make an <code>AssociateDRTRole</code> request, you must be subscribed to the
     * <a href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateDrtRoleRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateDrtRoleRequest#builder()}
     * </p>
     *
     * @param associateDrtRoleRequest
     *        A {@link Consumer} that will call methods on {@link AssociateDRTRoleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AssociateDRTRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         </li>
     *         <li>AccessDeniedForDependencyException In order to grant the necessary access to the DDoS Response Team,
     *         the user submitting <code>AssociateDRTRole</code> must have the <code>iam:PassRole</code> permission.
     *         This error indicates the user did not have the appropriate permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a User
     *         Permissions to Pass a Role to an AWS Service</a>.</li>
     *         <li>OptimisticLockException Exception that indicates that the protection state has been modified by
     *         another client. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.AssociateDRTRole
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/AssociateDRTRole" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateDrtRoleResponse> associateDRTRole(
            Consumer<AssociateDrtRoleRequest.Builder> associateDrtRoleRequest) {
        return associateDRTRole(AssociateDrtRoleRequest.builder().applyMutation(associateDrtRoleRequest).build());
    }

    /**
     * <p>
     * Enables AWS Shield Advanced for a specific AWS resource. The resource can be an Amazon CloudFront distribution,
     * Elastic Load Balancing load balancer, AWS Global Accelerator accelerator, Elastic IP Address, or an Amazon Route
     * 53 hosted zone.
     * </p>
     * <p>
     * You can add protection to only a single resource with each CreateProtection request. If you want to add
     * protection to multiple resources at once, use the <a href="https://console.aws.amazon.com/waf/">AWS WAF
     * console</a>. For more information see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/getting-started-ddos.html">Getting Started with AWS
     * Shield Advanced</a> and <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/configure-new-protection.html">Add AWS Shield
     * Advanced Protection to more AWS Resources</a>.
     * </p>
     *
     * @param createProtectionRequest
     * @return A Java Future containing the result of the CreateProtection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidResourceException Exception that indicates that the resource is invalid. You might not have
     *         access to the resource, or the resource might not exist.</li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>LimitsExceededException Exception that indicates that the operation would exceed a limit.</p>
     *         <p>
     *         <code>Type</code> is the type of limit that would be exceeded.
     *         </p>
     *         <p>
     *         <code>Limit</code> is the threshold that would be exceeded.</li>
     *         <li>ResourceAlreadyExistsException Exception indicating the specified resource already exists.</li>
     *         <li>OptimisticLockException Exception that indicates that the protection state has been modified by
     *         another client. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.CreateProtection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateProtection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateProtectionResponse> createProtection(CreateProtectionRequest createProtectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables AWS Shield Advanced for a specific AWS resource. The resource can be an Amazon CloudFront distribution,
     * Elastic Load Balancing load balancer, AWS Global Accelerator accelerator, Elastic IP Address, or an Amazon Route
     * 53 hosted zone.
     * </p>
     * <p>
     * You can add protection to only a single resource with each CreateProtection request. If you want to add
     * protection to multiple resources at once, use the <a href="https://console.aws.amazon.com/waf/">AWS WAF
     * console</a>. For more information see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/getting-started-ddos.html">Getting Started with AWS
     * Shield Advanced</a> and <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/configure-new-protection.html">Add AWS Shield
     * Advanced Protection to more AWS Resources</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProtectionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateProtectionRequest#builder()}
     * </p>
     *
     * @param createProtectionRequest
     *        A {@link Consumer} that will call methods on {@link CreateProtectionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateProtection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidResourceException Exception that indicates that the resource is invalid. You might not have
     *         access to the resource, or the resource might not exist.</li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>LimitsExceededException Exception that indicates that the operation would exceed a limit.</p>
     *         <p>
     *         <code>Type</code> is the type of limit that would be exceeded.
     *         </p>
     *         <p>
     *         <code>Limit</code> is the threshold that would be exceeded.</li>
     *         <li>ResourceAlreadyExistsException Exception indicating the specified resource already exists.</li>
     *         <li>OptimisticLockException Exception that indicates that the protection state has been modified by
     *         another client. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.CreateProtection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateProtection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateProtectionResponse> createProtection(
            Consumer<CreateProtectionRequest.Builder> createProtectionRequest) {
        return createProtection(CreateProtectionRequest.builder().applyMutation(createProtectionRequest).build());
    }

    /**
     * <p>
     * Activates AWS Shield Advanced for an account.
     * </p>
     * <p>
     * As part of this request you can specify <code>EmergencySettings</code> that automaticaly grant the DDoS response
     * team (DRT) needed permissions to assist you during a suspected DDoS attack. For more information see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/authorize-DRT.html">Authorize the DDoS Response Team
     * to Create Rules and Web ACLs on Your Behalf</a>.
     * </p>
     * <p>
     * To use the services of the DRT, you must be subscribed to the <a
     * href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>.
     * </p>
     * <p>
     * When you initally create a subscription, your subscription is set to be automatically renewed at the end of the
     * existing subscription period. You can change this by submitting an <code>UpdateSubscription</code> request.
     * </p>
     *
     * @param createSubscriptionRequest
     * @return A Java Future containing the result of the CreateSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceAlreadyExistsException Exception indicating the specified resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.CreateSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSubscriptionResponse> createSubscription(CreateSubscriptionRequest createSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates AWS Shield Advanced for an account.
     * </p>
     * <p>
     * As part of this request you can specify <code>EmergencySettings</code> that automaticaly grant the DDoS response
     * team (DRT) needed permissions to assist you during a suspected DDoS attack. For more information see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/authorize-DRT.html">Authorize the DDoS Response Team
     * to Create Rules and Web ACLs on Your Behalf</a>.
     * </p>
     * <p>
     * To use the services of the DRT, you must be subscribed to the <a
     * href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>.
     * </p>
     * <p>
     * When you initally create a subscription, your subscription is set to be automatically renewed at the end of the
     * existing subscription period. You can change this by submitting an <code>UpdateSubscription</code> request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSubscriptionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSubscriptionRequest#builder()}
     * </p>
     *
     * @param createSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link CreateSubscriptionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceAlreadyExistsException Exception indicating the specified resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.CreateSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSubscriptionResponse> createSubscription(
            Consumer<CreateSubscriptionRequest.Builder> createSubscriptionRequest) {
        return createSubscription(CreateSubscriptionRequest.builder().applyMutation(createSubscriptionRequest).build());
    }

    /**
     * <p>
     * Activates AWS Shield Advanced for an account.
     * </p>
     * <p>
     * As part of this request you can specify <code>EmergencySettings</code> that automaticaly grant the DDoS response
     * team (DRT) needed permissions to assist you during a suspected DDoS attack. For more information see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/authorize-DRT.html">Authorize the DDoS Response Team
     * to Create Rules and Web ACLs on Your Behalf</a>.
     * </p>
     * <p>
     * To use the services of the DRT, you must be subscribed to the <a
     * href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>.
     * </p>
     * <p>
     * When you initally create a subscription, your subscription is set to be automatically renewed at the end of the
     * existing subscription period. You can change this by submitting an <code>UpdateSubscription</code> request.
     * </p>
     *
     * @return A Java Future containing the result of the CreateSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceAlreadyExistsException Exception indicating the specified resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.CreateSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSubscriptionResponse> createSubscription() {
        return createSubscription(CreateSubscriptionRequest.builder().build());
    }

    /**
     * <p>
     * Deletes an AWS Shield Advanced <a>Protection</a>.
     * </p>
     *
     * @param deleteProtectionRequest
     * @return A Java Future containing the result of the DeleteProtection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist.</li>
     *         <li>OptimisticLockException Exception that indicates that the protection state has been modified by
     *         another client. You can retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DeleteProtection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DeleteProtection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteProtectionResponse> deleteProtection(DeleteProtectionRequest deleteProtectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an AWS Shield Advanced <a>Protection</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProtectionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteProtectionRequest#builder()}
     * </p>
     *
     * @param deleteProtectionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteProtectionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteProtection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist.</li>
     *         <li>OptimisticLockException Exception that indicates that the protection state has been modified by
     *         another client. You can retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DeleteProtection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DeleteProtection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteProtectionResponse> deleteProtection(
            Consumer<DeleteProtectionRequest.Builder> deleteProtectionRequest) {
        return deleteProtection(DeleteProtectionRequest.builder().applyMutation(deleteProtectionRequest).build());
    }

    /**
     * <p>
     * Describes the details of a DDoS attack.
     * </p>
     *
     * @param describeAttackRequest
     * @return A Java Future containing the result of the DescribeAttack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>AccessDeniedException Exception that indicates the specified <code>AttackId</code> does not exist, or
     *         the requester does not have the appropriate permissions to access the <code>AttackId</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DescribeAttack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeAttack" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeAttackResponse> describeAttack(DescribeAttackRequest describeAttackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the details of a DDoS attack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAttackRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeAttackRequest#builder()}
     * </p>
     *
     * @param describeAttackRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAttackRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeAttack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>AccessDeniedException Exception that indicates the specified <code>AttackId</code> does not exist, or
     *         the requester does not have the appropriate permissions to access the <code>AttackId</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DescribeAttack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeAttack" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeAttackResponse> describeAttack(Consumer<DescribeAttackRequest.Builder> describeAttackRequest) {
        return describeAttack(DescribeAttackRequest.builder().applyMutation(describeAttackRequest).build());
    }

    /**
     * <p>
     * Returns the current role and list of Amazon S3 log buckets used by the DDoS Response team (DRT) to access your
     * AWS account while assisting with attack mitigation.
     * </p>
     *
     * @param describeDrtAccessRequest
     * @return A Java Future containing the result of the DescribeDRTAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DescribeDRTAccess
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeDRTAccess" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDrtAccessResponse> describeDRTAccess(DescribeDrtAccessRequest describeDrtAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the current role and list of Amazon S3 log buckets used by the DDoS Response team (DRT) to access your
     * AWS account while assisting with attack mitigation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDrtAccessRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDrtAccessRequest#builder()}
     * </p>
     *
     * @param describeDrtAccessRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDRTAccessRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeDRTAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DescribeDRTAccess
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeDRTAccess" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDrtAccessResponse> describeDRTAccess(
            Consumer<DescribeDrtAccessRequest.Builder> describeDrtAccessRequest) {
        return describeDRTAccess(DescribeDrtAccessRequest.builder().applyMutation(describeDrtAccessRequest).build());
    }

    /**
     * <p>
     * Lists the email addresses that the DRT can use to contact you during a suspected attack.
     * </p>
     *
     * @param describeEmergencyContactSettingsRequest
     * @return A Java Future containing the result of the DescribeEmergencyContactSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DescribeEmergencyContactSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeEmergencyContactSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEmergencyContactSettingsResponse> describeEmergencyContactSettings(
            DescribeEmergencyContactSettingsRequest describeEmergencyContactSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the email addresses that the DRT can use to contact you during a suspected attack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEmergencyContactSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeEmergencyContactSettingsRequest#builder()}
     * </p>
     *
     * @param describeEmergencyContactSettingsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEmergencyContactSettingsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeEmergencyContactSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DescribeEmergencyContactSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeEmergencyContactSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEmergencyContactSettingsResponse> describeEmergencyContactSettings(
            Consumer<DescribeEmergencyContactSettingsRequest.Builder> describeEmergencyContactSettingsRequest) {
        return describeEmergencyContactSettings(DescribeEmergencyContactSettingsRequest.builder()
                .applyMutation(describeEmergencyContactSettingsRequest).build());
    }

    /**
     * <p>
     * Lists the details of a <a>Protection</a> object.
     * </p>
     *
     * @param describeProtectionRequest
     * @return A Java Future containing the result of the DescribeProtection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         </li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DescribeProtection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeProtection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeProtectionResponse> describeProtection(DescribeProtectionRequest describeProtectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the details of a <a>Protection</a> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProtectionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeProtectionRequest#builder()}
     * </p>
     *
     * @param describeProtectionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeProtectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeProtection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         </li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DescribeProtection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeProtection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeProtectionResponse> describeProtection(
            Consumer<DescribeProtectionRequest.Builder> describeProtectionRequest) {
        return describeProtection(DescribeProtectionRequest.builder().applyMutation(describeProtectionRequest).build());
    }

    /**
     * <p>
     * Provides details about the AWS Shield Advanced subscription for an account.
     * </p>
     *
     * @param describeSubscriptionRequest
     * @return A Java Future containing the result of the DescribeSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DescribeSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeSubscriptionResponse> describeSubscription(
            DescribeSubscriptionRequest describeSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about the AWS Shield Advanced subscription for an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSubscriptionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSubscriptionRequest#builder()}
     * </p>
     *
     * @param describeSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSubscriptionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DescribeSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeSubscriptionResponse> describeSubscription(
            Consumer<DescribeSubscriptionRequest.Builder> describeSubscriptionRequest) {
        return describeSubscription(DescribeSubscriptionRequest.builder().applyMutation(describeSubscriptionRequest).build());
    }

    /**
     * <p>
     * Provides details about the AWS Shield Advanced subscription for an account.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DescribeSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeSubscriptionResponse> describeSubscription() {
        return describeSubscription(DescribeSubscriptionRequest.builder().build());
    }

    /**
     * <p>
     * Removes the DDoS Response team's (DRT) access to the specified Amazon S3 bucket containing your AWS WAF logs.
     * </p>
     * <p>
     * To make a <code>DisassociateDRTLogBucket</code> request, you must be subscribed to the <a
     * href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>. However, if you are
     * not subscribed to one of these support plans, but had been previously and had granted the DRT access to your
     * account, you can submit a <code>DisassociateDRTLogBucket</code> request to remove this access.
     * </p>
     *
     * @param disassociateDrtLogBucketRequest
     * @return A Java Future containing the result of the DisassociateDRTLogBucket operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>NoAssociatedRoleException The ARN of the role that you specifed does not exist.</li>
     *         <li>AccessDeniedForDependencyException In order to grant the necessary access to the DDoS Response Team,
     *         the user submitting <code>AssociateDRTRole</code> must have the <code>iam:PassRole</code> permission.
     *         This error indicates the user did not have the appropriate permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a User
     *         Permissions to Pass a Role to an AWS Service</a>.</li>
     *         <li>OptimisticLockException Exception that indicates that the protection state has been modified by
     *         another client. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DisassociateDRTLogBucket
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DisassociateDRTLogBucket"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateDrtLogBucketResponse> disassociateDRTLogBucket(
            DisassociateDrtLogBucketRequest disassociateDrtLogBucketRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the DDoS Response team's (DRT) access to the specified Amazon S3 bucket containing your AWS WAF logs.
     * </p>
     * <p>
     * To make a <code>DisassociateDRTLogBucket</code> request, you must be subscribed to the <a
     * href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>. However, if you are
     * not subscribed to one of these support plans, but had been previously and had granted the DRT access to your
     * account, you can submit a <code>DisassociateDRTLogBucket</code> request to remove this access.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateDrtLogBucketRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateDrtLogBucketRequest#builder()}
     * </p>
     *
     * @param disassociateDrtLogBucketRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateDRTLogBucketRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateDRTLogBucket operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>NoAssociatedRoleException The ARN of the role that you specifed does not exist.</li>
     *         <li>AccessDeniedForDependencyException In order to grant the necessary access to the DDoS Response Team,
     *         the user submitting <code>AssociateDRTRole</code> must have the <code>iam:PassRole</code> permission.
     *         This error indicates the user did not have the appropriate permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a User
     *         Permissions to Pass a Role to an AWS Service</a>.</li>
     *         <li>OptimisticLockException Exception that indicates that the protection state has been modified by
     *         another client. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DisassociateDRTLogBucket
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DisassociateDRTLogBucket"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateDrtLogBucketResponse> disassociateDRTLogBucket(
            Consumer<DisassociateDrtLogBucketRequest.Builder> disassociateDrtLogBucketRequest) {
        return disassociateDRTLogBucket(DisassociateDrtLogBucketRequest.builder().applyMutation(disassociateDrtLogBucketRequest)
                .build());
    }

    /**
     * <p>
     * Removes the DDoS Response team's (DRT) access to your AWS account.
     * </p>
     * <p>
     * To make a <code>DisassociateDRTRole</code> request, you must be subscribed to the <a
     * href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>. However, if you are
     * not subscribed to one of these support plans, but had been previously and had granted the DRT access to your
     * account, you can submit a <code>DisassociateDRTRole</code> request to remove this access.
     * </p>
     *
     * @param disassociateDrtRoleRequest
     * @return A Java Future containing the result of the DisassociateDRTRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>OptimisticLockException Exception that indicates that the protection state has been modified by
     *         another client. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DisassociateDRTRole
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DisassociateDRTRole" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisassociateDrtRoleResponse> disassociateDRTRole(
            DisassociateDrtRoleRequest disassociateDrtRoleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the DDoS Response team's (DRT) access to your AWS account.
     * </p>
     * <p>
     * To make a <code>DisassociateDRTRole</code> request, you must be subscribed to the <a
     * href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>. However, if you are
     * not subscribed to one of these support plans, but had been previously and had granted the DRT access to your
     * account, you can submit a <code>DisassociateDRTRole</code> request to remove this access.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateDrtRoleRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateDrtRoleRequest#builder()}
     * </p>
     *
     * @param disassociateDrtRoleRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateDRTRoleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateDRTRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>OptimisticLockException Exception that indicates that the protection state has been modified by
     *         another client. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DisassociateDRTRole
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DisassociateDRTRole" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisassociateDrtRoleResponse> disassociateDRTRole(
            Consumer<DisassociateDrtRoleRequest.Builder> disassociateDrtRoleRequest) {
        return disassociateDRTRole(DisassociateDrtRoleRequest.builder().applyMutation(disassociateDrtRoleRequest).build());
    }

    /**
     * <p>
     * Removes the DDoS Response team's (DRT) access to your AWS account.
     * </p>
     * <p>
     * To make a <code>DisassociateDRTRole</code> request, you must be subscribed to the <a
     * href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>. However, if you are
     * not subscribed to one of these support plans, but had been previously and had granted the DRT access to your
     * account, you can submit a <code>DisassociateDRTRole</code> request to remove this access.
     * </p>
     *
     * @return A Java Future containing the result of the DisassociateDRTRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>OptimisticLockException Exception that indicates that the protection state has been modified by
     *         another client. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.DisassociateDRTRole
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DisassociateDRTRole" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisassociateDrtRoleResponse> disassociateDRTRole() {
        return disassociateDRTRole(DisassociateDrtRoleRequest.builder().build());
    }

    /**
     * <p>
     * Returns the <code>SubscriptionState</code>, either <code>Active</code> or <code>Inactive</code>.
     * </p>
     *
     * @param getSubscriptionStateRequest
     * @return A Java Future containing the result of the GetSubscriptionState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.GetSubscriptionState
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/GetSubscriptionState" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSubscriptionStateResponse> getSubscriptionState(
            GetSubscriptionStateRequest getSubscriptionStateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the <code>SubscriptionState</code>, either <code>Active</code> or <code>Inactive</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSubscriptionStateRequest.Builder} avoiding the
     * need to create one manually via {@link GetSubscriptionStateRequest#builder()}
     * </p>
     *
     * @param getSubscriptionStateRequest
     *        A {@link Consumer} that will call methods on {@link GetSubscriptionStateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSubscriptionState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.GetSubscriptionState
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/GetSubscriptionState" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSubscriptionStateResponse> getSubscriptionState(
            Consumer<GetSubscriptionStateRequest.Builder> getSubscriptionStateRequest) {
        return getSubscriptionState(GetSubscriptionStateRequest.builder().applyMutation(getSubscriptionStateRequest).build());
    }

    /**
     * <p>
     * Returns the <code>SubscriptionState</code>, either <code>Active</code> or <code>Inactive</code>.
     * </p>
     *
     * @return A Java Future containing the result of the GetSubscriptionState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.GetSubscriptionState
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/GetSubscriptionState" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSubscriptionStateResponse> getSubscriptionState() {
        return getSubscriptionState(GetSubscriptionStateRequest.builder().build());
    }

    /**
     * <p>
     * Returns all ongoing DDoS attacks or all DDoS attacks during a specified time period.
     * </p>
     *
     * @param listAttacksRequest
     * @return A Java Future containing the result of the ListAttacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         </li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.ListAttacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListAttacks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAttacksResponse> listAttacks(ListAttacksRequest listAttacksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all ongoing DDoS attacks or all DDoS attacks during a specified time period.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttacksRequest.Builder} avoiding the need to
     * create one manually via {@link ListAttacksRequest#builder()}
     * </p>
     *
     * @param listAttacksRequest
     *        A {@link Consumer} that will call methods on {@link ListAttacksRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAttacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         </li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.ListAttacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListAttacks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAttacksResponse> listAttacks(Consumer<ListAttacksRequest.Builder> listAttacksRequest) {
        return listAttacks(ListAttacksRequest.builder().applyMutation(listAttacksRequest).build());
    }

    /**
     * <p>
     * Returns all ongoing DDoS attacks or all DDoS attacks during a specified time period.
     * </p>
     *
     * @return A Java Future containing the result of the ListAttacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         </li>
     *         <li>InvalidOperationException Exception that indicates that the operation would not cause any change to
     *         occur.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.ListAttacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListAttacks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAttacksResponse> listAttacks() {
        return listAttacks(ListAttacksRequest.builder().build());
    }

    /**
     * <p>
     * Lists all <a>Protection</a> objects for the account.
     * </p>
     *
     * @param listProtectionsRequest
     * @return A Java Future containing the result of the ListProtections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist.</li>
     *         <li>InvalidPaginationTokenException Exception that indicates that the NextToken specified in the request
     *         is invalid. Submit the request using the NextToken value that was returned in the response.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.ListProtections
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListProtections" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListProtectionsResponse> listProtections(ListProtectionsRequest listProtectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all <a>Protection</a> objects for the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProtectionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListProtectionsRequest#builder()}
     * </p>
     *
     * @param listProtectionsRequest
     *        A {@link Consumer} that will call methods on {@link ListProtectionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListProtections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist.</li>
     *         <li>InvalidPaginationTokenException Exception that indicates that the NextToken specified in the request
     *         is invalid. Submit the request using the NextToken value that was returned in the response.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.ListProtections
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListProtections" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListProtectionsResponse> listProtections(
            Consumer<ListProtectionsRequest.Builder> listProtectionsRequest) {
        return listProtections(ListProtectionsRequest.builder().applyMutation(listProtectionsRequest).build());
    }

    /**
     * <p>
     * Lists all <a>Protection</a> objects for the account.
     * </p>
     *
     * @return A Java Future containing the result of the ListProtections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist.</li>
     *         <li>InvalidPaginationTokenException Exception that indicates that the NextToken specified in the request
     *         is invalid. Submit the request using the NextToken value that was returned in the response.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.ListProtections
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListProtections" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListProtectionsResponse> listProtections() {
        return listProtections(ListProtectionsRequest.builder().build());
    }

    /**
     * <p>
     * Updates the details of the list of email addresses that the DRT can use to contact you during a suspected attack.
     * </p>
     *
     * @param updateEmergencyContactSettingsRequest
     * @return A Java Future containing the result of the UpdateEmergencyContactSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         </li>
     *         <li>OptimisticLockException Exception that indicates that the protection state has been modified by
     *         another client. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.UpdateEmergencyContactSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/UpdateEmergencyContactSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEmergencyContactSettingsResponse> updateEmergencyContactSettings(
            UpdateEmergencyContactSettingsRequest updateEmergencyContactSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the details of the list of email addresses that the DRT can use to contact you during a suspected attack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEmergencyContactSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateEmergencyContactSettingsRequest#builder()}
     * </p>
     *
     * @param updateEmergencyContactSettingsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEmergencyContactSettingsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateEmergencyContactSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         </li>
     *         <li>OptimisticLockException Exception that indicates that the protection state has been modified by
     *         another client. You can retry the request.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.UpdateEmergencyContactSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/UpdateEmergencyContactSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEmergencyContactSettingsResponse> updateEmergencyContactSettings(
            Consumer<UpdateEmergencyContactSettingsRequest.Builder> updateEmergencyContactSettingsRequest) {
        return updateEmergencyContactSettings(UpdateEmergencyContactSettingsRequest.builder()
                .applyMutation(updateEmergencyContactSettingsRequest).build());
    }

    /**
     * <p>
     * Updates the details of an existing subscription. Only enter values for parameters you want to change. Empty
     * parameters are not updated.
     * </p>
     *
     * @param updateSubscriptionRequest
     * @return A Java Future containing the result of the UpdateSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>LockedSubscriptionException You are trying to update a subscription that has not yet completed the
     *         1-year commitment. You can change the <code>AutoRenew</code> parameter during the last 30 days of your
     *         subscription. This exception indicates that you are attempting to change <code>AutoRenew</code> prior to
     *         that period.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         </li>
     *         <li>OptimisticLockException Exception that indicates that the protection state has been modified by
     *         another client. You can retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.UpdateSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/UpdateSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSubscriptionResponse> updateSubscription(UpdateSubscriptionRequest updateSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the details of an existing subscription. Only enter values for parameters you want to change. Empty
     * parameters are not updated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSubscriptionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateSubscriptionRequest#builder()}
     * </p>
     *
     * @param updateSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSubscriptionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException Exception that indicates that a problem occurred with the service
     *         infrastructure. You can retry the request.</li>
     *         <li>LockedSubscriptionException You are trying to update a subscription that has not yet completed the
     *         1-year commitment. You can change the <code>AutoRenew</code> parameter during the last 30 days of your
     *         subscription. This exception indicates that you are attempting to change <code>AutoRenew</code> prior to
     *         that period.</li>
     *         <li>ResourceNotFoundException Exception indicating the specified resource does not exist.</li>
     *         <li>InvalidParameterException Exception that indicates that the parameters passed to the API are invalid.
     *         </li>
     *         <li>OptimisticLockException Exception that indicates that the protection state has been modified by
     *         another client. You can retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ShieldException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ShieldAsyncClient.UpdateSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/UpdateSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSubscriptionResponse> updateSubscription(
            Consumer<UpdateSubscriptionRequest.Builder> updateSubscriptionRequest) {
        return updateSubscription(UpdateSubscriptionRequest.builder().applyMutation(updateSubscriptionRequest).build());
    }
}
