/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.shield.model.TimeRange;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TimeRangeMarshaller {
    private static final MarshallingInfo<Instant> FROMINCLUSIVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FromInclusive").isBinary(false).build();
    private static final MarshallingInfo<Instant> TOEXCLUSIVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ToExclusive").isBinary(false).build();
    private static final TimeRangeMarshaller INSTANCE = new TimeRangeMarshaller();

    private TimeRangeMarshaller() {
    }

    public static TimeRangeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TimeRange timeRange, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)timeRange, (String)"timeRange");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)timeRange.fromInclusive(), FROMINCLUSIVE_BINDING);
            protocolMarshaller.marshall((Object)timeRange.toExclusive(), TOEXCLUSIVE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

