/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.shield.model.AttackVectorDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AttackVectorDescriptionMarshaller {
    private static final MarshallingInfo<String> VECTORTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VectorType").isBinary(false).build();
    private static final AttackVectorDescriptionMarshaller INSTANCE = new AttackVectorDescriptionMarshaller();

    private AttackVectorDescriptionMarshaller() {
    }

    public static AttackVectorDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AttackVectorDescription attackVectorDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)attackVectorDescription, (String)"attackVectorDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)attackVectorDescription.vectorType(), VECTORTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

