/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.shield.model.TimeRange;

@SdkInternalApi
public class TimeRangeMarshaller {
    private static final MarshallingInfo<Instant> FROMINCLUSIVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FromInclusive").build();
    private static final MarshallingInfo<Instant> TOEXCLUSIVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ToExclusive").build();
    private static final TimeRangeMarshaller INSTANCE = new TimeRangeMarshaller();

    public static TimeRangeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TimeRange timeRange, ProtocolMarshaller protocolMarshaller) {
        if (timeRange == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)timeRange.fromInclusive(), FROMINCLUSIVE_BINDING);
            protocolMarshaller.marshall((Object)timeRange.toExclusive(), TOEXCLUSIVE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

