/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.shield.model.SubResourceSummary;

@SdkInternalApi
public class SubResourceSummaryMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").build();
    private static final MarshallingInfo<List> ATTACKVECTORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttackVectors").build();
    private static final MarshallingInfo<List> COUNTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Counters").build();
    private static final SubResourceSummaryMarshaller INSTANCE = new SubResourceSummaryMarshaller();

    public static SubResourceSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SubResourceSummary subResourceSummary, ProtocolMarshaller protocolMarshaller) {
        if (subResourceSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)subResourceSummary.typeString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)subResourceSummary.id(), ID_BINDING);
            protocolMarshaller.marshall(subResourceSummary.attackVectors(), ATTACKVECTORS_BINDING);
            protocolMarshaller.marshall(subResourceSummary.counters(), COUNTERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

