/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.shield.model.SummarizedCounter;
import software.amazon.awssdk.services.shield.model.SummarizedCounterListCopier;
import software.amazon.awssdk.services.shield.transform.SummarizedAttackVectorMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SummarizedAttackVector
implements StructuredPojo,
ToCopyableBuilder<Builder, SummarizedAttackVector> {
    private final String vectorType;
    private final List<SummarizedCounter> vectorCounters;

    private SummarizedAttackVector(BuilderImpl builder) {
        this.vectorType = builder.vectorType;
        this.vectorCounters = builder.vectorCounters;
    }

    public String vectorType() {
        return this.vectorType;
    }

    public List<SummarizedCounter> vectorCounters() {
        return this.vectorCounters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.vectorType() == null ? 0 : this.vectorType().hashCode());
        hashCode = 31 * hashCode + (this.vectorCounters() == null ? 0 : this.vectorCounters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SummarizedAttackVector)) {
            return false;
        }
        SummarizedAttackVector other = (SummarizedAttackVector)obj;
        if (other.vectorType() == null ^ this.vectorType() == null) {
            return false;
        }
        if (other.vectorType() != null && !other.vectorType().equals(this.vectorType())) {
            return false;
        }
        if (other.vectorCounters() == null ^ this.vectorCounters() == null) {
            return false;
        }
        return other.vectorCounters() == null || other.vectorCounters().equals(this.vectorCounters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.vectorType() != null) {
            sb.append("VectorType: ").append(this.vectorType()).append(",");
        }
        if (this.vectorCounters() != null) {
            sb.append("VectorCounters: ").append(this.vectorCounters()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SummarizedAttackVectorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String vectorType;
        private List<SummarizedCounter> vectorCounters;

        private BuilderImpl() {
        }

        private BuilderImpl(SummarizedAttackVector model) {
            this.setVectorType(model.vectorType);
            this.setVectorCounters(model.vectorCounters);
        }

        public final String getVectorType() {
            return this.vectorType;
        }

        @Override
        public final Builder vectorType(String vectorType) {
            this.vectorType = vectorType;
            return this;
        }

        public final void setVectorType(String vectorType) {
            this.vectorType = vectorType;
        }

        public final Collection<SummarizedCounter> getVectorCounters() {
            return this.vectorCounters;
        }

        @Override
        public final Builder vectorCounters(Collection<SummarizedCounter> vectorCounters) {
            this.vectorCounters = SummarizedCounterListCopier.copy(vectorCounters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vectorCounters(SummarizedCounter ... vectorCounters) {
            this.vectorCounters(Arrays.asList(vectorCounters));
            return this;
        }

        public final void setVectorCounters(Collection<SummarizedCounter> vectorCounters) {
            this.vectorCounters = SummarizedCounterListCopier.copy(vectorCounters);
        }

        public SummarizedAttackVector build() {
            return new SummarizedAttackVector(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SummarizedAttackVector> {
        public Builder vectorType(String var1);

        public Builder vectorCounters(Collection<SummarizedCounter> var1);

        public Builder vectorCounters(SummarizedCounter ... var1);
    }
}

