/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.shield.model.Protection;
import software.amazon.awssdk.services.shield.model.ProtectionsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListProtectionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListProtectionsResponse> {
    private final List<Protection> protections;
    private final String nextToken;

    private ListProtectionsResponse(BuilderImpl builder) {
        this.protections = builder.protections;
        this.nextToken = builder.nextToken;
    }

    public List<Protection> protections() {
        return this.protections;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.protections() == null ? 0 : this.protections().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProtectionsResponse)) {
            return false;
        }
        ListProtectionsResponse other = (ListProtectionsResponse)((Object)obj);
        if (other.protections() == null ^ this.protections() == null) {
            return false;
        }
        if (other.protections() != null && !other.protections().equals(this.protections())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.protections() != null) {
            sb.append("Protections: ").append(this.protections()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Protection> protections;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProtectionsResponse model) {
            this.setProtections(model.protections);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Protection> getProtections() {
            return this.protections;
        }

        @Override
        public final Builder protections(Collection<Protection> protections) {
            this.protections = ProtectionsCopier.copy(protections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protections(Protection ... protections) {
            this.protections(Arrays.asList(protections));
            return this;
        }

        public final void setProtections(Collection<Protection> protections) {
            this.protections = ProtectionsCopier.copy(protections);
        }

        @SafeVarargs
        public final void setProtections(Protection ... protections) {
            this.protections(Arrays.asList(protections));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListProtectionsResponse build() {
            return new ListProtectionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListProtectionsResponse> {
        public Builder protections(Collection<Protection> var1);

        public Builder protections(Protection ... var1);

        public Builder nextToken(String var1);
    }
}

