/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.shield.model.Limit;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LimitMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<Long> MAX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Max").isBinary(false).build();
    private static final LimitMarshaller INSTANCE = new LimitMarshaller();

    private LimitMarshaller() {
    }

    public static LimitMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Limit limit, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)limit, (String)"limit");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)limit.type(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)limit.max(), MAX_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

