/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.shield.model.AttackProperty;
import software.amazon.awssdk.services.shield.transform.ContributorUnmarshaller;

public class AttackPropertyUnmarshaller
implements Unmarshaller<AttackProperty, JsonUnmarshallerContext> {
    private static final AttackPropertyUnmarshaller INSTANCE = new AttackPropertyUnmarshaller();

    public AttackProperty unmarshall(JsonUnmarshallerContext context) throws Exception {
        AttackProperty.Builder attackPropertyBuilder = AttackProperty.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("AttackLayer", targetDepth)) {
                    context.nextToken();
                    attackPropertyBuilder.attackLayer((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("AttackPropertyIdentifier", targetDepth)) {
                    context.nextToken();
                    attackPropertyBuilder.attackPropertyIdentifier((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("TopContributors", targetDepth)) {
                    context.nextToken();
                    attackPropertyBuilder.topContributors(new ListUnmarshaller((Unmarshaller)ContributorUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("Unit", targetDepth)) {
                    context.nextToken();
                    attackPropertyBuilder.unit((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Total", targetDepth)) {
                    context.nextToken();
                    attackPropertyBuilder.total((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (AttackProperty)attackPropertyBuilder.build();
    }

    public static AttackPropertyUnmarshaller getInstance() {
        return INSTANCE;
    }
}

