/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.shield.model.AttackProperty;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AttackPropertyMarshaller {
    private static final MarshallingInfo<String> ATTACKLAYER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttackLayer").isBinary(false).build();
    private static final MarshallingInfo<String> ATTACKPROPERTYIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttackPropertyIdentifier").isBinary(false).build();
    private static final MarshallingInfo<List> TOPCONTRIBUTORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TopContributors").isBinary(false).build();
    private static final MarshallingInfo<String> UNIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Unit").isBinary(false).build();
    private static final MarshallingInfo<Long> TOTAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Total").isBinary(false).build();
    private static final AttackPropertyMarshaller INSTANCE = new AttackPropertyMarshaller();

    private AttackPropertyMarshaller() {
    }

    public static AttackPropertyMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AttackProperty attackProperty, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)attackProperty, (String)"attackProperty");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)attackProperty.attackLayerAsString(), ATTACKLAYER_BINDING);
            protocolMarshaller.marshall((Object)attackProperty.attackPropertyIdentifierAsString(), ATTACKPROPERTYIDENTIFIER_BINDING);
            protocolMarshaller.marshall(attackProperty.topContributors(), TOPCONTRIBUTORS_BINDING);
            protocolMarshaller.marshall((Object)attackProperty.unitAsString(), UNIT_BINDING);
            protocolMarshaller.marshall((Object)attackProperty.total(), TOTAL_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

