/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.shield.model.SubResourceSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SubResourceSummaryMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<List> ATTACKVECTORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttackVectors").isBinary(false).build();
    private static final MarshallingInfo<List> COUNTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Counters").isBinary(false).build();
    private static final SubResourceSummaryMarshaller INSTANCE = new SubResourceSummaryMarshaller();

    private SubResourceSummaryMarshaller() {
    }

    public static SubResourceSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SubResourceSummary subResourceSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)subResourceSummary, (String)"subResourceSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)subResourceSummary.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)subResourceSummary.id(), ID_BINDING);
            protocolMarshaller.marshall(subResourceSummary.attackVectors(), ATTACKVECTORS_BINDING);
            protocolMarshaller.marshall(subResourceSummary.counters(), COUNTERS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

