/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.shield.model.ListAttacksRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListAttacksRequestModelMarshaller {
    private static final MarshallingInfo<List> RESOURCEARNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceArns").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxResults").isBinary(false).build();
    private static final ListAttacksRequestModelMarshaller INSTANCE = new ListAttacksRequestModelMarshaller();

    private ListAttacksRequestModelMarshaller() {
    }

    public static ListAttacksRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListAttacksRequest listAttacksRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)listAttacksRequest), (String)"listAttacksRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(listAttacksRequest.resourceArns(), RESOURCEARNS_BINDING);
            protocolMarshaller.marshall((Object)listAttacksRequest.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)listAttacksRequest.endTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)listAttacksRequest.nextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)listAttacksRequest.maxResults(), MAXRESULTS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

