/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.transform;

import java.util.Date;
import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.shield.model.AttackSummary;

@SdkInternalApi
public class AttackSummaryMarshaller {
    private static final MarshallingInfo<String> ATTACKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttackId").build();
    private static final MarshallingInfo<String> RESOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceArn").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").build();
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").build();
    private static final MarshallingInfo<List> ATTACKVECTORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttackVectors").build();
    private static final AttackSummaryMarshaller instance = new AttackSummaryMarshaller();

    public static AttackSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(AttackSummary attackSummary, ProtocolMarshaller protocolMarshaller) {
        if (attackSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)attackSummary.attackId(), ATTACKID_BINDING);
            protocolMarshaller.marshall((Object)attackSummary.resourceArn(), RESOURCEARN_BINDING);
            protocolMarshaller.marshall((Object)attackSummary.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)attackSummary.endTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall(attackSummary.attackVectors(), ATTACKVECTORS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

