/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.shield.transform.TimeRangeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TimeRange
implements StructuredPojo,
ToCopyableBuilder<Builder, TimeRange> {
    private final Date fromInclusive;
    private final Date toExclusive;

    private TimeRange(BuilderImpl builder) {
        this.fromInclusive = builder.fromInclusive;
        this.toExclusive = builder.toExclusive;
    }

    public Date fromInclusive() {
        return this.fromInclusive;
    }

    public Date toExclusive() {
        return this.toExclusive;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.fromInclusive() == null ? 0 : this.fromInclusive().hashCode());
        hashCode = 31 * hashCode + (this.toExclusive() == null ? 0 : this.toExclusive().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeRange)) {
            return false;
        }
        TimeRange other = (TimeRange)obj;
        if (other.fromInclusive() == null ^ this.fromInclusive() == null) {
            return false;
        }
        if (other.fromInclusive() != null && !other.fromInclusive().equals(this.fromInclusive())) {
            return false;
        }
        if (other.toExclusive() == null ^ this.toExclusive() == null) {
            return false;
        }
        return other.toExclusive() == null || other.toExclusive().equals(this.toExclusive());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fromInclusive() != null) {
            sb.append("FromInclusive: ").append(this.fromInclusive()).append(",");
        }
        if (this.toExclusive() != null) {
            sb.append("ToExclusive: ").append(this.toExclusive()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TimeRangeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Date fromInclusive;
        private Date toExclusive;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeRange model) {
            this.setFromInclusive(model.fromInclusive);
            this.setToExclusive(model.toExclusive);
        }

        public final Date getFromInclusive() {
            return this.fromInclusive;
        }

        @Override
        public final Builder fromInclusive(Date fromInclusive) {
            this.fromInclusive = StandardMemberCopier.copy((Date)fromInclusive);
            return this;
        }

        public final void setFromInclusive(Date fromInclusive) {
            this.fromInclusive = StandardMemberCopier.copy((Date)fromInclusive);
        }

        public final Date getToExclusive() {
            return this.toExclusive;
        }

        @Override
        public final Builder toExclusive(Date toExclusive) {
            this.toExclusive = StandardMemberCopier.copy((Date)toExclusive);
            return this;
        }

        public final void setToExclusive(Date toExclusive) {
            this.toExclusive = StandardMemberCopier.copy((Date)toExclusive);
        }

        public TimeRange build() {
            return new TimeRange(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TimeRange> {
        public Builder fromInclusive(Date var1);

        public Builder toExclusive(Date var1);
    }
}

