/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.shield.model.AttackVectorDescription;
import software.amazon.awssdk.services.shield.model.AttackVectorDescriptionListCopier;
import software.amazon.awssdk.services.shield.transform.AttackSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AttackSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, AttackSummary> {
    private final String attackId;
    private final String resourceArn;
    private final Date startTime;
    private final Date endTime;
    private final List<AttackVectorDescription> attackVectors;

    private AttackSummary(BuilderImpl builder) {
        this.attackId = builder.attackId;
        this.resourceArn = builder.resourceArn;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.attackVectors = builder.attackVectors;
    }

    public String attackId() {
        return this.attackId;
    }

    public String resourceArn() {
        return this.resourceArn;
    }

    public Date startTime() {
        return this.startTime;
    }

    public Date endTime() {
        return this.endTime;
    }

    public List<AttackVectorDescription> attackVectors() {
        return this.attackVectors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attackId() == null ? 0 : this.attackId().hashCode());
        hashCode = 31 * hashCode + (this.resourceArn() == null ? 0 : this.resourceArn().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        hashCode = 31 * hashCode + (this.attackVectors() == null ? 0 : this.attackVectors().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttackSummary)) {
            return false;
        }
        AttackSummary other = (AttackSummary)obj;
        if (other.attackId() == null ^ this.attackId() == null) {
            return false;
        }
        if (other.attackId() != null && !other.attackId().equals(this.attackId())) {
            return false;
        }
        if (other.resourceArn() == null ^ this.resourceArn() == null) {
            return false;
        }
        if (other.resourceArn() != null && !other.resourceArn().equals(this.resourceArn())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.attackVectors() == null ^ this.attackVectors() == null) {
            return false;
        }
        return other.attackVectors() == null || other.attackVectors().equals(this.attackVectors());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attackId() != null) {
            sb.append("AttackId: ").append(this.attackId()).append(",");
        }
        if (this.resourceArn() != null) {
            sb.append("ResourceArn: ").append(this.resourceArn()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.attackVectors() != null) {
            sb.append("AttackVectors: ").append(this.attackVectors()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttackSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String attackId;
        private String resourceArn;
        private Date startTime;
        private Date endTime;
        private List<AttackVectorDescription> attackVectors;

        private BuilderImpl() {
        }

        private BuilderImpl(AttackSummary model) {
            this.setAttackId(model.attackId);
            this.setResourceArn(model.resourceArn);
            this.setStartTime(model.startTime);
            this.setEndTime(model.endTime);
            this.setAttackVectors(model.attackVectors);
        }

        public final String getAttackId() {
            return this.attackId;
        }

        @Override
        public final Builder attackId(String attackId) {
            this.attackId = attackId;
            return this;
        }

        public final void setAttackId(String attackId) {
            this.attackId = attackId;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final Date getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Date startTime) {
            this.startTime = StandardMemberCopier.copy((Date)startTime);
            return this;
        }

        public final void setStartTime(Date startTime) {
            this.startTime = StandardMemberCopier.copy((Date)startTime);
        }

        public final Date getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Date endTime) {
            this.endTime = StandardMemberCopier.copy((Date)endTime);
            return this;
        }

        public final void setEndTime(Date endTime) {
            this.endTime = StandardMemberCopier.copy((Date)endTime);
        }

        public final Collection<AttackVectorDescription> getAttackVectors() {
            return this.attackVectors;
        }

        @Override
        public final Builder attackVectors(Collection<AttackVectorDescription> attackVectors) {
            this.attackVectors = AttackVectorDescriptionListCopier.copy(attackVectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attackVectors(AttackVectorDescription ... attackVectors) {
            if (this.attackVectors == null) {
                this.attackVectors = new ArrayList<AttackVectorDescription>(attackVectors.length);
            }
            for (AttackVectorDescription e : attackVectors) {
                this.attackVectors.add(e);
            }
            return this;
        }

        public final void setAttackVectors(Collection<AttackVectorDescription> attackVectors) {
            this.attackVectors = AttackVectorDescriptionListCopier.copy(attackVectors);
        }

        @SafeVarargs
        public final void setAttackVectors(AttackVectorDescription ... attackVectors) {
            if (this.attackVectors == null) {
                this.attackVectors = new ArrayList<AttackVectorDescription>(attackVectors.length);
            }
            for (AttackVectorDescription e : attackVectors) {
                this.attackVectors.add(e);
            }
        }

        public AttackSummary build() {
            return new AttackSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AttackSummary> {
        public Builder attackId(String var1);

        public Builder resourceArn(String var1);

        public Builder startTime(Date var1);

        public Builder endTime(Date var1);

        public Builder attackVectors(Collection<AttackVectorDescription> var1);

        public Builder attackVectors(AttackVectorDescription ... var1);
    }
}

