/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaskSucceededEventDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaskSucceededEventDetails> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TaskSucceededEventDetails.getter(TaskSucceededEventDetails::resourceType)).setter(TaskSucceededEventDetails.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TaskSucceededEventDetails.getter(TaskSucceededEventDetails::resource)).setter(TaskSucceededEventDetails.setter(Builder::resource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()}).build();
    private static final SdkField<String> OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TaskSucceededEventDetails.getter(TaskSucceededEventDetails::output)).setter(TaskSucceededEventDetails.setter(Builder::output)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("output").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, RESOURCE_FIELD, OUTPUT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceType;
    private final String resource;
    private final String output;

    private TaskSucceededEventDetails(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resource = builder.resource;
        this.output = builder.output;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public String resource() {
        return this.resource;
    }

    public String output() {
        return this.output;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.output());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskSucceededEventDetails)) {
            return false;
        }
        TaskSucceededEventDetails other = (TaskSucceededEventDetails)obj;
        return Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.resource(), other.resource()) && Objects.equals(this.output(), other.output());
    }

    public String toString() {
        return ToString.builder((String)"TaskSucceededEventDetails").add("ResourceType", (Object)this.resourceType()).add("Resource", (Object)this.resource()).add("Output", (Object)(this.output() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "output": {
                return Optional.ofNullable(clazz.cast(this.output()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaskSucceededEventDetails, T> g) {
        return obj -> g.apply((TaskSucceededEventDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private String resource;
        private String output;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskSucceededEventDetails model) {
            this.resourceType(model.resourceType);
            this.resource(model.resource);
            this.output(model.output);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResource() {
            return this.resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        public final String getOutput() {
            return this.output;
        }

        @Override
        public final Builder output(String output) {
            this.output = output;
            return this;
        }

        public final void setOutput(String output) {
            this.output = output;
        }

        public TaskSucceededEventDetails build() {
            return new TaskSucceededEventDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaskSucceededEventDetails> {
        public Builder resourceType(String var1);

        public Builder resource(String var1);

        public Builder output(String var1);
    }
}

