/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sfn.model.SfnResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeActivityResponse
extends SfnResponse
implements ToCopyableBuilder<Builder, DescribeActivityResponse> {
    private static final SdkField<String> ACTIVITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeActivityResponse.getter(DescribeActivityResponse::activityArn)).setter(DescribeActivityResponse.setter(Builder::activityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeActivityResponse.getter(DescribeActivityResponse::name)).setter(DescribeActivityResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeActivityResponse.getter(DescribeActivityResponse::creationDate)).setter(DescribeActivityResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITY_ARN_FIELD, NAME_FIELD, CREATION_DATE_FIELD));
    private final String activityArn;
    private final String name;
    private final Instant creationDate;

    private DescribeActivityResponse(BuilderImpl builder) {
        super(builder);
        this.activityArn = builder.activityArn;
        this.name = builder.name;
        this.creationDate = builder.creationDate;
    }

    public String activityArn() {
        return this.activityArn;
    }

    public String name() {
        return this.name;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeActivityResponse)) {
            return false;
        }
        DescribeActivityResponse other = (DescribeActivityResponse)((Object)obj);
        return Objects.equals(this.activityArn(), other.activityArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.creationDate(), other.creationDate());
    }

    public String toString() {
        return ToString.builder((String)"DescribeActivityResponse").add("ActivityArn", (Object)this.activityArn()).add("Name", (Object)this.name()).add("CreationDate", (Object)this.creationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "activityArn": {
                return Optional.ofNullable(clazz.cast(this.activityArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeActivityResponse, T> g) {
        return obj -> g.apply((DescribeActivityResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SfnResponse.BuilderImpl
    implements Builder {
        private String activityArn;
        private String name;
        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeActivityResponse model) {
            super(model);
            this.activityArn(model.activityArn);
            this.name(model.name);
            this.creationDate(model.creationDate);
        }

        public final String getActivityArn() {
            return this.activityArn;
        }

        @Override
        public final Builder activityArn(String activityArn) {
            this.activityArn = activityArn;
            return this;
        }

        public final void setActivityArn(String activityArn) {
            this.activityArn = activityArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public DescribeActivityResponse build() {
            return new DescribeActivityResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SfnResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeActivityResponse> {
        public Builder activityArn(String var1);

        public Builder name(String var1);

        public Builder creationDate(Instant var1);
    }
}

