/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.sfn.SfnAsyncClient;
import software.amazon.awssdk.services.sfn.SfnServiceClientConfiguration;
import software.amazon.awssdk.services.sfn.internal.SfnServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.sfn.model.ActivityAlreadyExistsException;
import software.amazon.awssdk.services.sfn.model.ActivityDoesNotExistException;
import software.amazon.awssdk.services.sfn.model.ActivityLimitExceededException;
import software.amazon.awssdk.services.sfn.model.ActivityWorkerLimitExceededException;
import software.amazon.awssdk.services.sfn.model.ConflictException;
import software.amazon.awssdk.services.sfn.model.CreateActivityRequest;
import software.amazon.awssdk.services.sfn.model.CreateActivityResponse;
import software.amazon.awssdk.services.sfn.model.CreateStateMachineAliasRequest;
import software.amazon.awssdk.services.sfn.model.CreateStateMachineAliasResponse;
import software.amazon.awssdk.services.sfn.model.CreateStateMachineRequest;
import software.amazon.awssdk.services.sfn.model.CreateStateMachineResponse;
import software.amazon.awssdk.services.sfn.model.DeleteActivityRequest;
import software.amazon.awssdk.services.sfn.model.DeleteActivityResponse;
import software.amazon.awssdk.services.sfn.model.DeleteStateMachineAliasRequest;
import software.amazon.awssdk.services.sfn.model.DeleteStateMachineAliasResponse;
import software.amazon.awssdk.services.sfn.model.DeleteStateMachineRequest;
import software.amazon.awssdk.services.sfn.model.DeleteStateMachineResponse;
import software.amazon.awssdk.services.sfn.model.DeleteStateMachineVersionRequest;
import software.amazon.awssdk.services.sfn.model.DeleteStateMachineVersionResponse;
import software.amazon.awssdk.services.sfn.model.DescribeActivityRequest;
import software.amazon.awssdk.services.sfn.model.DescribeActivityResponse;
import software.amazon.awssdk.services.sfn.model.DescribeExecutionRequest;
import software.amazon.awssdk.services.sfn.model.DescribeExecutionResponse;
import software.amazon.awssdk.services.sfn.model.DescribeMapRunRequest;
import software.amazon.awssdk.services.sfn.model.DescribeMapRunResponse;
import software.amazon.awssdk.services.sfn.model.DescribeStateMachineAliasRequest;
import software.amazon.awssdk.services.sfn.model.DescribeStateMachineAliasResponse;
import software.amazon.awssdk.services.sfn.model.DescribeStateMachineForExecutionRequest;
import software.amazon.awssdk.services.sfn.model.DescribeStateMachineForExecutionResponse;
import software.amazon.awssdk.services.sfn.model.DescribeStateMachineRequest;
import software.amazon.awssdk.services.sfn.model.DescribeStateMachineResponse;
import software.amazon.awssdk.services.sfn.model.ExecutionAlreadyExistsException;
import software.amazon.awssdk.services.sfn.model.ExecutionDoesNotExistException;
import software.amazon.awssdk.services.sfn.model.ExecutionLimitExceededException;
import software.amazon.awssdk.services.sfn.model.ExecutionNotRedrivableException;
import software.amazon.awssdk.services.sfn.model.GetActivityTaskRequest;
import software.amazon.awssdk.services.sfn.model.GetActivityTaskResponse;
import software.amazon.awssdk.services.sfn.model.GetExecutionHistoryRequest;
import software.amazon.awssdk.services.sfn.model.GetExecutionHistoryResponse;
import software.amazon.awssdk.services.sfn.model.InvalidArnException;
import software.amazon.awssdk.services.sfn.model.InvalidDefinitionException;
import software.amazon.awssdk.services.sfn.model.InvalidEncryptionConfigurationException;
import software.amazon.awssdk.services.sfn.model.InvalidExecutionInputException;
import software.amazon.awssdk.services.sfn.model.InvalidLoggingConfigurationException;
import software.amazon.awssdk.services.sfn.model.InvalidNameException;
import software.amazon.awssdk.services.sfn.model.InvalidOutputException;
import software.amazon.awssdk.services.sfn.model.InvalidTokenException;
import software.amazon.awssdk.services.sfn.model.InvalidTracingConfigurationException;
import software.amazon.awssdk.services.sfn.model.KmsAccessDeniedException;
import software.amazon.awssdk.services.sfn.model.KmsInvalidStateException;
import software.amazon.awssdk.services.sfn.model.KmsThrottlingException;
import software.amazon.awssdk.services.sfn.model.ListActivitiesRequest;
import software.amazon.awssdk.services.sfn.model.ListActivitiesResponse;
import software.amazon.awssdk.services.sfn.model.ListExecutionsRequest;
import software.amazon.awssdk.services.sfn.model.ListExecutionsResponse;
import software.amazon.awssdk.services.sfn.model.ListMapRunsRequest;
import software.amazon.awssdk.services.sfn.model.ListMapRunsResponse;
import software.amazon.awssdk.services.sfn.model.ListStateMachineAliasesRequest;
import software.amazon.awssdk.services.sfn.model.ListStateMachineAliasesResponse;
import software.amazon.awssdk.services.sfn.model.ListStateMachineVersionsRequest;
import software.amazon.awssdk.services.sfn.model.ListStateMachineVersionsResponse;
import software.amazon.awssdk.services.sfn.model.ListStateMachinesRequest;
import software.amazon.awssdk.services.sfn.model.ListStateMachinesResponse;
import software.amazon.awssdk.services.sfn.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.sfn.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.sfn.model.MissingRequiredParameterException;
import software.amazon.awssdk.services.sfn.model.PublishStateMachineVersionRequest;
import software.amazon.awssdk.services.sfn.model.PublishStateMachineVersionResponse;
import software.amazon.awssdk.services.sfn.model.RedriveExecutionRequest;
import software.amazon.awssdk.services.sfn.model.RedriveExecutionResponse;
import software.amazon.awssdk.services.sfn.model.ResourceNotFoundException;
import software.amazon.awssdk.services.sfn.model.SendTaskFailureRequest;
import software.amazon.awssdk.services.sfn.model.SendTaskFailureResponse;
import software.amazon.awssdk.services.sfn.model.SendTaskHeartbeatRequest;
import software.amazon.awssdk.services.sfn.model.SendTaskHeartbeatResponse;
import software.amazon.awssdk.services.sfn.model.SendTaskSuccessRequest;
import software.amazon.awssdk.services.sfn.model.SendTaskSuccessResponse;
import software.amazon.awssdk.services.sfn.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.sfn.model.SfnException;
import software.amazon.awssdk.services.sfn.model.StartExecutionRequest;
import software.amazon.awssdk.services.sfn.model.StartExecutionResponse;
import software.amazon.awssdk.services.sfn.model.StartSyncExecutionRequest;
import software.amazon.awssdk.services.sfn.model.StartSyncExecutionResponse;
import software.amazon.awssdk.services.sfn.model.StateMachineAlreadyExistsException;
import software.amazon.awssdk.services.sfn.model.StateMachineDeletingException;
import software.amazon.awssdk.services.sfn.model.StateMachineDoesNotExistException;
import software.amazon.awssdk.services.sfn.model.StateMachineLimitExceededException;
import software.amazon.awssdk.services.sfn.model.StateMachineTypeNotSupportedException;
import software.amazon.awssdk.services.sfn.model.StopExecutionRequest;
import software.amazon.awssdk.services.sfn.model.StopExecutionResponse;
import software.amazon.awssdk.services.sfn.model.TagResourceRequest;
import software.amazon.awssdk.services.sfn.model.TagResourceResponse;
import software.amazon.awssdk.services.sfn.model.TaskDoesNotExistException;
import software.amazon.awssdk.services.sfn.model.TaskTimedOutException;
import software.amazon.awssdk.services.sfn.model.TestStateRequest;
import software.amazon.awssdk.services.sfn.model.TestStateResponse;
import software.amazon.awssdk.services.sfn.model.TooManyTagsException;
import software.amazon.awssdk.services.sfn.model.UntagResourceRequest;
import software.amazon.awssdk.services.sfn.model.UntagResourceResponse;
import software.amazon.awssdk.services.sfn.model.UpdateMapRunRequest;
import software.amazon.awssdk.services.sfn.model.UpdateMapRunResponse;
import software.amazon.awssdk.services.sfn.model.UpdateStateMachineAliasRequest;
import software.amazon.awssdk.services.sfn.model.UpdateStateMachineAliasResponse;
import software.amazon.awssdk.services.sfn.model.UpdateStateMachineRequest;
import software.amazon.awssdk.services.sfn.model.UpdateStateMachineResponse;
import software.amazon.awssdk.services.sfn.model.ValidateStateMachineDefinitionRequest;
import software.amazon.awssdk.services.sfn.model.ValidateStateMachineDefinitionResponse;
import software.amazon.awssdk.services.sfn.model.ValidationException;
import software.amazon.awssdk.services.sfn.transform.CreateActivityRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.CreateStateMachineAliasRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.CreateStateMachineRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.DeleteActivityRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.DeleteStateMachineAliasRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.DeleteStateMachineRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.DeleteStateMachineVersionRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.DescribeActivityRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.DescribeExecutionRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.DescribeMapRunRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.DescribeStateMachineAliasRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.DescribeStateMachineForExecutionRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.DescribeStateMachineRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.GetActivityTaskRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.GetExecutionHistoryRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.ListActivitiesRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.ListExecutionsRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.ListMapRunsRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.ListStateMachineAliasesRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.ListStateMachineVersionsRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.ListStateMachinesRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.PublishStateMachineVersionRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.RedriveExecutionRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.SendTaskFailureRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.SendTaskHeartbeatRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.SendTaskSuccessRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.StartExecutionRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.StartSyncExecutionRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.StopExecutionRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.TestStateRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.UpdateMapRunRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.UpdateStateMachineAliasRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.UpdateStateMachineRequestMarshaller;
import software.amazon.awssdk.services.sfn.transform.ValidateStateMachineDefinitionRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultSfnAsyncClient
implements SfnAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultSfnAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSfnAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"SFN#2.41.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<CreateActivityResponse> createActivity(CreateActivityRequest createActivityRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createActivityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, createActivityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateActivity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateActivityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateActivity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateActivityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createActivityRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$createActivity$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$createActivity$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateStateMachineResponse> createStateMachine(CreateStateMachineRequest createStateMachineRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createStateMachineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, createStateMachineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateStateMachine");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateStateMachineResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateStateMachine").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateStateMachineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createStateMachineRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$createStateMachine$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$createStateMachine$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateStateMachineAliasResponse> createStateMachineAlias(CreateStateMachineAliasRequest createStateMachineAliasRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createStateMachineAliasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, createStateMachineAliasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateStateMachineAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateStateMachineAliasResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateStateMachineAlias").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateStateMachineAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createStateMachineAliasRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$createStateMachineAlias$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$createStateMachineAlias$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteActivityResponse> deleteActivity(DeleteActivityRequest deleteActivityRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteActivityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, deleteActivityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteActivity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteActivityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteActivity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteActivityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteActivityRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$deleteActivity$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$deleteActivity$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteStateMachineResponse> deleteStateMachine(DeleteStateMachineRequest deleteStateMachineRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteStateMachineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, deleteStateMachineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteStateMachine");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteStateMachineResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStateMachine").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteStateMachineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteStateMachineRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$deleteStateMachine$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$deleteStateMachine$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteStateMachineAliasResponse> deleteStateMachineAlias(DeleteStateMachineAliasRequest deleteStateMachineAliasRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteStateMachineAliasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, deleteStateMachineAliasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteStateMachineAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteStateMachineAliasResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStateMachineAlias").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteStateMachineAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteStateMachineAliasRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$deleteStateMachineAlias$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$deleteStateMachineAlias$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteStateMachineVersionResponse> deleteStateMachineVersion(DeleteStateMachineVersionRequest deleteStateMachineVersionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteStateMachineVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, deleteStateMachineVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteStateMachineVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteStateMachineVersionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStateMachineVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteStateMachineVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteStateMachineVersionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$deleteStateMachineVersion$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$deleteStateMachineVersion$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeActivityResponse> describeActivity(DescribeActivityRequest describeActivityRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeActivityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, describeActivityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeActivity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeActivityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeActivity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeActivityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeActivityRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$describeActivity$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$describeActivity$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeExecutionResponse> describeExecution(DescribeExecutionRequest describeExecutionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, describeExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeExecutionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeExecution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeExecutionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$describeExecution$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$describeExecution$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeMapRunResponse> describeMapRun(DescribeMapRunRequest describeMapRunRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeMapRunRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, describeMapRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMapRun");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMapRunResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMapRun").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeMapRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeMapRunRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$describeMapRun$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$describeMapRun$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeStateMachineResponse> describeStateMachine(DescribeStateMachineRequest describeStateMachineRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeStateMachineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, describeStateMachineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeStateMachine");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeStateMachineResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStateMachine").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeStateMachineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeStateMachineRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$describeStateMachine$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$describeStateMachine$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeStateMachineAliasResponse> describeStateMachineAlias(DescribeStateMachineAliasRequest describeStateMachineAliasRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeStateMachineAliasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, describeStateMachineAliasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeStateMachineAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeStateMachineAliasResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStateMachineAlias").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeStateMachineAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeStateMachineAliasRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$describeStateMachineAlias$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$describeStateMachineAlias$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeStateMachineForExecutionResponse> describeStateMachineForExecution(DescribeStateMachineForExecutionRequest describeStateMachineForExecutionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeStateMachineForExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, describeStateMachineForExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeStateMachineForExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeStateMachineForExecutionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStateMachineForExecution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeStateMachineForExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeStateMachineForExecutionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$describeStateMachineForExecution$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$describeStateMachineForExecution$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetActivityTaskResponse> getActivityTask(GetActivityTaskRequest getActivityTaskRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getActivityTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, getActivityTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetActivityTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetActivityTaskResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetActivityTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetActivityTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getActivityTaskRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$getActivityTask$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$getActivityTask$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetExecutionHistoryResponse> getExecutionHistory(GetExecutionHistoryRequest getExecutionHistoryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getExecutionHistoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, getExecutionHistoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetExecutionHistory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetExecutionHistoryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetExecutionHistory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetExecutionHistoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getExecutionHistoryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$getExecutionHistory$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$getExecutionHistory$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListActivitiesResponse> listActivities(ListActivitiesRequest listActivitiesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listActivitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, listActivitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListActivities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListActivitiesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListActivities").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListActivitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listActivitiesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$listActivities$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$listActivities$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListExecutionsResponse> listExecutions(ListExecutionsRequest listExecutionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listExecutionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, listExecutionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListExecutions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListExecutionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListExecutions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listExecutionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$listExecutions$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$listExecutions$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListMapRunsResponse> listMapRuns(ListMapRunsRequest listMapRunsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listMapRunsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, listMapRunsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMapRuns");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMapRunsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMapRuns").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListMapRunsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listMapRunsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$listMapRuns$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$listMapRuns$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListStateMachineAliasesResponse> listStateMachineAliases(ListStateMachineAliasesRequest listStateMachineAliasesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listStateMachineAliasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, listStateMachineAliasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListStateMachineAliases");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListStateMachineAliasesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStateMachineAliases").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListStateMachineAliasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listStateMachineAliasesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$listStateMachineAliases$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$listStateMachineAliases$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListStateMachineVersionsResponse> listStateMachineVersions(ListStateMachineVersionsRequest listStateMachineVersionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listStateMachineVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, listStateMachineVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListStateMachineVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListStateMachineVersionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStateMachineVersions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListStateMachineVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listStateMachineVersionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$listStateMachineVersions$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$listStateMachineVersions$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListStateMachinesResponse> listStateMachines(ListStateMachinesRequest listStateMachinesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listStateMachinesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, listStateMachinesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListStateMachines");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListStateMachinesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStateMachines").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListStateMachinesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listStateMachinesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$listStateMachines$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$listStateMachines$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$listTagsForResource$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$listTagsForResource$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PublishStateMachineVersionResponse> publishStateMachineVersion(PublishStateMachineVersionRequest publishStateMachineVersionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)publishStateMachineVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, publishStateMachineVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PublishStateMachineVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PublishStateMachineVersionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PublishStateMachineVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PublishStateMachineVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)publishStateMachineVersionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$publishStateMachineVersion$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$publishStateMachineVersion$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RedriveExecutionResponse> redriveExecution(RedriveExecutionRequest redriveExecutionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)redriveExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, redriveExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RedriveExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RedriveExecutionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RedriveExecution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RedriveExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)redriveExecutionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$redriveExecution$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$redriveExecution$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SendTaskFailureResponse> sendTaskFailure(SendTaskFailureRequest sendTaskFailureRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)sendTaskFailureRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, sendTaskFailureRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendTaskFailure");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SendTaskFailureResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendTaskFailure").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SendTaskFailureRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)sendTaskFailureRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$sendTaskFailure$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$sendTaskFailure$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SendTaskHeartbeatResponse> sendTaskHeartbeat(SendTaskHeartbeatRequest sendTaskHeartbeatRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)sendTaskHeartbeatRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, sendTaskHeartbeatRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendTaskHeartbeat");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SendTaskHeartbeatResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendTaskHeartbeat").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SendTaskHeartbeatRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)sendTaskHeartbeatRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$sendTaskHeartbeat$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$sendTaskHeartbeat$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SendTaskSuccessResponse> sendTaskSuccess(SendTaskSuccessRequest sendTaskSuccessRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)sendTaskSuccessRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, sendTaskSuccessRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendTaskSuccess");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SendTaskSuccessResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendTaskSuccess").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SendTaskSuccessRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)sendTaskSuccessRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$sendTaskSuccess$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$sendTaskSuccess$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartExecutionResponse> startExecution(StartExecutionRequest startExecutionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, startExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartExecutionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartExecution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startExecutionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$startExecution$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$startExecution$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartSyncExecutionResponse> startSyncExecution(StartSyncExecutionRequest startSyncExecutionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startSyncExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, startSyncExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartSyncExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartSyncExecutionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "sync-";
            String resolvedHostExpression = "sync-";
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartSyncExecution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartSyncExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)startSyncExecutionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$startSyncExecution$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$startSyncExecution$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopExecutionResponse> stopExecution(StopExecutionRequest stopExecutionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, stopExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopExecutionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopExecution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StopExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopExecutionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$stopExecution$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$stopExecution$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$tagResource$122(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$tagResource$123((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TestStateResponse> testState(TestStateRequest testStateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)testStateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, testStateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TestState");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TestStateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "sync-";
            String resolvedHostExpression = "sync-";
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TestState").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TestStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)testStateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$testState$126(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$testState$127((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$untagResource$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$untagResource$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateMapRunResponse> updateMapRun(UpdateMapRunRequest updateMapRunRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateMapRunRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, updateMapRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateMapRun");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateMapRunResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateMapRun").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateMapRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateMapRunRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$updateMapRun$134(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$updateMapRun$135((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateStateMachineResponse> updateStateMachine(UpdateStateMachineRequest updateStateMachineRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateStateMachineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, updateStateMachineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateStateMachine");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateStateMachineResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateStateMachine").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateStateMachineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateStateMachineRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$updateStateMachine$138(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$updateStateMachine$139((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateStateMachineAliasResponse> updateStateMachineAlias(UpdateStateMachineAliasRequest updateStateMachineAliasRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateStateMachineAliasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, updateStateMachineAliasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateStateMachineAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateStateMachineAliasResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateStateMachineAlias").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateStateMachineAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateStateMachineAliasRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$updateStateMachineAlias$142(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$updateStateMachineAlias$143((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ValidateStateMachineDefinitionResponse> validateStateMachineDefinition(ValidateStateMachineDefinitionRequest validateStateMachineDefinitionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)validateStateMachineDefinitionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSfnAsyncClient.resolveMetricPublishers(clientConfiguration, validateStateMachineDefinitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SFN");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ValidateStateMachineDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ValidateStateMachineDefinitionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ActivityDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityDoesNotExistException::builder).build());
                    }
                    case "StateMachineTypeNotSupported": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineTypeNotSupported").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineTypeNotSupportedException::builder).build());
                    }
                    case "KmsThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                    }
                    case "InvalidDefinition": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDefinition").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDefinitionException::builder).build());
                    }
                    case "InvalidName": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidName").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNameException::builder).build());
                    }
                    case "InvalidLoggingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLoggingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLoggingConfigurationException::builder).build());
                    }
                    case "KmsInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "StateMachineAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineAlreadyExistsException::builder).build());
                    }
                    case "ExecutionLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionLimitExceededException::builder).build());
                    }
                    case "InvalidArn": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArn").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "StateMachineDeleting": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDeleting").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDeletingException::builder).build());
                    }
                    case "ActivityWorkerLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityWorkerLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityWorkerLimitExceededException::builder).build());
                    }
                    case "TaskTimedOut": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskTimedOut").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskTimedOutException::builder).build());
                    }
                    case "ExecutionAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionAlreadyExistsException::builder).build());
                    }
                    case "MissingRequiredParameter": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameter").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ExecutionDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionDoesNotExistException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ExecutionNotRedrivable": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExecutionNotRedrivable").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExecutionNotRedrivableException::builder).build());
                    }
                    case "StateMachineLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineLimitExceededException::builder).build());
                    }
                    case "InvalidToken": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "TooManyTags": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTags").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidEncryptionConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEncryptionConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEncryptionConfigurationException::builder).build());
                    }
                    case "InvalidOutput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOutputException::builder).build());
                    }
                    case "InvalidTracingConfiguration": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTracingConfiguration").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTracingConfigurationException::builder).build());
                    }
                    case "ResourceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ActivityLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityLimitExceededException::builder).build());
                    }
                    case "InvalidExecutionInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExecutionInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExecutionInputException::builder).build());
                    }
                    case "TaskDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TaskDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TaskDoesNotExistException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "KmsAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                    }
                    case "StateMachineDoesNotExist": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StateMachineDoesNotExist").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StateMachineDoesNotExistException::builder).build());
                    }
                    case "ActivityAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActivityAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActivityAlreadyExistsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ValidateStateMachineDefinition").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ValidateStateMachineDefinitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)validateStateMachineDefinitionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSfnAsyncClient.lambda$validateStateMachineDefinition$146(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSfnAsyncClient.lambda$validateStateMachineDefinition$147((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final SfnServiceClientConfiguration serviceClientConfiguration() {
        return new SfnServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "states";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(SfnException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.0");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        SfnServiceClientConfigurationBuilder serviceConfigBuilder = new SfnServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$validateStateMachineDefinition$147(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$validateStateMachineDefinition$146(List metricPublishers, MetricCollector apiCallMetricCollector, ValidateStateMachineDefinitionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateStateMachineAlias$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateStateMachineAlias$142(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateStateMachineAliasResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateStateMachine$139(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateStateMachine$138(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateStateMachineResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateMapRun$135(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateMapRun$134(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateMapRunResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$130(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$testState$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$testState$126(List metricPublishers, MetricCollector apiCallMetricCollector, TestStateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$122(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopExecution$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopExecution$118(List metricPublishers, MetricCollector apiCallMetricCollector, StopExecutionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startSyncExecution$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startSyncExecution$114(List metricPublishers, MetricCollector apiCallMetricCollector, StartSyncExecutionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startExecution$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startExecution$110(List metricPublishers, MetricCollector apiCallMetricCollector, StartExecutionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$sendTaskSuccess$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$sendTaskSuccess$106(List metricPublishers, MetricCollector apiCallMetricCollector, SendTaskSuccessResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$sendTaskHeartbeat$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$sendTaskHeartbeat$102(List metricPublishers, MetricCollector apiCallMetricCollector, SendTaskHeartbeatResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$sendTaskFailure$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$sendTaskFailure$98(List metricPublishers, MetricCollector apiCallMetricCollector, SendTaskFailureResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$redriveExecution$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$redriveExecution$94(List metricPublishers, MetricCollector apiCallMetricCollector, RedriveExecutionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$publishStateMachineVersion$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$publishStateMachineVersion$90(List metricPublishers, MetricCollector apiCallMetricCollector, PublishStateMachineVersionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$86(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listStateMachines$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listStateMachines$82(List metricPublishers, MetricCollector apiCallMetricCollector, ListStateMachinesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listStateMachineVersions$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listStateMachineVersions$78(List metricPublishers, MetricCollector apiCallMetricCollector, ListStateMachineVersionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listStateMachineAliases$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listStateMachineAliases$74(List metricPublishers, MetricCollector apiCallMetricCollector, ListStateMachineAliasesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listMapRuns$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMapRuns$70(List metricPublishers, MetricCollector apiCallMetricCollector, ListMapRunsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listExecutions$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listExecutions$66(List metricPublishers, MetricCollector apiCallMetricCollector, ListExecutionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listActivities$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listActivities$62(List metricPublishers, MetricCollector apiCallMetricCollector, ListActivitiesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getExecutionHistory$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getExecutionHistory$58(List metricPublishers, MetricCollector apiCallMetricCollector, GetExecutionHistoryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getActivityTask$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getActivityTask$54(List metricPublishers, MetricCollector apiCallMetricCollector, GetActivityTaskResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeStateMachineForExecution$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeStateMachineForExecution$50(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeStateMachineForExecutionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeStateMachineAlias$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeStateMachineAlias$46(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeStateMachineAliasResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeStateMachine$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeStateMachine$42(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeStateMachineResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeMapRun$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeMapRun$38(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeMapRunResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeExecution$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeExecution$34(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeExecutionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeActivity$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeActivity$30(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeActivityResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteStateMachineVersion$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteStateMachineVersion$26(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteStateMachineVersionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteStateMachineAlias$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteStateMachineAlias$22(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteStateMachineAliasResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteStateMachine$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteStateMachine$18(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteStateMachineResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteActivity$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteActivity$14(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteActivityResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createStateMachineAlias$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createStateMachineAlias$10(List metricPublishers, MetricCollector apiCallMetricCollector, CreateStateMachineAliasResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createStateMachine$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createStateMachine$6(List metricPublishers, MetricCollector apiCallMetricCollector, CreateStateMachineResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createActivity$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createActivity$2(List metricPublishers, MetricCollector apiCallMetricCollector, CreateActivityResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

