/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sfn.model.InspectionDataRequest;
import software.amazon.awssdk.services.sfn.model.InspectionDataResponse;
import software.amazon.awssdk.services.sfn.model.InspectionErrorDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InspectionData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InspectionData> {
    private static final SdkField<String> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("input").getter(InspectionData.getter(InspectionData::input)).setter(InspectionData.setter(Builder::input)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()}).build();
    private static final SdkField<String> AFTER_ARGUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("afterArguments").getter(InspectionData.getter(InspectionData::afterArguments)).setter(InspectionData.setter(Builder::afterArguments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterArguments").build()}).build();
    private static final SdkField<String> AFTER_INPUT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("afterInputPath").getter(InspectionData.getter(InspectionData::afterInputPath)).setter(InspectionData.setter(Builder::afterInputPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterInputPath").build()}).build();
    private static final SdkField<String> AFTER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("afterParameters").getter(InspectionData.getter(InspectionData::afterParameters)).setter(InspectionData.setter(Builder::afterParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterParameters").build()}).build();
    private static final SdkField<String> RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("result").getter(InspectionData.getter(InspectionData::result)).setter(InspectionData.setter(Builder::result)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()}).build();
    private static final SdkField<String> AFTER_RESULT_SELECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("afterResultSelector").getter(InspectionData.getter(InspectionData::afterResultSelector)).setter(InspectionData.setter(Builder::afterResultSelector)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterResultSelector").build()}).build();
    private static final SdkField<String> AFTER_RESULT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("afterResultPath").getter(InspectionData.getter(InspectionData::afterResultPath)).setter(InspectionData.setter(Builder::afterResultPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterResultPath").build()}).build();
    private static final SdkField<InspectionDataRequest> REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("request").getter(InspectionData.getter(InspectionData::request)).setter(InspectionData.setter(Builder::request)).constructor(InspectionDataRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("request").build()}).build();
    private static final SdkField<InspectionDataResponse> RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("response").getter(InspectionData.getter(InspectionData::response)).setter(InspectionData.setter(Builder::response)).constructor(InspectionDataResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("response").build()}).build();
    private static final SdkField<String> VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("variables").getter(InspectionData.getter(InspectionData::variables)).setter(InspectionData.setter(Builder::variables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build()}).build();
    private static final SdkField<InspectionErrorDetails> ERROR_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("errorDetails").getter(InspectionData.getter(InspectionData::errorDetails)).setter(InspectionData.setter(Builder::errorDetails)).constructor(InspectionErrorDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorDetails").build()}).build();
    private static final SdkField<String> AFTER_ITEMS_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("afterItemsPath").getter(InspectionData.getter(InspectionData::afterItemsPath)).setter(InspectionData.setter(Builder::afterItemsPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterItemsPath").build()}).build();
    private static final SdkField<String> AFTER_ITEM_SELECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("afterItemSelector").getter(InspectionData.getter(InspectionData::afterItemSelector)).setter(InspectionData.setter(Builder::afterItemSelector)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterItemSelector").build()}).build();
    private static final SdkField<String> AFTER_ITEM_BATCHER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("afterItemBatcher").getter(InspectionData.getter(InspectionData::afterItemBatcher)).setter(InspectionData.setter(Builder::afterItemBatcher)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterItemBatcher").build()}).build();
    private static final SdkField<String> AFTER_ITEMS_POINTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("afterItemsPointer").getter(InspectionData.getter(InspectionData::afterItemsPointer)).setter(InspectionData.setter(Builder::afterItemsPointer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterItemsPointer").build()}).build();
    private static final SdkField<Integer> TOLERATED_FAILURE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("toleratedFailureCount").getter(InspectionData.getter(InspectionData::toleratedFailureCount)).setter(InspectionData.setter(Builder::toleratedFailureCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toleratedFailureCount").build()}).build();
    private static final SdkField<Float> TOLERATED_FAILURE_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("toleratedFailurePercentage").getter(InspectionData.getter(InspectionData::toleratedFailurePercentage)).setter(InspectionData.setter(Builder::toleratedFailurePercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toleratedFailurePercentage").build()}).build();
    private static final SdkField<Integer> MAX_CONCURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxConcurrency").getter(InspectionData.getter(InspectionData::maxConcurrency)).setter(InspectionData.setter(Builder::maxConcurrency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxConcurrency").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FIELD, AFTER_ARGUMENTS_FIELD, AFTER_INPUT_PATH_FIELD, AFTER_PARAMETERS_FIELD, RESULT_FIELD, AFTER_RESULT_SELECTOR_FIELD, AFTER_RESULT_PATH_FIELD, REQUEST_FIELD, RESPONSE_FIELD, VARIABLES_FIELD, ERROR_DETAILS_FIELD, AFTER_ITEMS_PATH_FIELD, AFTER_ITEM_SELECTOR_FIELD, AFTER_ITEM_BATCHER_FIELD, AFTER_ITEMS_POINTER_FIELD, TOLERATED_FAILURE_COUNT_FIELD, TOLERATED_FAILURE_PERCENTAGE_FIELD, MAX_CONCURRENCY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InspectionData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String input;
    private final String afterArguments;
    private final String afterInputPath;
    private final String afterParameters;
    private final String result;
    private final String afterResultSelector;
    private final String afterResultPath;
    private final InspectionDataRequest request;
    private final InspectionDataResponse response;
    private final String variables;
    private final InspectionErrorDetails errorDetails;
    private final String afterItemsPath;
    private final String afterItemSelector;
    private final String afterItemBatcher;
    private final String afterItemsPointer;
    private final Integer toleratedFailureCount;
    private final Float toleratedFailurePercentage;
    private final Integer maxConcurrency;

    private InspectionData(BuilderImpl builder) {
        this.input = builder.input;
        this.afterArguments = builder.afterArguments;
        this.afterInputPath = builder.afterInputPath;
        this.afterParameters = builder.afterParameters;
        this.result = builder.result;
        this.afterResultSelector = builder.afterResultSelector;
        this.afterResultPath = builder.afterResultPath;
        this.request = builder.request;
        this.response = builder.response;
        this.variables = builder.variables;
        this.errorDetails = builder.errorDetails;
        this.afterItemsPath = builder.afterItemsPath;
        this.afterItemSelector = builder.afterItemSelector;
        this.afterItemBatcher = builder.afterItemBatcher;
        this.afterItemsPointer = builder.afterItemsPointer;
        this.toleratedFailureCount = builder.toleratedFailureCount;
        this.toleratedFailurePercentage = builder.toleratedFailurePercentage;
        this.maxConcurrency = builder.maxConcurrency;
    }

    public final String input() {
        return this.input;
    }

    public final String afterArguments() {
        return this.afterArguments;
    }

    public final String afterInputPath() {
        return this.afterInputPath;
    }

    public final String afterParameters() {
        return this.afterParameters;
    }

    public final String result() {
        return this.result;
    }

    public final String afterResultSelector() {
        return this.afterResultSelector;
    }

    public final String afterResultPath() {
        return this.afterResultPath;
    }

    public final InspectionDataRequest request() {
        return this.request;
    }

    public final InspectionDataResponse response() {
        return this.response;
    }

    public final String variables() {
        return this.variables;
    }

    public final InspectionErrorDetails errorDetails() {
        return this.errorDetails;
    }

    public final String afterItemsPath() {
        return this.afterItemsPath;
    }

    public final String afterItemSelector() {
        return this.afterItemSelector;
    }

    public final String afterItemBatcher() {
        return this.afterItemBatcher;
    }

    public final String afterItemsPointer() {
        return this.afterItemsPointer;
    }

    public final Integer toleratedFailureCount() {
        return this.toleratedFailureCount;
    }

    public final Float toleratedFailurePercentage() {
        return this.toleratedFailurePercentage;
    }

    public final Integer maxConcurrency() {
        return this.maxConcurrency;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.afterArguments());
        hashCode = 31 * hashCode + Objects.hashCode(this.afterInputPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.afterParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.result());
        hashCode = 31 * hashCode + Objects.hashCode(this.afterResultSelector());
        hashCode = 31 * hashCode + Objects.hashCode(this.afterResultPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.request());
        hashCode = 31 * hashCode + Objects.hashCode(this.response());
        hashCode = 31 * hashCode + Objects.hashCode(this.variables());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.afterItemsPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.afterItemSelector());
        hashCode = 31 * hashCode + Objects.hashCode(this.afterItemBatcher());
        hashCode = 31 * hashCode + Objects.hashCode(this.afterItemsPointer());
        hashCode = 31 * hashCode + Objects.hashCode(this.toleratedFailureCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.toleratedFailurePercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrency());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InspectionData)) {
            return false;
        }
        InspectionData other = (InspectionData)obj;
        return Objects.equals(this.input(), other.input()) && Objects.equals(this.afterArguments(), other.afterArguments()) && Objects.equals(this.afterInputPath(), other.afterInputPath()) && Objects.equals(this.afterParameters(), other.afterParameters()) && Objects.equals(this.result(), other.result()) && Objects.equals(this.afterResultSelector(), other.afterResultSelector()) && Objects.equals(this.afterResultPath(), other.afterResultPath()) && Objects.equals(this.request(), other.request()) && Objects.equals(this.response(), other.response()) && Objects.equals(this.variables(), other.variables()) && Objects.equals(this.errorDetails(), other.errorDetails()) && Objects.equals(this.afterItemsPath(), other.afterItemsPath()) && Objects.equals(this.afterItemSelector(), other.afterItemSelector()) && Objects.equals(this.afterItemBatcher(), other.afterItemBatcher()) && Objects.equals(this.afterItemsPointer(), other.afterItemsPointer()) && Objects.equals(this.toleratedFailureCount(), other.toleratedFailureCount()) && Objects.equals(this.toleratedFailurePercentage(), other.toleratedFailurePercentage()) && Objects.equals(this.maxConcurrency(), other.maxConcurrency());
    }

    public final String toString() {
        return ToString.builder((String)"InspectionData").add("Input", (Object)(this.input() == null ? null : "*** Sensitive Data Redacted ***")).add("AfterArguments", (Object)(this.afterArguments() == null ? null : "*** Sensitive Data Redacted ***")).add("AfterInputPath", (Object)(this.afterInputPath() == null ? null : "*** Sensitive Data Redacted ***")).add("AfterParameters", (Object)(this.afterParameters() == null ? null : "*** Sensitive Data Redacted ***")).add("Result", (Object)(this.result() == null ? null : "*** Sensitive Data Redacted ***")).add("AfterResultSelector", (Object)(this.afterResultSelector() == null ? null : "*** Sensitive Data Redacted ***")).add("AfterResultPath", (Object)(this.afterResultPath() == null ? null : "*** Sensitive Data Redacted ***")).add("Request", (Object)this.request()).add("Response", (Object)this.response()).add("Variables", (Object)(this.variables() == null ? null : "*** Sensitive Data Redacted ***")).add("ErrorDetails", (Object)this.errorDetails()).add("AfterItemsPath", (Object)(this.afterItemsPath() == null ? null : "*** Sensitive Data Redacted ***")).add("AfterItemSelector", (Object)(this.afterItemSelector() == null ? null : "*** Sensitive Data Redacted ***")).add("AfterItemBatcher", (Object)(this.afterItemBatcher() == null ? null : "*** Sensitive Data Redacted ***")).add("AfterItemsPointer", (Object)(this.afterItemsPointer() == null ? null : "*** Sensitive Data Redacted ***")).add("ToleratedFailureCount", (Object)(this.toleratedFailureCount() == null ? null : "*** Sensitive Data Redacted ***")).add("ToleratedFailurePercentage", (Object)(this.toleratedFailurePercentage() == null ? null : "*** Sensitive Data Redacted ***")).add("MaxConcurrency", (Object)(this.maxConcurrency() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "afterArguments": {
                return Optional.ofNullable(clazz.cast(this.afterArguments()));
            }
            case "afterInputPath": {
                return Optional.ofNullable(clazz.cast(this.afterInputPath()));
            }
            case "afterParameters": {
                return Optional.ofNullable(clazz.cast(this.afterParameters()));
            }
            case "result": {
                return Optional.ofNullable(clazz.cast(this.result()));
            }
            case "afterResultSelector": {
                return Optional.ofNullable(clazz.cast(this.afterResultSelector()));
            }
            case "afterResultPath": {
                return Optional.ofNullable(clazz.cast(this.afterResultPath()));
            }
            case "request": {
                return Optional.ofNullable(clazz.cast(this.request()));
            }
            case "response": {
                return Optional.ofNullable(clazz.cast(this.response()));
            }
            case "variables": {
                return Optional.ofNullable(clazz.cast(this.variables()));
            }
            case "errorDetails": {
                return Optional.ofNullable(clazz.cast(this.errorDetails()));
            }
            case "afterItemsPath": {
                return Optional.ofNullable(clazz.cast(this.afterItemsPath()));
            }
            case "afterItemSelector": {
                return Optional.ofNullable(clazz.cast(this.afterItemSelector()));
            }
            case "afterItemBatcher": {
                return Optional.ofNullable(clazz.cast(this.afterItemBatcher()));
            }
            case "afterItemsPointer": {
                return Optional.ofNullable(clazz.cast(this.afterItemsPointer()));
            }
            case "toleratedFailureCount": {
                return Optional.ofNullable(clazz.cast(this.toleratedFailureCount()));
            }
            case "toleratedFailurePercentage": {
                return Optional.ofNullable(clazz.cast(this.toleratedFailurePercentage()));
            }
            case "maxConcurrency": {
                return Optional.ofNullable(clazz.cast(this.maxConcurrency()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("input", INPUT_FIELD);
        map.put("afterArguments", AFTER_ARGUMENTS_FIELD);
        map.put("afterInputPath", AFTER_INPUT_PATH_FIELD);
        map.put("afterParameters", AFTER_PARAMETERS_FIELD);
        map.put("result", RESULT_FIELD);
        map.put("afterResultSelector", AFTER_RESULT_SELECTOR_FIELD);
        map.put("afterResultPath", AFTER_RESULT_PATH_FIELD);
        map.put("request", REQUEST_FIELD);
        map.put("response", RESPONSE_FIELD);
        map.put("variables", VARIABLES_FIELD);
        map.put("errorDetails", ERROR_DETAILS_FIELD);
        map.put("afterItemsPath", AFTER_ITEMS_PATH_FIELD);
        map.put("afterItemSelector", AFTER_ITEM_SELECTOR_FIELD);
        map.put("afterItemBatcher", AFTER_ITEM_BATCHER_FIELD);
        map.put("afterItemsPointer", AFTER_ITEMS_POINTER_FIELD);
        map.put("toleratedFailureCount", TOLERATED_FAILURE_COUNT_FIELD);
        map.put("toleratedFailurePercentage", TOLERATED_FAILURE_PERCENTAGE_FIELD);
        map.put("maxConcurrency", MAX_CONCURRENCY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InspectionData, T> g) {
        return obj -> g.apply((InspectionData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String input;
        private String afterArguments;
        private String afterInputPath;
        private String afterParameters;
        private String result;
        private String afterResultSelector;
        private String afterResultPath;
        private InspectionDataRequest request;
        private InspectionDataResponse response;
        private String variables;
        private InspectionErrorDetails errorDetails;
        private String afterItemsPath;
        private String afterItemSelector;
        private String afterItemBatcher;
        private String afterItemsPointer;
        private Integer toleratedFailureCount;
        private Float toleratedFailurePercentage;
        private Integer maxConcurrency;

        private BuilderImpl() {
        }

        private BuilderImpl(InspectionData model) {
            this.input(model.input);
            this.afterArguments(model.afterArguments);
            this.afterInputPath(model.afterInputPath);
            this.afterParameters(model.afterParameters);
            this.result(model.result);
            this.afterResultSelector(model.afterResultSelector);
            this.afterResultPath(model.afterResultPath);
            this.request(model.request);
            this.response(model.response);
            this.variables(model.variables);
            this.errorDetails(model.errorDetails);
            this.afterItemsPath(model.afterItemsPath);
            this.afterItemSelector(model.afterItemSelector);
            this.afterItemBatcher(model.afterItemBatcher);
            this.afterItemsPointer(model.afterItemsPointer);
            this.toleratedFailureCount(model.toleratedFailureCount);
            this.toleratedFailurePercentage(model.toleratedFailurePercentage);
            this.maxConcurrency(model.maxConcurrency);
        }

        public final String getInput() {
            return this.input;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final String getAfterArguments() {
            return this.afterArguments;
        }

        public final void setAfterArguments(String afterArguments) {
            this.afterArguments = afterArguments;
        }

        @Override
        public final Builder afterArguments(String afterArguments) {
            this.afterArguments = afterArguments;
            return this;
        }

        public final String getAfterInputPath() {
            return this.afterInputPath;
        }

        public final void setAfterInputPath(String afterInputPath) {
            this.afterInputPath = afterInputPath;
        }

        @Override
        public final Builder afterInputPath(String afterInputPath) {
            this.afterInputPath = afterInputPath;
            return this;
        }

        public final String getAfterParameters() {
            return this.afterParameters;
        }

        public final void setAfterParameters(String afterParameters) {
            this.afterParameters = afterParameters;
        }

        @Override
        public final Builder afterParameters(String afterParameters) {
            this.afterParameters = afterParameters;
            return this;
        }

        public final String getResult() {
            return this.result;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        public final String getAfterResultSelector() {
            return this.afterResultSelector;
        }

        public final void setAfterResultSelector(String afterResultSelector) {
            this.afterResultSelector = afterResultSelector;
        }

        @Override
        public final Builder afterResultSelector(String afterResultSelector) {
            this.afterResultSelector = afterResultSelector;
            return this;
        }

        public final String getAfterResultPath() {
            return this.afterResultPath;
        }

        public final void setAfterResultPath(String afterResultPath) {
            this.afterResultPath = afterResultPath;
        }

        @Override
        public final Builder afterResultPath(String afterResultPath) {
            this.afterResultPath = afterResultPath;
            return this;
        }

        public final InspectionDataRequest.Builder getRequest() {
            return this.request != null ? this.request.toBuilder() : null;
        }

        public final void setRequest(InspectionDataRequest.BuilderImpl request) {
            this.request = request != null ? request.build() : null;
        }

        @Override
        public final Builder request(InspectionDataRequest request) {
            this.request = request;
            return this;
        }

        public final InspectionDataResponse.Builder getResponse() {
            return this.response != null ? this.response.toBuilder() : null;
        }

        public final void setResponse(InspectionDataResponse.BuilderImpl response) {
            this.response = response != null ? response.build() : null;
        }

        @Override
        public final Builder response(InspectionDataResponse response) {
            this.response = response;
            return this;
        }

        public final String getVariables() {
            return this.variables;
        }

        public final void setVariables(String variables) {
            this.variables = variables;
        }

        @Override
        public final Builder variables(String variables) {
            this.variables = variables;
            return this;
        }

        public final InspectionErrorDetails.Builder getErrorDetails() {
            return this.errorDetails != null ? this.errorDetails.toBuilder() : null;
        }

        public final void setErrorDetails(InspectionErrorDetails.BuilderImpl errorDetails) {
            this.errorDetails = errorDetails != null ? errorDetails.build() : null;
        }

        @Override
        public final Builder errorDetails(InspectionErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public final String getAfterItemsPath() {
            return this.afterItemsPath;
        }

        public final void setAfterItemsPath(String afterItemsPath) {
            this.afterItemsPath = afterItemsPath;
        }

        @Override
        public final Builder afterItemsPath(String afterItemsPath) {
            this.afterItemsPath = afterItemsPath;
            return this;
        }

        public final String getAfterItemSelector() {
            return this.afterItemSelector;
        }

        public final void setAfterItemSelector(String afterItemSelector) {
            this.afterItemSelector = afterItemSelector;
        }

        @Override
        public final Builder afterItemSelector(String afterItemSelector) {
            this.afterItemSelector = afterItemSelector;
            return this;
        }

        public final String getAfterItemBatcher() {
            return this.afterItemBatcher;
        }

        public final void setAfterItemBatcher(String afterItemBatcher) {
            this.afterItemBatcher = afterItemBatcher;
        }

        @Override
        public final Builder afterItemBatcher(String afterItemBatcher) {
            this.afterItemBatcher = afterItemBatcher;
            return this;
        }

        public final String getAfterItemsPointer() {
            return this.afterItemsPointer;
        }

        public final void setAfterItemsPointer(String afterItemsPointer) {
            this.afterItemsPointer = afterItemsPointer;
        }

        @Override
        public final Builder afterItemsPointer(String afterItemsPointer) {
            this.afterItemsPointer = afterItemsPointer;
            return this;
        }

        public final Integer getToleratedFailureCount() {
            return this.toleratedFailureCount;
        }

        public final void setToleratedFailureCount(Integer toleratedFailureCount) {
            this.toleratedFailureCount = toleratedFailureCount;
        }

        @Override
        public final Builder toleratedFailureCount(Integer toleratedFailureCount) {
            this.toleratedFailureCount = toleratedFailureCount;
            return this;
        }

        public final Float getToleratedFailurePercentage() {
            return this.toleratedFailurePercentage;
        }

        public final void setToleratedFailurePercentage(Float toleratedFailurePercentage) {
            this.toleratedFailurePercentage = toleratedFailurePercentage;
        }

        @Override
        public final Builder toleratedFailurePercentage(Float toleratedFailurePercentage) {
            this.toleratedFailurePercentage = toleratedFailurePercentage;
            return this;
        }

        public final Integer getMaxConcurrency() {
            return this.maxConcurrency;
        }

        public final void setMaxConcurrency(Integer maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(Integer maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public InspectionData build() {
            return new InspectionData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InspectionData> {
        public Builder input(String var1);

        public Builder afterArguments(String var1);

        public Builder afterInputPath(String var1);

        public Builder afterParameters(String var1);

        public Builder result(String var1);

        public Builder afterResultSelector(String var1);

        public Builder afterResultPath(String var1);

        public Builder request(InspectionDataRequest var1);

        default public Builder request(Consumer<InspectionDataRequest.Builder> request) {
            return this.request((InspectionDataRequest)((InspectionDataRequest.Builder)InspectionDataRequest.builder().applyMutation(request)).build());
        }

        public Builder response(InspectionDataResponse var1);

        default public Builder response(Consumer<InspectionDataResponse.Builder> response) {
            return this.response((InspectionDataResponse)((InspectionDataResponse.Builder)InspectionDataResponse.builder().applyMutation(response)).build());
        }

        public Builder variables(String var1);

        public Builder errorDetails(InspectionErrorDetails var1);

        default public Builder errorDetails(Consumer<InspectionErrorDetails.Builder> errorDetails) {
            return this.errorDetails((InspectionErrorDetails)((InspectionErrorDetails.Builder)InspectionErrorDetails.builder().applyMutation(errorDetails)).build());
        }

        public Builder afterItemsPath(String var1);

        public Builder afterItemSelector(String var1);

        public Builder afterItemBatcher(String var1);

        public Builder afterItemsPointer(String var1);

        public Builder toleratedFailureCount(Integer var1);

        public Builder toleratedFailurePercentage(Float var1);

        public Builder maxConcurrency(Integer var1);
    }
}

