/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON object that contains a mocked <code>result</code> or <code>errorOutput</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MockInput implements SdkPojo, Serializable, ToCopyableBuilder<MockInput.Builder, MockInput> {
    private static final SdkField<String> RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("result")
            .getter(getter(MockInput::result)).setter(setter(Builder::result))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()).build();

    private static final SdkField<MockErrorOutput> ERROR_OUTPUT_FIELD = SdkField
            .<MockErrorOutput> builder(MarshallingType.SDK_POJO).memberName("errorOutput").getter(getter(MockInput::errorOutput))
            .setter(setter(Builder::errorOutput)).constructor(MockErrorOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorOutput").build()).build();

    private static final SdkField<String> FIELD_VALIDATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fieldValidationMode").getter(getter(MockInput::fieldValidationModeAsString))
            .setter(setter(Builder::fieldValidationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldValidationMode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_FIELD,
            ERROR_OUTPUT_FIELD, FIELD_VALIDATION_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String result;

    private final MockErrorOutput errorOutput;

    private final String fieldValidationMode;

    private MockInput(BuilderImpl builder) {
        this.result = builder.result;
        this.errorOutput = builder.errorOutput;
        this.fieldValidationMode = builder.fieldValidationMode;
    }

    /**
     * <p>
     * A JSON string containing the mocked result of the state invocation.
     * </p>
     * 
     * @return A JSON string containing the mocked result of the state invocation.
     */
    public final String result() {
        return result;
    }

    /**
     * <p>
     * The mocked error output when calling TestState. When specified, the mocked response is returned as a JSON object
     * that contains an <code>error</code> and <code>cause</code> field.
     * </p>
     * 
     * @return The mocked error output when calling TestState. When specified, the mocked response is returned as a JSON
     *         object that contains an <code>error</code> and <code>cause</code> field.
     */
    public final MockErrorOutput errorOutput() {
        return errorOutput;
    }

    /**
     * <p>
     * Determines the level of strictness when validating mocked results against their respective API models. Values
     * include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>STRICT</code>: All required fields must be present, and all present fields must conform to the API's
     * schema.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PRESENT</code>: All present fields must conform to the API's schema.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code>: No validation is performed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If no value is specified, the default value is <code>STRICT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #fieldValidationMode} will return {@link MockResponseValidationMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #fieldValidationModeAsString}.
     * </p>
     * 
     * @return Determines the level of strictness when validating mocked results against their respective API models.
     *         Values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>STRICT</code>: All required fields must be present, and all present fields must conform to the
     *         API's schema.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PRESENT</code>: All present fields must conform to the API's schema.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code>: No validation is performed.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If no value is specified, the default value is <code>STRICT</code>.
     * @see MockResponseValidationMode
     */
    public final MockResponseValidationMode fieldValidationMode() {
        return MockResponseValidationMode.fromValue(fieldValidationMode);
    }

    /**
     * <p>
     * Determines the level of strictness when validating mocked results against their respective API models. Values
     * include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>STRICT</code>: All required fields must be present, and all present fields must conform to the API's
     * schema.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PRESENT</code>: All present fields must conform to the API's schema.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code>: No validation is performed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If no value is specified, the default value is <code>STRICT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #fieldValidationMode} will return {@link MockResponseValidationMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #fieldValidationModeAsString}.
     * </p>
     * 
     * @return Determines the level of strictness when validating mocked results against their respective API models.
     *         Values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>STRICT</code>: All required fields must be present, and all present fields must conform to the
     *         API's schema.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PRESENT</code>: All present fields must conform to the API's schema.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code>: No validation is performed.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If no value is specified, the default value is <code>STRICT</code>.
     * @see MockResponseValidationMode
     */
    public final String fieldValidationModeAsString() {
        return fieldValidationMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(result());
        hashCode = 31 * hashCode + Objects.hashCode(errorOutput());
        hashCode = 31 * hashCode + Objects.hashCode(fieldValidationModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MockInput)) {
            return false;
        }
        MockInput other = (MockInput) obj;
        return Objects.equals(result(), other.result()) && Objects.equals(errorOutput(), other.errorOutput())
                && Objects.equals(fieldValidationModeAsString(), other.fieldValidationModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MockInput").add("Result", result() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ErrorOutput", errorOutput()).add("FieldValidationMode", fieldValidationModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "result":
            return Optional.ofNullable(clazz.cast(result()));
        case "errorOutput":
            return Optional.ofNullable(clazz.cast(errorOutput()));
        case "fieldValidationMode":
            return Optional.ofNullable(clazz.cast(fieldValidationModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("result", RESULT_FIELD);
        map.put("errorOutput", ERROR_OUTPUT_FIELD);
        map.put("fieldValidationMode", FIELD_VALIDATION_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MockInput, T> g) {
        return obj -> g.apply((MockInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MockInput> {
        /**
         * <p>
         * A JSON string containing the mocked result of the state invocation.
         * </p>
         * 
         * @param result
         *        A JSON string containing the mocked result of the state invocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder result(String result);

        /**
         * <p>
         * The mocked error output when calling TestState. When specified, the mocked response is returned as a JSON
         * object that contains an <code>error</code> and <code>cause</code> field.
         * </p>
         * 
         * @param errorOutput
         *        The mocked error output when calling TestState. When specified, the mocked response is returned as a
         *        JSON object that contains an <code>error</code> and <code>cause</code> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorOutput(MockErrorOutput errorOutput);

        /**
         * <p>
         * The mocked error output when calling TestState. When specified, the mocked response is returned as a JSON
         * object that contains an <code>error</code> and <code>cause</code> field.
         * </p>
         * This is a convenience method that creates an instance of the {@link MockErrorOutput.Builder} avoiding the
         * need to create one manually via {@link MockErrorOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MockErrorOutput.Builder#build()} is called immediately and its
         * result is passed to {@link #errorOutput(MockErrorOutput)}.
         * 
         * @param errorOutput
         *        a consumer that will call methods on {@link MockErrorOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorOutput(MockErrorOutput)
         */
        default Builder errorOutput(Consumer<MockErrorOutput.Builder> errorOutput) {
            return errorOutput(MockErrorOutput.builder().applyMutation(errorOutput).build());
        }

        /**
         * <p>
         * Determines the level of strictness when validating mocked results against their respective API models. Values
         * include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>STRICT</code>: All required fields must be present, and all present fields must conform to the API's
         * schema.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PRESENT</code>: All present fields must conform to the API's schema.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code>: No validation is performed.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If no value is specified, the default value is <code>STRICT</code>.
         * </p>
         * 
         * @param fieldValidationMode
         *        Determines the level of strictness when validating mocked results against their respective API models.
         *        Values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>STRICT</code>: All required fields must be present, and all present fields must conform to the
         *        API's schema.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PRESENT</code>: All present fields must conform to the API's schema.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code>: No validation is performed.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If no value is specified, the default value is <code>STRICT</code>.
         * @see MockResponseValidationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MockResponseValidationMode
         */
        Builder fieldValidationMode(String fieldValidationMode);

        /**
         * <p>
         * Determines the level of strictness when validating mocked results against their respective API models. Values
         * include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>STRICT</code>: All required fields must be present, and all present fields must conform to the API's
         * schema.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PRESENT</code>: All present fields must conform to the API's schema.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code>: No validation is performed.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If no value is specified, the default value is <code>STRICT</code>.
         * </p>
         * 
         * @param fieldValidationMode
         *        Determines the level of strictness when validating mocked results against their respective API models.
         *        Values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>STRICT</code>: All required fields must be present, and all present fields must conform to the
         *        API's schema.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PRESENT</code>: All present fields must conform to the API's schema.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code>: No validation is performed.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If no value is specified, the default value is <code>STRICT</code>.
         * @see MockResponseValidationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MockResponseValidationMode
         */
        Builder fieldValidationMode(MockResponseValidationMode fieldValidationMode);
    }

    static final class BuilderImpl implements Builder {
        private String result;

        private MockErrorOutput errorOutput;

        private String fieldValidationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(MockInput model) {
            result(model.result);
            errorOutput(model.errorOutput);
            fieldValidationMode(model.fieldValidationMode);
        }

        public final String getResult() {
            return result;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        public final MockErrorOutput.Builder getErrorOutput() {
            return errorOutput != null ? errorOutput.toBuilder() : null;
        }

        public final void setErrorOutput(MockErrorOutput.BuilderImpl errorOutput) {
            this.errorOutput = errorOutput != null ? errorOutput.build() : null;
        }

        @Override
        public final Builder errorOutput(MockErrorOutput errorOutput) {
            this.errorOutput = errorOutput;
            return this;
        }

        public final String getFieldValidationMode() {
            return fieldValidationMode;
        }

        public final void setFieldValidationMode(String fieldValidationMode) {
            this.fieldValidationMode = fieldValidationMode;
        }

        @Override
        public final Builder fieldValidationMode(String fieldValidationMode) {
            this.fieldValidationMode = fieldValidationMode;
            return this;
        }

        @Override
        public final Builder fieldValidationMode(MockResponseValidationMode fieldValidationMode) {
            this.fieldValidationMode(fieldValidationMode == null ? null : fieldValidationMode.toString());
            return this;
        }

        @Override
        public MockInput build() {
            return new MockInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
