/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidateStateMachineDefinitionRequest extends SfnRequest implements
        ToCopyableBuilder<ValidateStateMachineDefinitionRequest.Builder, ValidateStateMachineDefinitionRequest> {
    private static final SdkField<String> DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("definition").getter(getter(ValidateStateMachineDefinitionRequest::definition))
            .setter(setter(Builder::definition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ValidateStateMachineDefinitionRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("severity").getter(getter(ValidateStateMachineDefinitionRequest::severityAsString))
            .setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ValidateStateMachineDefinitionRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFINITION_FIELD, TYPE_FIELD,
            SEVERITY_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String definition;

    private final String type;

    private final String severity;

    private final Integer maxResults;

    private ValidateStateMachineDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.definition = builder.definition;
        this.type = builder.type;
        this.severity = builder.severity;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The Amazon States Language definition of the state machine. For more information, see <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States
     * Language</a> (ASL).
     * </p>
     * 
     * @return The Amazon States Language definition of the state machine. For more information, see <a
     *         href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon
     *         States Language</a> (ASL).
     */
    public final String definition() {
        return definition;
    }

    /**
     * <p>
     * The target type of state machine for this definition. The default is <code>STANDARD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link StateMachineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The target type of state machine for this definition. The default is <code>STANDARD</code>.
     * @see StateMachineType
     */
    public final StateMachineType type() {
        return StateMachineType.fromValue(type);
    }

    /**
     * <p>
     * The target type of state machine for this definition. The default is <code>STANDARD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link StateMachineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The target type of state machine for this definition. The default is <code>STANDARD</code>.
     * @see StateMachineType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Minimum level of diagnostics to return. <code>ERROR</code> returns only <code>ERROR</code> diagnostics, whereas
     * <code>WARNING</code> returns both <code>WARNING</code> and <code>ERROR</code> diagnostics. The default is
     * <code>ERROR</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link ValidateStateMachineDefinitionSeverity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #severityAsString}.
     * </p>
     * 
     * @return Minimum level of diagnostics to return. <code>ERROR</code> returns only <code>ERROR</code> diagnostics,
     *         whereas <code>WARNING</code> returns both <code>WARNING</code> and <code>ERROR</code> diagnostics. The
     *         default is <code>ERROR</code>.
     * @see ValidateStateMachineDefinitionSeverity
     */
    public final ValidateStateMachineDefinitionSeverity severity() {
        return ValidateStateMachineDefinitionSeverity.fromValue(severity);
    }

    /**
     * <p>
     * Minimum level of diagnostics to return. <code>ERROR</code> returns only <code>ERROR</code> diagnostics, whereas
     * <code>WARNING</code> returns both <code>WARNING</code> and <code>ERROR</code> diagnostics. The default is
     * <code>ERROR</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link ValidateStateMachineDefinitionSeverity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #severityAsString}.
     * </p>
     * 
     * @return Minimum level of diagnostics to return. <code>ERROR</code> returns only <code>ERROR</code> diagnostics,
     *         whereas <code>WARNING</code> returns both <code>WARNING</code> and <code>ERROR</code> diagnostics. The
     *         default is <code>ERROR</code>.
     * @see ValidateStateMachineDefinitionSeverity
     */
    public final String severityAsString() {
        return severity;
    }

    /**
     * <p>
     * The maximum number of diagnostics that are returned per call. The default and maximum value is 100. Setting the
     * value to 0 will also use the default of 100.
     * </p>
     * <p>
     * If the number of diagnostics returned in the response exceeds <code>maxResults</code>, the value of the
     * <code>truncated</code> field in the response will be set to <code>true</code>.
     * </p>
     * 
     * @return The maximum number of diagnostics that are returned per call. The default and maximum value is 100.
     *         Setting the value to 0 will also use the default of 100.</p>
     *         <p>
     *         If the number of diagnostics returned in the response exceeds <code>maxResults</code>, the value of the
     *         <code>truncated</code> field in the response will be set to <code>true</code>.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidateStateMachineDefinitionRequest)) {
            return false;
        }
        ValidateStateMachineDefinitionRequest other = (ValidateStateMachineDefinitionRequest) obj;
        return Objects.equals(definition(), other.definition()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(severityAsString(), other.severityAsString())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ValidateStateMachineDefinitionRequest")
                .add("Definition", definition() == null ? null : "*** Sensitive Data Redacted ***").add("Type", typeAsString())
                .add("Severity", severityAsString()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "severity":
            return Optional.ofNullable(clazz.cast(severityAsString()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("definition", DEFINITION_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("severity", SEVERITY_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValidateStateMachineDefinitionRequest, T> g) {
        return obj -> g.apply((ValidateStateMachineDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SfnRequest.Builder, SdkPojo, CopyableBuilder<Builder, ValidateStateMachineDefinitionRequest> {
        /**
         * <p>
         * The Amazon States Language definition of the state machine. For more information, see <a
         * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon
         * States Language</a> (ASL).
         * </p>
         * 
         * @param definition
         *        The Amazon States Language definition of the state machine. For more information, see <a
         *        href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html"
         *        >Amazon States Language</a> (ASL).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(String definition);

        /**
         * <p>
         * The target type of state machine for this definition. The default is <code>STANDARD</code>.
         * </p>
         * 
         * @param type
         *        The target type of state machine for this definition. The default is <code>STANDARD</code>.
         * @see StateMachineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StateMachineType
         */
        Builder type(String type);

        /**
         * <p>
         * The target type of state machine for this definition. The default is <code>STANDARD</code>.
         * </p>
         * 
         * @param type
         *        The target type of state machine for this definition. The default is <code>STANDARD</code>.
         * @see StateMachineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StateMachineType
         */
        Builder type(StateMachineType type);

        /**
         * <p>
         * Minimum level of diagnostics to return. <code>ERROR</code> returns only <code>ERROR</code> diagnostics,
         * whereas <code>WARNING</code> returns both <code>WARNING</code> and <code>ERROR</code> diagnostics. The
         * default is <code>ERROR</code>.
         * </p>
         * 
         * @param severity
         *        Minimum level of diagnostics to return. <code>ERROR</code> returns only <code>ERROR</code>
         *        diagnostics, whereas <code>WARNING</code> returns both <code>WARNING</code> and <code>ERROR</code>
         *        diagnostics. The default is <code>ERROR</code>.
         * @see ValidateStateMachineDefinitionSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidateStateMachineDefinitionSeverity
         */
        Builder severity(String severity);

        /**
         * <p>
         * Minimum level of diagnostics to return. <code>ERROR</code> returns only <code>ERROR</code> diagnostics,
         * whereas <code>WARNING</code> returns both <code>WARNING</code> and <code>ERROR</code> diagnostics. The
         * default is <code>ERROR</code>.
         * </p>
         * 
         * @param severity
         *        Minimum level of diagnostics to return. <code>ERROR</code> returns only <code>ERROR</code>
         *        diagnostics, whereas <code>WARNING</code> returns both <code>WARNING</code> and <code>ERROR</code>
         *        diagnostics. The default is <code>ERROR</code>.
         * @see ValidateStateMachineDefinitionSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidateStateMachineDefinitionSeverity
         */
        Builder severity(ValidateStateMachineDefinitionSeverity severity);

        /**
         * <p>
         * The maximum number of diagnostics that are returned per call. The default and maximum value is 100. Setting
         * the value to 0 will also use the default of 100.
         * </p>
         * <p>
         * If the number of diagnostics returned in the response exceeds <code>maxResults</code>, the value of the
         * <code>truncated</code> field in the response will be set to <code>true</code>.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of diagnostics that are returned per call. The default and maximum value is 100.
         *        Setting the value to 0 will also use the default of 100.</p>
         *        <p>
         *        If the number of diagnostics returned in the response exceeds <code>maxResults</code>, the value of
         *        the <code>truncated</code> field in the response will be set to <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SfnRequest.BuilderImpl implements Builder {
        private String definition;

        private String type;

        private String severity;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidateStateMachineDefinitionRequest model) {
            super(model);
            definition(model.definition);
            type(model.type);
            severity(model.severity);
            maxResults(model.maxResults);
        }

        public final String getDefinition() {
            return definition;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(StateMachineType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getSeverity() {
            return severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(ValidateStateMachineDefinitionSeverity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ValidateStateMachineDefinitionRequest build() {
            return new ValidateStateMachineDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
