/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum KmsKeyState {
    DISABLED("DISABLED"),
    PENDING_DELETION("PENDING_DELETION"),
    PENDING_IMPORT("PENDING_IMPORT"),
    UNAVAILABLE("UNAVAILABLE"),
    CREATING("CREATING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, KmsKeyState> VALUE_MAP;
    private final String value;

    private KmsKeyState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KmsKeyState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KmsKeyState> knownValues() {
        EnumSet<KmsKeyState> knownValues = EnumSet.allOf(KmsKeyState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(KmsKeyState.class, KmsKeyState::toString);
    }
}

