/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sfn.model.SfnResponse;
import software.amazon.awssdk.services.sfn.model.StateMachineListCopier;
import software.amazon.awssdk.services.sfn.model.StateMachineListItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStateMachinesResponse
extends SfnResponse
implements ToCopyableBuilder<Builder, ListStateMachinesResponse> {
    private static final SdkField<List<StateMachineListItem>> STATE_MACHINES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stateMachines").getter(ListStateMachinesResponse.getter(ListStateMachinesResponse::stateMachines)).setter(ListStateMachinesResponse.setter(Builder::stateMachines)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachines").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StateMachineListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListStateMachinesResponse.getter(ListStateMachinesResponse::nextToken)).setter(ListStateMachinesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_MACHINES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListStateMachinesResponse.memberNameToFieldInitializer();
    private final List<StateMachineListItem> stateMachines;
    private final String nextToken;

    private ListStateMachinesResponse(BuilderImpl builder) {
        super(builder);
        this.stateMachines = builder.stateMachines;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasStateMachines() {
        return this.stateMachines != null && !(this.stateMachines instanceof SdkAutoConstructList);
    }

    public final List<StateMachineListItem> stateMachines() {
        return this.stateMachines;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStateMachines() ? this.stateMachines() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStateMachinesResponse)) {
            return false;
        }
        ListStateMachinesResponse other = (ListStateMachinesResponse)((Object)obj);
        return this.hasStateMachines() == other.hasStateMachines() && Objects.equals(this.stateMachines(), other.stateMachines()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListStateMachinesResponse").add("StateMachines", this.hasStateMachines() ? this.stateMachines() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stateMachines": {
                return Optional.ofNullable(clazz.cast(this.stateMachines()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("stateMachines", STATE_MACHINES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListStateMachinesResponse, T> g) {
        return obj -> g.apply((ListStateMachinesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SfnResponse.BuilderImpl
    implements Builder {
        private List<StateMachineListItem> stateMachines = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStateMachinesResponse model) {
            super(model);
            this.stateMachines(model.stateMachines);
            this.nextToken(model.nextToken);
        }

        public final List<StateMachineListItem.Builder> getStateMachines() {
            List<StateMachineListItem.Builder> result = StateMachineListCopier.copyToBuilder(this.stateMachines);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStateMachines(Collection<StateMachineListItem.BuilderImpl> stateMachines) {
            this.stateMachines = StateMachineListCopier.copyFromBuilder(stateMachines);
        }

        @Override
        public final Builder stateMachines(Collection<StateMachineListItem> stateMachines) {
            this.stateMachines = StateMachineListCopier.copy(stateMachines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stateMachines(StateMachineListItem ... stateMachines) {
            this.stateMachines(Arrays.asList(stateMachines));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stateMachines(Consumer<StateMachineListItem.Builder> ... stateMachines) {
            this.stateMachines(Stream.of(stateMachines).map(c -> (StateMachineListItem)((StateMachineListItem.Builder)StateMachineListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListStateMachinesResponse build() {
            return new ListStateMachinesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SfnResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStateMachinesResponse> {
        public Builder stateMachines(Collection<StateMachineListItem> var1);

        public Builder stateMachines(StateMachineListItem ... var1);

        public Builder stateMachines(Consumer<StateMachineListItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

