/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sfn.model.MapRunListCopier;
import software.amazon.awssdk.services.sfn.model.MapRunListItem;
import software.amazon.awssdk.services.sfn.model.SfnResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMapRunsResponse
extends SfnResponse
implements ToCopyableBuilder<Builder, ListMapRunsResponse> {
    private static final SdkField<List<MapRunListItem>> MAP_RUNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("mapRuns").getter(ListMapRunsResponse.getter(ListMapRunsResponse::mapRuns)).setter(ListMapRunsResponse.setter(Builder::mapRuns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mapRuns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MapRunListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListMapRunsResponse.getter(ListMapRunsResponse::nextToken)).setter(ListMapRunsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAP_RUNS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("mapRuns", MAP_RUNS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<MapRunListItem> mapRuns;
    private final String nextToken;

    private ListMapRunsResponse(BuilderImpl builder) {
        super(builder);
        this.mapRuns = builder.mapRuns;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMapRuns() {
        return this.mapRuns != null && !(this.mapRuns instanceof SdkAutoConstructList);
    }

    public final List<MapRunListItem> mapRuns() {
        return this.mapRuns;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMapRuns() ? this.mapRuns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMapRunsResponse)) {
            return false;
        }
        ListMapRunsResponse other = (ListMapRunsResponse)((Object)obj);
        return this.hasMapRuns() == other.hasMapRuns() && Objects.equals(this.mapRuns(), other.mapRuns()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListMapRunsResponse").add("MapRuns", this.hasMapRuns() ? this.mapRuns() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "mapRuns": {
                return Optional.ofNullable(clazz.cast(this.mapRuns()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListMapRunsResponse, T> g) {
        return obj -> g.apply((ListMapRunsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SfnResponse.BuilderImpl
    implements Builder {
        private List<MapRunListItem> mapRuns = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMapRunsResponse model) {
            super(model);
            this.mapRuns(model.mapRuns);
            this.nextToken(model.nextToken);
        }

        public final List<MapRunListItem.Builder> getMapRuns() {
            List<MapRunListItem.Builder> result = MapRunListCopier.copyToBuilder(this.mapRuns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMapRuns(Collection<MapRunListItem.BuilderImpl> mapRuns) {
            this.mapRuns = MapRunListCopier.copyFromBuilder(mapRuns);
        }

        @Override
        public final Builder mapRuns(Collection<MapRunListItem> mapRuns) {
            this.mapRuns = MapRunListCopier.copy(mapRuns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapRuns(MapRunListItem ... mapRuns) {
            this.mapRuns(Arrays.asList(mapRuns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapRuns(Consumer<MapRunListItem.Builder> ... mapRuns) {
            this.mapRuns(Stream.of(mapRuns).map(c -> (MapRunListItem)((MapRunListItem.Builder)MapRunListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMapRunsResponse build() {
            return new ListMapRunsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SfnResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMapRunsResponse> {
        public Builder mapRuns(Collection<MapRunListItem> var1);

        public Builder mapRuns(MapRunListItem ... var1);

        public Builder mapRuns(Consumer<MapRunListItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

