/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestStateResponse extends SfnResponse implements
        ToCopyableBuilder<TestStateResponse.Builder, TestStateResponse> {
    private static final SdkField<String> OUTPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("output")
            .getter(getter(TestStateResponse::output)).setter(setter(Builder::output))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("output").build()).build();

    private static final SdkField<String> ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("error")
            .getter(getter(TestStateResponse::error)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<String> CAUSE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cause")
            .getter(getter(TestStateResponse::cause)).setter(setter(Builder::cause))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cause").build()).build();

    private static final SdkField<InspectionData> INSPECTION_DATA_FIELD = SdkField
            .<InspectionData> builder(MarshallingType.SDK_POJO).memberName("inspectionData")
            .getter(getter(TestStateResponse::inspectionData)).setter(setter(Builder::inspectionData))
            .constructor(InspectionData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inspectionData").build()).build();

    private static final SdkField<String> NEXT_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextState").getter(getter(TestStateResponse::nextState)).setter(setter(Builder::nextState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextState").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(TestStateResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_FIELD, ERROR_FIELD,
            CAUSE_FIELD, INSPECTION_DATA_FIELD, NEXT_STATE_FIELD, STATUS_FIELD));

    private final String output;

    private final String error;

    private final String causeValue;

    private final InspectionData inspectionData;

    private final String nextState;

    private final String status;

    private TestStateResponse(BuilderImpl builder) {
        super(builder);
        this.output = builder.output;
        this.error = builder.error;
        this.causeValue = builder.causeValue;
        this.inspectionData = builder.inspectionData;
        this.nextState = builder.nextState;
        this.status = builder.status;
    }

    /**
     * <p>
     * The JSON output data of the state. Length constraints apply to the payload size, and are expressed as bytes in
     * UTF-8 encoding.
     * </p>
     * 
     * @return The JSON output data of the state. Length constraints apply to the payload size, and are expressed as
     *         bytes in UTF-8 encoding.
     */
    public final String output() {
        return output;
    }

    /**
     * <p>
     * The error returned when the execution of a state fails.
     * </p>
     * 
     * @return The error returned when the execution of a state fails.
     */
    public final String error() {
        return error;
    }

    /**
     * <p>
     * A detailed explanation of the cause for the error when the execution of a state fails.
     * </p>
     * 
     * @return A detailed explanation of the cause for the error when the execution of a state fails.
     */
    public final String cause() {
        return causeValue;
    }

    /**
     * <p>
     * Returns additional details about the state's execution, including its input and output data processing flow, and
     * HTTP request and response information. The <code>inspectionLevel</code> request parameter specifies which details
     * are returned.
     * </p>
     * 
     * @return Returns additional details about the state's execution, including its input and output data processing
     *         flow, and HTTP request and response information. The <code>inspectionLevel</code> request parameter
     *         specifies which details are returned.
     */
    public final InspectionData inspectionData() {
        return inspectionData;
    }

    /**
     * <p>
     * The name of the next state to transition to. If you haven't defined a next state in your definition or if the
     * execution of the state fails, this ﬁeld doesn't contain a value.
     * </p>
     * 
     * @return The name of the next state to transition to. If you haven't defined a next state in your definition or if
     *         the execution of the state fails, this ﬁeld doesn't contain a value.
     */
    public final String nextState() {
        return nextState;
    }

    /**
     * <p>
     * The execution status of the state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TestExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The execution status of the state.
     * @see TestExecutionStatus
     */
    public final TestExecutionStatus status() {
        return TestExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The execution status of the state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TestExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The execution status of the state.
     * @see TestExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(output());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(cause());
        hashCode = 31 * hashCode + Objects.hashCode(inspectionData());
        hashCode = 31 * hashCode + Objects.hashCode(nextState());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestStateResponse)) {
            return false;
        }
        TestStateResponse other = (TestStateResponse) obj;
        return Objects.equals(output(), other.output()) && Objects.equals(error(), other.error())
                && Objects.equals(cause(), other.cause()) && Objects.equals(inspectionData(), other.inspectionData())
                && Objects.equals(nextState(), other.nextState()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestStateResponse").add("Output", output() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Error", error() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Cause", cause() == null ? null : "*** Sensitive Data Redacted ***")
                .add("InspectionData", inspectionData() == null ? null : "*** Sensitive Data Redacted ***")
                .add("NextState", nextState()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "output":
            return Optional.ofNullable(clazz.cast(output()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        case "cause":
            return Optional.ofNullable(clazz.cast(cause()));
        case "inspectionData":
            return Optional.ofNullable(clazz.cast(inspectionData()));
        case "nextState":
            return Optional.ofNullable(clazz.cast(nextState()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestStateResponse, T> g) {
        return obj -> g.apply((TestStateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SfnResponse.Builder, SdkPojo, CopyableBuilder<Builder, TestStateResponse> {
        /**
         * <p>
         * The JSON output data of the state. Length constraints apply to the payload size, and are expressed as bytes
         * in UTF-8 encoding.
         * </p>
         * 
         * @param output
         *        The JSON output data of the state. Length constraints apply to the payload size, and are expressed as
         *        bytes in UTF-8 encoding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(String output);

        /**
         * <p>
         * The error returned when the execution of a state fails.
         * </p>
         * 
         * @param error
         *        The error returned when the execution of a state fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(String error);

        /**
         * <p>
         * A detailed explanation of the cause for the error when the execution of a state fails.
         * </p>
         * 
         * @param causeValue
         *        A detailed explanation of the cause for the error when the execution of a state fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cause(String causeValue);

        /**
         * <p>
         * Returns additional details about the state's execution, including its input and output data processing flow,
         * and HTTP request and response information. The <code>inspectionLevel</code> request parameter specifies which
         * details are returned.
         * </p>
         * 
         * @param inspectionData
         *        Returns additional details about the state's execution, including its input and output data processing
         *        flow, and HTTP request and response information. The <code>inspectionLevel</code> request parameter
         *        specifies which details are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inspectionData(InspectionData inspectionData);

        /**
         * <p>
         * Returns additional details about the state's execution, including its input and output data processing flow,
         * and HTTP request and response information. The <code>inspectionLevel</code> request parameter specifies which
         * details are returned.
         * </p>
         * This is a convenience method that creates an instance of the {@link InspectionData.Builder} avoiding the need
         * to create one manually via {@link InspectionData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InspectionData.Builder#build()} is called immediately and its
         * result is passed to {@link #inspectionData(InspectionData)}.
         * 
         * @param inspectionData
         *        a consumer that will call methods on {@link InspectionData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inspectionData(InspectionData)
         */
        default Builder inspectionData(Consumer<InspectionData.Builder> inspectionData) {
            return inspectionData(InspectionData.builder().applyMutation(inspectionData).build());
        }

        /**
         * <p>
         * The name of the next state to transition to. If you haven't defined a next state in your definition or if the
         * execution of the state fails, this ﬁeld doesn't contain a value.
         * </p>
         * 
         * @param nextState
         *        The name of the next state to transition to. If you haven't defined a next state in your definition or
         *        if the execution of the state fails, this ﬁeld doesn't contain a value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextState(String nextState);

        /**
         * <p>
         * The execution status of the state.
         * </p>
         * 
         * @param status
         *        The execution status of the state.
         * @see TestExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The execution status of the state.
         * </p>
         * 
         * @param status
         *        The execution status of the state.
         * @see TestExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestExecutionStatus
         */
        Builder status(TestExecutionStatus status);
    }

    static final class BuilderImpl extends SfnResponse.BuilderImpl implements Builder {
        private String output;

        private String error;

        private String causeValue;

        private InspectionData inspectionData;

        private String nextState;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(TestStateResponse model) {
            super(model);
            output(model.output);
            error(model.error);
            cause(model.causeValue);
            inspectionData(model.inspectionData);
            nextState(model.nextState);
            status(model.status);
        }

        public final String getOutput() {
            return output;
        }

        public final void setOutput(String output) {
            this.output = output;
        }

        @Override
        public final Builder output(String output) {
            this.output = output;
            return this;
        }

        public final String getError() {
            return error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final String getCause() {
            return causeValue;
        }

        public final void setCause(String causeValue) {
            this.causeValue = causeValue;
        }

        @Override
        public final Builder cause(String causeValue) {
            this.causeValue = causeValue;
            return this;
        }

        public final InspectionData.Builder getInspectionData() {
            return inspectionData != null ? inspectionData.toBuilder() : null;
        }

        public final void setInspectionData(InspectionData.BuilderImpl inspectionData) {
            this.inspectionData = inspectionData != null ? inspectionData.build() : null;
        }

        @Override
        public final Builder inspectionData(InspectionData inspectionData) {
            this.inspectionData = inspectionData;
            return this;
        }

        public final String getNextState() {
            return nextState;
        }

        public final void setNextState(String nextState) {
            this.nextState = nextState;
        }

        @Override
        public final Builder nextState(String nextState) {
            this.nextState = nextState;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TestExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public TestStateResponse build() {
            return new TestStateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
