/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetActivityTaskResponse extends SfnResponse implements
        ToCopyableBuilder<GetActivityTaskResponse.Builder, GetActivityTaskResponse> {
    private static final SdkField<String> TASK_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskToken").getter(getter(GetActivityTaskResponse::taskToken)).setter(setter(Builder::taskToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskToken").build()).build();

    private static final SdkField<String> INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("input")
            .getter(getter(GetActivityTaskResponse::input)).setter(setter(Builder::input))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(TASK_TOKEN_FIELD, INPUT_FIELD));

    private final String taskToken;

    private final String input;

    private GetActivityTaskResponse(BuilderImpl builder) {
        super(builder);
        this.taskToken = builder.taskToken;
        this.input = builder.input;
    }

    /**
     * <p>
     * A token that identifies the scheduled task. This token must be copied and included in subsequent calls to
     * <a>SendTaskHeartbeat</a>, <a>SendTaskSuccess</a> or <a>SendTaskFailure</a> in order to report the progress or
     * completion of the task.
     * </p>
     * 
     * @return A token that identifies the scheduled task. This token must be copied and included in subsequent calls to
     *         <a>SendTaskHeartbeat</a>, <a>SendTaskSuccess</a> or <a>SendTaskFailure</a> in order to report the
     *         progress or completion of the task.
     */
    public final String taskToken() {
        return taskToken;
    }

    /**
     * <p>
     * The string that contains the JSON input data for the task. Length constraints apply to the payload size, and are
     * expressed as bytes in UTF-8 encoding.
     * </p>
     * 
     * @return The string that contains the JSON input data for the task. Length constraints apply to the payload size,
     *         and are expressed as bytes in UTF-8 encoding.
     */
    public final String input() {
        return input;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskToken());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetActivityTaskResponse)) {
            return false;
        }
        GetActivityTaskResponse other = (GetActivityTaskResponse) obj;
        return Objects.equals(taskToken(), other.taskToken()) && Objects.equals(input(), other.input());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetActivityTaskResponse").add("TaskToken", taskToken())
                .add("Input", input() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskToken":
            return Optional.ofNullable(clazz.cast(taskToken()));
        case "input":
            return Optional.ofNullable(clazz.cast(input()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetActivityTaskResponse, T> g) {
        return obj -> g.apply((GetActivityTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SfnResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetActivityTaskResponse> {
        /**
         * <p>
         * A token that identifies the scheduled task. This token must be copied and included in subsequent calls to
         * <a>SendTaskHeartbeat</a>, <a>SendTaskSuccess</a> or <a>SendTaskFailure</a> in order to report the progress or
         * completion of the task.
         * </p>
         * 
         * @param taskToken
         *        A token that identifies the scheduled task. This token must be copied and included in subsequent calls
         *        to <a>SendTaskHeartbeat</a>, <a>SendTaskSuccess</a> or <a>SendTaskFailure</a> in order to report the
         *        progress or completion of the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskToken(String taskToken);

        /**
         * <p>
         * The string that contains the JSON input data for the task. Length constraints apply to the payload size, and
         * are expressed as bytes in UTF-8 encoding.
         * </p>
         * 
         * @param input
         *        The string that contains the JSON input data for the task. Length constraints apply to the payload
         *        size, and are expressed as bytes in UTF-8 encoding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);
    }

    static final class BuilderImpl extends SfnResponse.BuilderImpl implements Builder {
        private String taskToken;

        private String input;

        private BuilderImpl() {
        }

        private BuilderImpl(GetActivityTaskResponse model) {
            super(model);
            taskToken(model.taskToken);
            input(model.input);
        }

        public final String getTaskToken() {
            return taskToken;
        }

        public final void setTaskToken(String taskToken) {
            this.taskToken = taskToken;
        }

        @Override
        public final Builder taskToken(String taskToken) {
            this.taskToken = taskToken;
            return this;
        }

        public final String getInput() {
            return input;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        @Override
        public GetActivityTaskResponse build() {
            return new GetActivityTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
