/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMapRunResponse extends SfnResponse implements
        ToCopyableBuilder<DescribeMapRunResponse.Builder, DescribeMapRunResponse> {
    private static final SdkField<String> MAP_RUN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mapRunArn").getter(getter(DescribeMapRunResponse::mapRunArn)).setter(setter(Builder::mapRunArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mapRunArn").build()).build();

    private static final SdkField<String> EXECUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionArn").getter(getter(DescribeMapRunResponse::executionArn))
            .setter(setter(Builder::executionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DescribeMapRunResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startDate").getter(getter(DescribeMapRunResponse::startDate)).setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDate").build()).build();

    private static final SdkField<Instant> STOP_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("stopDate").getter(getter(DescribeMapRunResponse::stopDate)).setter(setter(Builder::stopDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopDate").build()).build();

    private static final SdkField<Integer> MAX_CONCURRENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxConcurrency").getter(getter(DescribeMapRunResponse::maxConcurrency))
            .setter(setter(Builder::maxConcurrency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxConcurrency").build()).build();

    private static final SdkField<Float> TOLERATED_FAILURE_PERCENTAGE_FIELD = SdkField
            .<Float> builder(MarshallingType.FLOAT)
            .memberName("toleratedFailurePercentage")
            .getter(getter(DescribeMapRunResponse::toleratedFailurePercentage))
            .setter(setter(Builder::toleratedFailurePercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toleratedFailurePercentage").build())
            .build();

    private static final SdkField<Long> TOLERATED_FAILURE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("toleratedFailureCount").getter(getter(DescribeMapRunResponse::toleratedFailureCount))
            .setter(setter(Builder::toleratedFailureCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toleratedFailureCount").build())
            .build();

    private static final SdkField<MapRunItemCounts> ITEM_COUNTS_FIELD = SdkField
            .<MapRunItemCounts> builder(MarshallingType.SDK_POJO).memberName("itemCounts")
            .getter(getter(DescribeMapRunResponse::itemCounts)).setter(setter(Builder::itemCounts))
            .constructor(MapRunItemCounts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemCounts").build()).build();

    private static final SdkField<MapRunExecutionCounts> EXECUTION_COUNTS_FIELD = SdkField
            .<MapRunExecutionCounts> builder(MarshallingType.SDK_POJO).memberName("executionCounts")
            .getter(getter(DescribeMapRunResponse::executionCounts)).setter(setter(Builder::executionCounts))
            .constructor(MapRunExecutionCounts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionCounts").build()).build();

    private static final SdkField<Integer> REDRIVE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("redriveCount").getter(getter(DescribeMapRunResponse::redriveCount))
            .setter(setter(Builder::redriveCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redriveCount").build()).build();

    private static final SdkField<Instant> REDRIVE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("redriveDate").getter(getter(DescribeMapRunResponse::redriveDate)).setter(setter(Builder::redriveDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redriveDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAP_RUN_ARN_FIELD,
            EXECUTION_ARN_FIELD, STATUS_FIELD, START_DATE_FIELD, STOP_DATE_FIELD, MAX_CONCURRENCY_FIELD,
            TOLERATED_FAILURE_PERCENTAGE_FIELD, TOLERATED_FAILURE_COUNT_FIELD, ITEM_COUNTS_FIELD, EXECUTION_COUNTS_FIELD,
            REDRIVE_COUNT_FIELD, REDRIVE_DATE_FIELD));

    private final String mapRunArn;

    private final String executionArn;

    private final String status;

    private final Instant startDate;

    private final Instant stopDate;

    private final Integer maxConcurrency;

    private final Float toleratedFailurePercentage;

    private final Long toleratedFailureCount;

    private final MapRunItemCounts itemCounts;

    private final MapRunExecutionCounts executionCounts;

    private final Integer redriveCount;

    private final Instant redriveDate;

    private DescribeMapRunResponse(BuilderImpl builder) {
        super(builder);
        this.mapRunArn = builder.mapRunArn;
        this.executionArn = builder.executionArn;
        this.status = builder.status;
        this.startDate = builder.startDate;
        this.stopDate = builder.stopDate;
        this.maxConcurrency = builder.maxConcurrency;
        this.toleratedFailurePercentage = builder.toleratedFailurePercentage;
        this.toleratedFailureCount = builder.toleratedFailureCount;
        this.itemCounts = builder.itemCounts;
        this.executionCounts = builder.executionCounts;
        this.redriveCount = builder.redriveCount;
        this.redriveDate = builder.redriveDate;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies a Map Run.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies a Map Run.
     */
    public final String mapRunArn() {
        return mapRunArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies the execution in which the Map Run was started.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies the execution in which the Map Run was started.
     */
    public final String executionArn() {
        return executionArn;
    }

    /**
     * <p>
     * The current status of the Map Run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MapRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the Map Run.
     * @see MapRunStatus
     */
    public final MapRunStatus status() {
        return MapRunStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the Map Run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MapRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the Map Run.
     * @see MapRunStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date when the Map Run was started.
     * </p>
     * 
     * @return The date when the Map Run was started.
     */
    public final Instant startDate() {
        return startDate;
    }

    /**
     * <p>
     * The date when the Map Run was stopped.
     * </p>
     * 
     * @return The date when the Map Run was stopped.
     */
    public final Instant stopDate() {
        return stopDate;
    }

    /**
     * <p>
     * The maximum number of child workflow executions configured to run in parallel for the Map Run at the same time.
     * </p>
     * 
     * @return The maximum number of child workflow executions configured to run in parallel for the Map Run at the same
     *         time.
     */
    public final Integer maxConcurrency() {
        return maxConcurrency;
    }

    /**
     * <p>
     * The maximum percentage of failed child workflow executions before the Map Run fails.
     * </p>
     * 
     * @return The maximum percentage of failed child workflow executions before the Map Run fails.
     */
    public final Float toleratedFailurePercentage() {
        return toleratedFailurePercentage;
    }

    /**
     * <p>
     * The maximum number of failed child workflow executions before the Map Run fails.
     * </p>
     * 
     * @return The maximum number of failed child workflow executions before the Map Run fails.
     */
    public final Long toleratedFailureCount() {
        return toleratedFailureCount;
    }

    /**
     * <p>
     * A JSON object that contains information about the total number of items, and the item count for each processing
     * status, such as <code>pending</code> and <code>failed</code>.
     * </p>
     * 
     * @return A JSON object that contains information about the total number of items, and the item count for each
     *         processing status, such as <code>pending</code> and <code>failed</code>.
     */
    public final MapRunItemCounts itemCounts() {
        return itemCounts;
    }

    /**
     * <p>
     * A JSON object that contains information about the total number of child workflow executions for the Map Run, and
     * the count of child workflow executions for each status, such as <code>failed</code> and <code>succeeded</code>.
     * </p>
     * 
     * @return A JSON object that contains information about the total number of child workflow executions for the Map
     *         Run, and the count of child workflow executions for each status, such as <code>failed</code> and
     *         <code>succeeded</code>.
     */
    public final MapRunExecutionCounts executionCounts() {
        return executionCounts;
    }

    /**
     * <p>
     * The number of times you've redriven a Map Run. If you have not yet redriven a Map Run, the
     * <code>redriveCount</code> is 0. This count is not updated for redrives that failed to start or are pending to be
     * redriven.
     * </p>
     * 
     * @return The number of times you've redriven a Map Run. If you have not yet redriven a Map Run, the
     *         <code>redriveCount</code> is 0. This count is not updated for redrives that failed to start or are
     *         pending to be redriven.
     */
    public final Integer redriveCount() {
        return redriveCount;
    }

    /**
     * <p>
     * The date a Map Run was last redriven. If you have not yet redriven a Map Run, the <code>redriveDate</code> is
     * null.
     * </p>
     * 
     * @return The date a Map Run was last redriven. If you have not yet redriven a Map Run, the
     *         <code>redriveDate</code> is null.
     */
    public final Instant redriveDate() {
        return redriveDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mapRunArn());
        hashCode = 31 * hashCode + Objects.hashCode(executionArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(stopDate());
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(toleratedFailurePercentage());
        hashCode = 31 * hashCode + Objects.hashCode(toleratedFailureCount());
        hashCode = 31 * hashCode + Objects.hashCode(itemCounts());
        hashCode = 31 * hashCode + Objects.hashCode(executionCounts());
        hashCode = 31 * hashCode + Objects.hashCode(redriveCount());
        hashCode = 31 * hashCode + Objects.hashCode(redriveDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMapRunResponse)) {
            return false;
        }
        DescribeMapRunResponse other = (DescribeMapRunResponse) obj;
        return Objects.equals(mapRunArn(), other.mapRunArn()) && Objects.equals(executionArn(), other.executionArn())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(startDate(), other.startDate())
                && Objects.equals(stopDate(), other.stopDate()) && Objects.equals(maxConcurrency(), other.maxConcurrency())
                && Objects.equals(toleratedFailurePercentage(), other.toleratedFailurePercentage())
                && Objects.equals(toleratedFailureCount(), other.toleratedFailureCount())
                && Objects.equals(itemCounts(), other.itemCounts()) && Objects.equals(executionCounts(), other.executionCounts())
                && Objects.equals(redriveCount(), other.redriveCount()) && Objects.equals(redriveDate(), other.redriveDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeMapRunResponse").add("MapRunArn", mapRunArn()).add("ExecutionArn", executionArn())
                .add("Status", statusAsString()).add("StartDate", startDate()).add("StopDate", stopDate())
                .add("MaxConcurrency", maxConcurrency()).add("ToleratedFailurePercentage", toleratedFailurePercentage())
                .add("ToleratedFailureCount", toleratedFailureCount()).add("ItemCounts", itemCounts())
                .add("ExecutionCounts", executionCounts()).add("RedriveCount", redriveCount()).add("RedriveDate", redriveDate())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mapRunArn":
            return Optional.ofNullable(clazz.cast(mapRunArn()));
        case "executionArn":
            return Optional.ofNullable(clazz.cast(executionArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "startDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "stopDate":
            return Optional.ofNullable(clazz.cast(stopDate()));
        case "maxConcurrency":
            return Optional.ofNullable(clazz.cast(maxConcurrency()));
        case "toleratedFailurePercentage":
            return Optional.ofNullable(clazz.cast(toleratedFailurePercentage()));
        case "toleratedFailureCount":
            return Optional.ofNullable(clazz.cast(toleratedFailureCount()));
        case "itemCounts":
            return Optional.ofNullable(clazz.cast(itemCounts()));
        case "executionCounts":
            return Optional.ofNullable(clazz.cast(executionCounts()));
        case "redriveCount":
            return Optional.ofNullable(clazz.cast(redriveCount()));
        case "redriveDate":
            return Optional.ofNullable(clazz.cast(redriveDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMapRunResponse, T> g) {
        return obj -> g.apply((DescribeMapRunResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SfnResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeMapRunResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies a Map Run.
         * </p>
         * 
         * @param mapRunArn
         *        The Amazon Resource Name (ARN) that identifies a Map Run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapRunArn(String mapRunArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies the execution in which the Map Run was started.
         * </p>
         * 
         * @param executionArn
         *        The Amazon Resource Name (ARN) that identifies the execution in which the Map Run was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionArn(String executionArn);

        /**
         * <p>
         * The current status of the Map Run.
         * </p>
         * 
         * @param status
         *        The current status of the Map Run.
         * @see MapRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MapRunStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the Map Run.
         * </p>
         * 
         * @param status
         *        The current status of the Map Run.
         * @see MapRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MapRunStatus
         */
        Builder status(MapRunStatus status);

        /**
         * <p>
         * The date when the Map Run was started.
         * </p>
         * 
         * @param startDate
         *        The date when the Map Run was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(Instant startDate);

        /**
         * <p>
         * The date when the Map Run was stopped.
         * </p>
         * 
         * @param stopDate
         *        The date when the Map Run was stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopDate(Instant stopDate);

        /**
         * <p>
         * The maximum number of child workflow executions configured to run in parallel for the Map Run at the same
         * time.
         * </p>
         * 
         * @param maxConcurrency
         *        The maximum number of child workflow executions configured to run in parallel for the Map Run at the
         *        same time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrency(Integer maxConcurrency);

        /**
         * <p>
         * The maximum percentage of failed child workflow executions before the Map Run fails.
         * </p>
         * 
         * @param toleratedFailurePercentage
         *        The maximum percentage of failed child workflow executions before the Map Run fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toleratedFailurePercentage(Float toleratedFailurePercentage);

        /**
         * <p>
         * The maximum number of failed child workflow executions before the Map Run fails.
         * </p>
         * 
         * @param toleratedFailureCount
         *        The maximum number of failed child workflow executions before the Map Run fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toleratedFailureCount(Long toleratedFailureCount);

        /**
         * <p>
         * A JSON object that contains information about the total number of items, and the item count for each
         * processing status, such as <code>pending</code> and <code>failed</code>.
         * </p>
         * 
         * @param itemCounts
         *        A JSON object that contains information about the total number of items, and the item count for each
         *        processing status, such as <code>pending</code> and <code>failed</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemCounts(MapRunItemCounts itemCounts);

        /**
         * <p>
         * A JSON object that contains information about the total number of items, and the item count for each
         * processing status, such as <code>pending</code> and <code>failed</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link MapRunItemCounts.Builder} avoiding the
         * need to create one manually via {@link MapRunItemCounts#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MapRunItemCounts.Builder#build()} is called immediately and its
         * result is passed to {@link #itemCounts(MapRunItemCounts)}.
         * 
         * @param itemCounts
         *        a consumer that will call methods on {@link MapRunItemCounts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #itemCounts(MapRunItemCounts)
         */
        default Builder itemCounts(Consumer<MapRunItemCounts.Builder> itemCounts) {
            return itemCounts(MapRunItemCounts.builder().applyMutation(itemCounts).build());
        }

        /**
         * <p>
         * A JSON object that contains information about the total number of child workflow executions for the Map Run,
         * and the count of child workflow executions for each status, such as <code>failed</code> and
         * <code>succeeded</code>.
         * </p>
         * 
         * @param executionCounts
         *        A JSON object that contains information about the total number of child workflow executions for the
         *        Map Run, and the count of child workflow executions for each status, such as <code>failed</code> and
         *        <code>succeeded</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionCounts(MapRunExecutionCounts executionCounts);

        /**
         * <p>
         * A JSON object that contains information about the total number of child workflow executions for the Map Run,
         * and the count of child workflow executions for each status, such as <code>failed</code> and
         * <code>succeeded</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link MapRunExecutionCounts.Builder} avoiding
         * the need to create one manually via {@link MapRunExecutionCounts#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MapRunExecutionCounts.Builder#build()} is called immediately and
         * its result is passed to {@link #executionCounts(MapRunExecutionCounts)}.
         * 
         * @param executionCounts
         *        a consumer that will call methods on {@link MapRunExecutionCounts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionCounts(MapRunExecutionCounts)
         */
        default Builder executionCounts(Consumer<MapRunExecutionCounts.Builder> executionCounts) {
            return executionCounts(MapRunExecutionCounts.builder().applyMutation(executionCounts).build());
        }

        /**
         * <p>
         * The number of times you've redriven a Map Run. If you have not yet redriven a Map Run, the
         * <code>redriveCount</code> is 0. This count is not updated for redrives that failed to start or are pending to
         * be redriven.
         * </p>
         * 
         * @param redriveCount
         *        The number of times you've redriven a Map Run. If you have not yet redriven a Map Run, the
         *        <code>redriveCount</code> is 0. This count is not updated for redrives that failed to start or are
         *        pending to be redriven.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redriveCount(Integer redriveCount);

        /**
         * <p>
         * The date a Map Run was last redriven. If you have not yet redriven a Map Run, the <code>redriveDate</code> is
         * null.
         * </p>
         * 
         * @param redriveDate
         *        The date a Map Run was last redriven. If you have not yet redriven a Map Run, the
         *        <code>redriveDate</code> is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redriveDate(Instant redriveDate);
    }

    static final class BuilderImpl extends SfnResponse.BuilderImpl implements Builder {
        private String mapRunArn;

        private String executionArn;

        private String status;

        private Instant startDate;

        private Instant stopDate;

        private Integer maxConcurrency;

        private Float toleratedFailurePercentage;

        private Long toleratedFailureCount;

        private MapRunItemCounts itemCounts;

        private MapRunExecutionCounts executionCounts;

        private Integer redriveCount;

        private Instant redriveDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMapRunResponse model) {
            super(model);
            mapRunArn(model.mapRunArn);
            executionArn(model.executionArn);
            status(model.status);
            startDate(model.startDate);
            stopDate(model.stopDate);
            maxConcurrency(model.maxConcurrency);
            toleratedFailurePercentage(model.toleratedFailurePercentage);
            toleratedFailureCount(model.toleratedFailureCount);
            itemCounts(model.itemCounts);
            executionCounts(model.executionCounts);
            redriveCount(model.redriveCount);
            redriveDate(model.redriveDate);
        }

        public final String getMapRunArn() {
            return mapRunArn;
        }

        public final void setMapRunArn(String mapRunArn) {
            this.mapRunArn = mapRunArn;
        }

        @Override
        public final Builder mapRunArn(String mapRunArn) {
            this.mapRunArn = mapRunArn;
            return this;
        }

        public final String getExecutionArn() {
            return executionArn;
        }

        public final void setExecutionArn(String executionArn) {
            this.executionArn = executionArn;
        }

        @Override
        public final Builder executionArn(String executionArn) {
            this.executionArn = executionArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MapRunStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartDate() {
            return startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getStopDate() {
            return stopDate;
        }

        public final void setStopDate(Instant stopDate) {
            this.stopDate = stopDate;
        }

        @Override
        public final Builder stopDate(Instant stopDate) {
            this.stopDate = stopDate;
            return this;
        }

        public final Integer getMaxConcurrency() {
            return maxConcurrency;
        }

        public final void setMaxConcurrency(Integer maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(Integer maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final Float getToleratedFailurePercentage() {
            return toleratedFailurePercentage;
        }

        public final void setToleratedFailurePercentage(Float toleratedFailurePercentage) {
            this.toleratedFailurePercentage = toleratedFailurePercentage;
        }

        @Override
        public final Builder toleratedFailurePercentage(Float toleratedFailurePercentage) {
            this.toleratedFailurePercentage = toleratedFailurePercentage;
            return this;
        }

        public final Long getToleratedFailureCount() {
            return toleratedFailureCount;
        }

        public final void setToleratedFailureCount(Long toleratedFailureCount) {
            this.toleratedFailureCount = toleratedFailureCount;
        }

        @Override
        public final Builder toleratedFailureCount(Long toleratedFailureCount) {
            this.toleratedFailureCount = toleratedFailureCount;
            return this;
        }

        public final MapRunItemCounts.Builder getItemCounts() {
            return itemCounts != null ? itemCounts.toBuilder() : null;
        }

        public final void setItemCounts(MapRunItemCounts.BuilderImpl itemCounts) {
            this.itemCounts = itemCounts != null ? itemCounts.build() : null;
        }

        @Override
        public final Builder itemCounts(MapRunItemCounts itemCounts) {
            this.itemCounts = itemCounts;
            return this;
        }

        public final MapRunExecutionCounts.Builder getExecutionCounts() {
            return executionCounts != null ? executionCounts.toBuilder() : null;
        }

        public final void setExecutionCounts(MapRunExecutionCounts.BuilderImpl executionCounts) {
            this.executionCounts = executionCounts != null ? executionCounts.build() : null;
        }

        @Override
        public final Builder executionCounts(MapRunExecutionCounts executionCounts) {
            this.executionCounts = executionCounts;
            return this;
        }

        public final Integer getRedriveCount() {
            return redriveCount;
        }

        public final void setRedriveCount(Integer redriveCount) {
            this.redriveCount = redriveCount;
        }

        @Override
        public final Builder redriveCount(Integer redriveCount) {
            this.redriveCount = redriveCount;
            return this;
        }

        public final Instant getRedriveDate() {
            return redriveDate;
        }

        public final void setRedriveDate(Instant redriveDate) {
            this.redriveDate = redriveDate;
        }

        @Override
        public final Builder redriveDate(Instant redriveDate) {
            this.redriveDate = redriveDate;
            return this;
        }

        @Override
        public DescribeMapRunResponse build() {
            return new DescribeMapRunResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
