/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sfn.SfnClient;
import software.amazon.awssdk.services.sfn.model.ListMapRunsRequest;
import software.amazon.awssdk.services.sfn.model.ListMapRunsResponse;
import software.amazon.awssdk.services.sfn.model.MapRunListItem;

public class ListMapRunsIterable
implements SdkIterable<ListMapRunsResponse> {
    private final SfnClient client;
    private final ListMapRunsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMapRunsIterable(SfnClient client, ListMapRunsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListMapRunsResponseFetcher();
    }

    public Iterator<ListMapRunsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MapRunListItem> mapRuns() {
        Function<ListMapRunsResponse, Iterator> getIterator = response -> {
            if (response != null && response.mapRuns() != null) {
                return response.mapRuns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMapRunsResponseFetcher
    implements SyncPageFetcher<ListMapRunsResponse> {
        private ListMapRunsResponseFetcher() {
        }

        public boolean hasNextPage(ListMapRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMapRunsResponse nextPage(ListMapRunsResponse previousPage) {
            if (previousPage == null) {
                return ListMapRunsIterable.this.client.listMapRuns(ListMapRunsIterable.this.firstRequest);
            }
            return ListMapRunsIterable.this.client.listMapRuns((ListMapRunsRequest)((Object)ListMapRunsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

