/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sfn.DefaultSfnBaseClientBuilder;
import software.amazon.awssdk.services.sfn.DefaultSfnClient;
import software.amazon.awssdk.services.sfn.SfnClient;
import software.amazon.awssdk.services.sfn.SfnClientBuilder;
import software.amazon.awssdk.services.sfn.SfnServiceClientConfiguration;
import software.amazon.awssdk.services.sfn.endpoints.SfnEndpointProvider;

@SdkInternalApi
final class DefaultSfnClientBuilder
extends DefaultSfnBaseClientBuilder<SfnClientBuilder, SfnClient>
implements SfnClientBuilder {
    DefaultSfnClientBuilder() {
    }

    @Override
    public DefaultSfnClientBuilder endpointProvider(SfnEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SfnClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultSfnClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        SfnServiceClientConfiguration serviceClientConfiguration = SfnServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultSfnClient(serviceClientConfiguration, clientConfiguration);
    }
}

