/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartExecutionRequest extends SfnRequest implements
        ToCopyableBuilder<StartExecutionRequest.Builder, StartExecutionRequest> {
    private static final SdkField<String> STATE_MACHINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stateMachineArn").getter(getter(StartExecutionRequest::stateMachineArn))
            .setter(setter(Builder::stateMachineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(StartExecutionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("input")
            .getter(getter(StartExecutionRequest::input)).setter(setter(Builder::input))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final SdkField<String> TRACE_HEADER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("traceHeader").getter(getter(StartExecutionRequest::traceHeader)).setter(setter(Builder::traceHeader))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("traceHeader").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_MACHINE_ARN_FIELD,
            NAME_FIELD, INPUT_FIELD, TRACE_HEADER_FIELD));

    private final String stateMachineArn;

    private final String name;

    private final String input;

    private final String traceHeader;

    private StartExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.stateMachineArn = builder.stateMachineArn;
        this.name = builder.name;
        this.input = builder.input;
        this.traceHeader = builder.traceHeader;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the state machine to execute.
     * </p>
     * <p>
     * The <code>stateMachineArn</code> parameter accepts one of the following inputs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>An unqualified state machine ARN</b> – Refers to a state machine ARN that isn't qualified with a version or
     * alias ARN. The following is an example of an unqualified state machine ARN.
     * </p>
     * <p>
     * <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine&gt;</code>
     * </p>
     * <p>
     * Step Functions doesn't associate state machine executions that you start with an unqualified ARN with a version.
     * This is true even if that version uses the same revision that the execution used.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>A state machine version ARN</b> – Refers to a version ARN, which is a combination of state machine ARN and the
     * version number separated by a colon (:). The following is an example of the ARN for version 10.
     * </p>
     * <p>
     * <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine&gt;:10</code>
     * </p>
     * <p>
     * Step Functions doesn't associate executions that you start with a version ARN with any aliases that point to that
     * version.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>A state machine alias ARN</b> – Refers to an alias ARN, which is a combination of state machine ARN and the
     * alias name separated by a colon (:). The following is an example of the ARN for an alias named <code>PROD</code>.
     * </p>
     * <p>
     * <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine:PROD&gt;</code>
     * </p>
     * <p>
     * Step Functions associates executions that you start with an alias ARN with that alias and the state machine
     * version used for that execution.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Amazon Resource Name (ARN) of the state machine to execute.</p>
     *         <p>
     *         The <code>stateMachineArn</code> parameter accepts one of the following inputs:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>An unqualified state machine ARN</b> – Refers to a state machine ARN that isn't qualified with a
     *         version or alias ARN. The following is an example of an unqualified state machine ARN.
     *         </p>
     *         <p>
     *         <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine&gt;</code>
     *         </p>
     *         <p>
     *         Step Functions doesn't associate state machine executions that you start with an unqualified ARN with a
     *         version. This is true even if that version uses the same revision that the execution used.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>A state machine version ARN</b> – Refers to a version ARN, which is a combination of state machine ARN
     *         and the version number separated by a colon (:). The following is an example of the ARN for version 10.
     *         </p>
     *         <p>
     *         <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine&gt;:10</code>
     *         </p>
     *         <p>
     *         Step Functions doesn't associate executions that you start with a version ARN with any aliases that point
     *         to that version.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>A state machine alias ARN</b> – Refers to an alias ARN, which is a combination of state machine ARN
     *         and the alias name separated by a colon (:). The following is an example of the ARN for an alias named
     *         <code>PROD</code>.
     *         </p>
     *         <p>
     *         <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine:PROD&gt;</code>
     *         </p>
     *         <p>
     *         Step Functions associates executions that you start with an alias ARN with that alias and the state
     *         machine version used for that execution.
     *         </p>
     *         </li>
     */
    public final String stateMachineArn() {
        return stateMachineArn;
    }

    /**
     * <p>
     * Optional name of the execution. This name must be unique for your Amazon Web Services account, Region, and state
     * machine for 90 days. For more information, see <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions">
     * Limits Related to State Machine Executions</a> in the <i>Step Functions Developer Guide</i>.
     * </p>
     * <p>
     * A name must <i>not</i> contain:
     * </p>
     * <ul>
     * <li>
     * <p>
     * white space
     * </p>
     * </li>
     * <li>
     * <p>
     * brackets <code>&lt; &gt; { } [ ]</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * wildcard characters <code>? *</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)
     * </p>
     * </li>
     * </ul>
     * <p>
     * To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
     * </p>
     * 
     * @return Optional name of the execution. This name must be unique for your Amazon Web Services account, Region,
     *         and state machine for 90 days. For more information, see <a href=
     *         "https://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions"
     *         > Limits Related to State Machine Executions</a> in the <i>Step Functions Developer Guide</i>.</p>
     *         <p>
     *         A name must <i>not</i> contain:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         white space
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         brackets <code>&lt; &gt; { } [ ]</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         wildcard characters <code>? *</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The string that contains the JSON input data for the execution, for example:
     * </p>
     * <p>
     * <code>"input": "{\"first_name\" : \"test\"}"</code>
     * </p>
     * <note>
     * <p>
     * If you don't include any JSON input data, you still must include the two braces, for example:
     * <code>"input": "{}"</code>
     * </p>
     * </note>
     * <p>
     * Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.
     * </p>
     * 
     * @return The string that contains the JSON input data for the execution, for example:</p>
     *         <p>
     *         <code>"input": "{\"first_name\" : \"test\"}"</code>
     *         </p>
     *         <note>
     *         <p>
     *         If you don't include any JSON input data, you still must include the two braces, for example:
     *         <code>"input": "{}"</code>
     *         </p>
     *         </note>
     *         <p>
     *         Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.
     */
    public final String input() {
        return input;
    }

    /**
     * <p>
     * Passes the X-Ray trace header. The trace header can also be passed in the request payload.
     * </p>
     * 
     * @return Passes the X-Ray trace header. The trace header can also be passed in the request payload.
     */
    public final String traceHeader() {
        return traceHeader;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stateMachineArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(traceHeader());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartExecutionRequest)) {
            return false;
        }
        StartExecutionRequest other = (StartExecutionRequest) obj;
        return Objects.equals(stateMachineArn(), other.stateMachineArn()) && Objects.equals(name(), other.name())
                && Objects.equals(input(), other.input()) && Objects.equals(traceHeader(), other.traceHeader());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartExecutionRequest").add("StateMachineArn", stateMachineArn()).add("Name", name())
                .add("Input", input() == null ? null : "*** Sensitive Data Redacted ***").add("TraceHeader", traceHeader())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stateMachineArn":
            return Optional.ofNullable(clazz.cast(stateMachineArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "input":
            return Optional.ofNullable(clazz.cast(input()));
        case "traceHeader":
            return Optional.ofNullable(clazz.cast(traceHeader()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartExecutionRequest, T> g) {
        return obj -> g.apply((StartExecutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SfnRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartExecutionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the state machine to execute.
         * </p>
         * <p>
         * The <code>stateMachineArn</code> parameter accepts one of the following inputs:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>An unqualified state machine ARN</b> – Refers to a state machine ARN that isn't qualified with a version
         * or alias ARN. The following is an example of an unqualified state machine ARN.
         * </p>
         * <p>
         * <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine&gt;</code>
         * </p>
         * <p>
         * Step Functions doesn't associate state machine executions that you start with an unqualified ARN with a
         * version. This is true even if that version uses the same revision that the execution used.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>A state machine version ARN</b> – Refers to a version ARN, which is a combination of state machine ARN and
         * the version number separated by a colon (:). The following is an example of the ARN for version 10.
         * </p>
         * <p>
         * <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine&gt;:10</code>
         * </p>
         * <p>
         * Step Functions doesn't associate executions that you start with a version ARN with any aliases that point to
         * that version.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>A state machine alias ARN</b> – Refers to an alias ARN, which is a combination of state machine ARN and
         * the alias name separated by a colon (:). The following is an example of the ARN for an alias named
         * <code>PROD</code>.
         * </p>
         * <p>
         * <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine:PROD&gt;</code>
         * </p>
         * <p>
         * Step Functions associates executions that you start with an alias ARN with that alias and the state machine
         * version used for that execution.
         * </p>
         * </li>
         * </ul>
         * 
         * @param stateMachineArn
         *        The Amazon Resource Name (ARN) of the state machine to execute.</p>
         *        <p>
         *        The <code>stateMachineArn</code> parameter accepts one of the following inputs:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>An unqualified state machine ARN</b> – Refers to a state machine ARN that isn't qualified with a
         *        version or alias ARN. The following is an example of an unqualified state machine ARN.
         *        </p>
         *        <p>
         *        <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine&gt;</code>
         *        </p>
         *        <p>
         *        Step Functions doesn't associate state machine executions that you start with an unqualified ARN with
         *        a version. This is true even if that version uses the same revision that the execution used.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>A state machine version ARN</b> – Refers to a version ARN, which is a combination of state machine
         *        ARN and the version number separated by a colon (:). The following is an example of the ARN for
         *        version 10.
         *        </p>
         *        <p>
         *        <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine&gt;:10</code>
         *        </p>
         *        <p>
         *        Step Functions doesn't associate executions that you start with a version ARN with any aliases that
         *        point to that version.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>A state machine alias ARN</b> – Refers to an alias ARN, which is a combination of state machine ARN
         *        and the alias name separated by a colon (:). The following is an example of the ARN for an alias named
         *        <code>PROD</code>.
         *        </p>
         *        <p>
         *        <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine:PROD&gt;</code>
         *        </p>
         *        <p>
         *        Step Functions associates executions that you start with an alias ARN with that alias and the state
         *        machine version used for that execution.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMachineArn(String stateMachineArn);

        /**
         * <p>
         * Optional name of the execution. This name must be unique for your Amazon Web Services account, Region, and
         * state machine for 90 days. For more information, see <a href=
         * "https://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions">
         * Limits Related to State Machine Executions</a> in the <i>Step Functions Developer Guide</i>.
         * </p>
         * <p>
         * A name must <i>not</i> contain:
         * </p>
         * <ul>
         * <li>
         * <p>
         * white space
         * </p>
         * </li>
         * <li>
         * <p>
         * brackets <code>&lt; &gt; { } [ ]</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * wildcard characters <code>? *</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)
         * </p>
         * </li>
         * </ul>
         * <p>
         * To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
         * </p>
         * 
         * @param name
         *        Optional name of the execution. This name must be unique for your Amazon Web Services account, Region,
         *        and state machine for 90 days. For more information, see <a href=
         *        "https://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions"
         *        > Limits Related to State Machine Executions</a> in the <i>Step Functions Developer Guide</i>.</p>
         *        <p>
         *        A name must <i>not</i> contain:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        white space
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        brackets <code>&lt; &gt; { } [ ]</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        wildcard characters <code>? *</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The string that contains the JSON input data for the execution, for example:
         * </p>
         * <p>
         * <code>"input": "{\"first_name\" : \"test\"}"</code>
         * </p>
         * <note>
         * <p>
         * If you don't include any JSON input data, you still must include the two braces, for example:
         * <code>"input": "{}"</code>
         * </p>
         * </note>
         * <p>
         * Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.
         * </p>
         * 
         * @param input
         *        The string that contains the JSON input data for the execution, for example:</p>
         *        <p>
         *        <code>"input": "{\"first_name\" : \"test\"}"</code>
         *        </p>
         *        <note>
         *        <p>
         *        If you don't include any JSON input data, you still must include the two braces, for example:
         *        <code>"input": "{}"</code>
         *        </p>
         *        </note>
         *        <p>
         *        Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        /**
         * <p>
         * Passes the X-Ray trace header. The trace header can also be passed in the request payload.
         * </p>
         * 
         * @param traceHeader
         *        Passes the X-Ray trace header. The trace header can also be passed in the request payload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceHeader(String traceHeader);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SfnRequest.BuilderImpl implements Builder {
        private String stateMachineArn;

        private String name;

        private String input;

        private String traceHeader;

        private BuilderImpl() {
        }

        private BuilderImpl(StartExecutionRequest model) {
            super(model);
            stateMachineArn(model.stateMachineArn);
            name(model.name);
            input(model.input);
            traceHeader(model.traceHeader);
        }

        public final String getStateMachineArn() {
            return stateMachineArn;
        }

        public final void setStateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
        }

        @Override
        public final Builder stateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getInput() {
            return input;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final String getTraceHeader() {
            return traceHeader;
        }

        public final void setTraceHeader(String traceHeader) {
            this.traceHeader = traceHeader;
        }

        @Override
        public final Builder traceHeader(String traceHeader) {
            this.traceHeader = traceHeader;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartExecutionRequest build() {
            return new StartExecutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
