/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sfn.SfnAsyncClient;
import software.amazon.awssdk.services.sfn.model.ListStateMachinesRequest;
import software.amazon.awssdk.services.sfn.model.ListStateMachinesResponse;
import software.amazon.awssdk.services.sfn.model.StateMachineListItem;

public class ListStateMachinesPublisher
implements SdkPublisher<ListStateMachinesResponse> {
    private final SfnAsyncClient client;
    private final ListStateMachinesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStateMachinesPublisher(SfnAsyncClient client, ListStateMachinesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStateMachinesPublisher(SfnAsyncClient client, ListStateMachinesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStateMachinesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStateMachinesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StateMachineListItem> stateMachines() {
        Function<ListStateMachinesResponse, Iterator> getIterator = response -> {
            if (response != null && response.stateMachines() != null) {
                return response.stateMachines().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListStateMachinesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListStateMachinesResponseFetcher
    implements AsyncPageFetcher<ListStateMachinesResponse> {
        private ListStateMachinesResponseFetcher() {
        }

        public boolean hasNextPage(ListStateMachinesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStateMachinesResponse> nextPage(ListStateMachinesResponse previousPage) {
            if (previousPage == null) {
                return ListStateMachinesPublisher.this.client.listStateMachines(ListStateMachinesPublisher.this.firstRequest);
            }
            return ListStateMachinesPublisher.this.client.listStateMachines((ListStateMachinesRequest)((Object)ListStateMachinesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

