/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sfn.SfnAsyncClient;
import software.amazon.awssdk.services.sfn.model.GetExecutionHistoryRequest;
import software.amazon.awssdk.services.sfn.model.GetExecutionHistoryResponse;
import software.amazon.awssdk.services.sfn.model.HistoryEvent;

public class GetExecutionHistoryPublisher
implements SdkPublisher<GetExecutionHistoryResponse> {
    private final SfnAsyncClient client;
    private final GetExecutionHistoryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetExecutionHistoryPublisher(SfnAsyncClient client, GetExecutionHistoryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetExecutionHistoryPublisher(SfnAsyncClient client, GetExecutionHistoryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetExecutionHistoryResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetExecutionHistoryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<HistoryEvent> events() {
        Function<GetExecutionHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetExecutionHistoryResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetExecutionHistoryResponseFetcher
    implements AsyncPageFetcher<GetExecutionHistoryResponse> {
        private GetExecutionHistoryResponseFetcher() {
        }

        public boolean hasNextPage(GetExecutionHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetExecutionHistoryResponse> nextPage(GetExecutionHistoryResponse previousPage) {
            if (previousPage == null) {
                return GetExecutionHistoryPublisher.this.client.getExecutionHistory(GetExecutionHistoryPublisher.this.firstRequest);
            }
            return GetExecutionHistoryPublisher.this.client.getExecutionHistory((GetExecutionHistoryRequest)((Object)GetExecutionHistoryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

