/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sfn.model.HistoryEventExecutionDataDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecutionStartedEventDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExecutionStartedEventDetails> {
    private static final SdkField<String> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("input").getter(ExecutionStartedEventDetails.getter(ExecutionStartedEventDetails::input)).setter(ExecutionStartedEventDetails.setter(Builder::input)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()}).build();
    private static final SdkField<HistoryEventExecutionDataDetails> INPUT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inputDetails").getter(ExecutionStartedEventDetails.getter(ExecutionStartedEventDetails::inputDetails)).setter(ExecutionStartedEventDetails.setter(Builder::inputDetails)).constructor(HistoryEventExecutionDataDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDetails").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(ExecutionStartedEventDetails.getter(ExecutionStartedEventDetails::roleArn)).setter(ExecutionStartedEventDetails.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FIELD, INPUT_DETAILS_FIELD, ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String input;
    private final HistoryEventExecutionDataDetails inputDetails;
    private final String roleArn;

    private ExecutionStartedEventDetails(BuilderImpl builder) {
        this.input = builder.input;
        this.inputDetails = builder.inputDetails;
        this.roleArn = builder.roleArn;
    }

    public String input() {
        return this.input;
    }

    public HistoryEventExecutionDataDetails inputDetails() {
        return this.inputDetails;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionStartedEventDetails)) {
            return false;
        }
        ExecutionStartedEventDetails other = (ExecutionStartedEventDetails)obj;
        return Objects.equals(this.input(), other.input()) && Objects.equals(this.inputDetails(), other.inputDetails()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public String toString() {
        return ToString.builder((String)"ExecutionStartedEventDetails").add("Input", (Object)(this.input() == null ? null : "*** Sensitive Data Redacted ***")).add("InputDetails", (Object)this.inputDetails()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "inputDetails": {
                return Optional.ofNullable(clazz.cast(this.inputDetails()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecutionStartedEventDetails, T> g) {
        return obj -> g.apply((ExecutionStartedEventDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String input;
        private HistoryEventExecutionDataDetails inputDetails;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionStartedEventDetails model) {
            this.input(model.input);
            this.inputDetails(model.inputDetails);
            this.roleArn(model.roleArn);
        }

        public final String getInput() {
            return this.input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        public final HistoryEventExecutionDataDetails.Builder getInputDetails() {
            return this.inputDetails != null ? this.inputDetails.toBuilder() : null;
        }

        @Override
        public final Builder inputDetails(HistoryEventExecutionDataDetails inputDetails) {
            this.inputDetails = inputDetails;
            return this;
        }

        public final void setInputDetails(HistoryEventExecutionDataDetails.BuilderImpl inputDetails) {
            this.inputDetails = inputDetails != null ? inputDetails.build() : null;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public ExecutionStartedEventDetails build() {
            return new ExecutionStartedEventDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExecutionStartedEventDetails> {
        public Builder input(String var1);

        public Builder inputDetails(HistoryEventExecutionDataDetails var1);

        default public Builder inputDetails(Consumer<HistoryEventExecutionDataDetails.Builder> inputDetails) {
            return this.inputDetails((HistoryEventExecutionDataDetails)((HistoryEventExecutionDataDetails.Builder)HistoryEventExecutionDataDetails.builder().applyMutation(inputDetails)).build());
        }

        public Builder roleArn(String var1);
    }
}

