/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateStateMachineRequest extends SfnRequest implements
        ToCopyableBuilder<UpdateStateMachineRequest.Builder, UpdateStateMachineRequest> {
    private static final SdkField<String> STATE_MACHINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateStateMachineRequest::stateMachineArn)).setter(setter(Builder::stateMachineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineArn").build()).build();

    private static final SdkField<String> DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateStateMachineRequest::definition)).setter(setter(Builder::definition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateStateMachineRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<LoggingConfiguration> LOGGING_CONFIGURATION_FIELD = SdkField
            .<LoggingConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateStateMachineRequest::loggingConfiguration)).setter(setter(Builder::loggingConfiguration))
            .constructor(LoggingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_MACHINE_ARN_FIELD,
            DEFINITION_FIELD, ROLE_ARN_FIELD, LOGGING_CONFIGURATION_FIELD));

    private final String stateMachineArn;

    private final String definition;

    private final String roleArn;

    private final LoggingConfiguration loggingConfiguration;

    private UpdateStateMachineRequest(BuilderImpl builder) {
        super(builder);
        this.stateMachineArn = builder.stateMachineArn;
        this.definition = builder.definition;
        this.roleArn = builder.roleArn;
        this.loggingConfiguration = builder.loggingConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the state machine.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the state machine.
     */
    public String stateMachineArn() {
        return stateMachineArn;
    }

    /**
     * <p>
     * The Amazon States Language definition of the state machine. See <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States
     * Language</a>.
     * </p>
     * 
     * @return The Amazon States Language definition of the state machine. See <a
     *         href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon
     *         States Language</a>.
     */
    public String definition() {
        return definition;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role of the state machine.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role of the state machine.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The <code>LoggingConfiguration</code> data type is used to set CloudWatch Logs options.
     * </p>
     * 
     * @return The <code>LoggingConfiguration</code> data type is used to set CloudWatch Logs options.
     */
    public LoggingConfiguration loggingConfiguration() {
        return loggingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stateMachineArn());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(loggingConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStateMachineRequest)) {
            return false;
        }
        UpdateStateMachineRequest other = (UpdateStateMachineRequest) obj;
        return Objects.equals(stateMachineArn(), other.stateMachineArn()) && Objects.equals(definition(), other.definition())
                && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(loggingConfiguration(), other.loggingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateStateMachineRequest").add("StateMachineArn", stateMachineArn())
                .add("Definition", definition() == null ? null : "*** Sensitive Data Redacted ***").add("RoleArn", roleArn())
                .add("LoggingConfiguration", loggingConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stateMachineArn":
            return Optional.ofNullable(clazz.cast(stateMachineArn()));
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "loggingConfiguration":
            return Optional.ofNullable(clazz.cast(loggingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStateMachineRequest, T> g) {
        return obj -> g.apply((UpdateStateMachineRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SfnRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateStateMachineRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the state machine.
         * </p>
         * 
         * @param stateMachineArn
         *        The Amazon Resource Name (ARN) of the state machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMachineArn(String stateMachineArn);

        /**
         * <p>
         * The Amazon States Language definition of the state machine. See <a
         * href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon
         * States Language</a>.
         * </p>
         * 
         * @param definition
         *        The Amazon States Language definition of the state machine. See <a
         *        href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html"
         *        >Amazon States Language</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(String definition);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role of the state machine.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role of the state machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The <code>LoggingConfiguration</code> data type is used to set CloudWatch Logs options.
         * </p>
         * 
         * @param loggingConfiguration
         *        The <code>LoggingConfiguration</code> data type is used to set CloudWatch Logs options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingConfiguration(LoggingConfiguration loggingConfiguration);

        /**
         * <p>
         * The <code>LoggingConfiguration</code> data type is used to set CloudWatch Logs options.
         * </p>
         * This is a convenience that creates an instance of the {@link LoggingConfiguration.Builder} avoiding the need
         * to create one manually via {@link LoggingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoggingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #loggingConfiguration(LoggingConfiguration)}.
         * 
         * @param loggingConfiguration
         *        a consumer that will call methods on {@link LoggingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingConfiguration(LoggingConfiguration)
         */
        default Builder loggingConfiguration(Consumer<LoggingConfiguration.Builder> loggingConfiguration) {
            return loggingConfiguration(LoggingConfiguration.builder().applyMutation(loggingConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SfnRequest.BuilderImpl implements Builder {
        private String stateMachineArn;

        private String definition;

        private String roleArn;

        private LoggingConfiguration loggingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStateMachineRequest model) {
            super(model);
            stateMachineArn(model.stateMachineArn);
            definition(model.definition);
            roleArn(model.roleArn);
            loggingConfiguration(model.loggingConfiguration);
        }

        public final String getStateMachineArn() {
            return stateMachineArn;
        }

        @Override
        public final Builder stateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
            return this;
        }

        public final void setStateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
        }

        public final String getDefinition() {
            return definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final LoggingConfiguration.Builder getLoggingConfiguration() {
            return loggingConfiguration != null ? loggingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder loggingConfiguration(LoggingConfiguration loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        public final void setLoggingConfiguration(LoggingConfiguration.BuilderImpl loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration != null ? loggingConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStateMachineRequest build() {
            return new UpdateStateMachineRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
