/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sesv2.SesV2AsyncClient;
import software.amazon.awssdk.services.sesv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.sesv2.model.ListResourceTenantsRequest;
import software.amazon.awssdk.services.sesv2.model.ListResourceTenantsResponse;
import software.amazon.awssdk.services.sesv2.model.ResourceTenantMetadata;

public class ListResourceTenantsPublisher
implements SdkPublisher<ListResourceTenantsResponse> {
    private final SesV2AsyncClient client;
    private final ListResourceTenantsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResourceTenantsPublisher(SesV2AsyncClient client, ListResourceTenantsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResourceTenantsPublisher(SesV2AsyncClient client, ListResourceTenantsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResourceTenantsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResourceTenantsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResourceTenantMetadata> resourceTenants() {
        Function<ListResourceTenantsResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceTenants() != null) {
                return response.resourceTenants().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListResourceTenantsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListResourceTenantsResponseFetcher
    implements AsyncPageFetcher<ListResourceTenantsResponse> {
        private ListResourceTenantsResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceTenantsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResourceTenantsResponse> nextPage(ListResourceTenantsResponse previousPage) {
            if (previousPage == null) {
                return ListResourceTenantsPublisher.this.client.listResourceTenants(ListResourceTenantsPublisher.this.firstRequest);
            }
            return ListResourceTenantsPublisher.this.client.listResourceTenants((ListResourceTenantsRequest)((Object)ListResourceTenantsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

