/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains information about a reputation entity, including its reference, type, policy, status records,
 * and reputation impact.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReputationEntity implements SdkPojo, Serializable,
        ToCopyableBuilder<ReputationEntity.Builder, ReputationEntity> {
    private static final SdkField<String> REPUTATION_ENTITY_REFERENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReputationEntityReference").getter(getter(ReputationEntity::reputationEntityReference))
            .setter(setter(Builder::reputationEntityReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReputationEntityReference").build())
            .build();

    private static final SdkField<String> REPUTATION_ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReputationEntityType").getter(getter(ReputationEntity::reputationEntityTypeAsString))
            .setter(setter(Builder::reputationEntityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReputationEntityType").build())
            .build();

    private static final SdkField<String> REPUTATION_MANAGEMENT_POLICY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReputationManagementPolicy")
            .getter(getter(ReputationEntity::reputationManagementPolicy))
            .setter(setter(Builder::reputationManagementPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReputationManagementPolicy").build())
            .build();

    private static final SdkField<StatusRecord> CUSTOMER_MANAGED_STATUS_FIELD = SdkField
            .<StatusRecord> builder(MarshallingType.SDK_POJO).memberName("CustomerManagedStatus")
            .getter(getter(ReputationEntity::customerManagedStatus)).setter(setter(Builder::customerManagedStatus))
            .constructor(StatusRecord::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerManagedStatus").build())
            .build();

    private static final SdkField<StatusRecord> AWS_SES_MANAGED_STATUS_FIELD = SdkField
            .<StatusRecord> builder(MarshallingType.SDK_POJO).memberName("AwsSesManagedStatus")
            .getter(getter(ReputationEntity::awsSesManagedStatus)).setter(setter(Builder::awsSesManagedStatus))
            .constructor(StatusRecord::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsSesManagedStatus").build())
            .build();

    private static final SdkField<String> SENDING_STATUS_AGGREGATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SendingStatusAggregate").getter(getter(ReputationEntity::sendingStatusAggregateAsString))
            .setter(setter(Builder::sendingStatusAggregate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendingStatusAggregate").build())
            .build();

    private static final SdkField<String> REPUTATION_IMPACT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReputationImpact").getter(getter(ReputationEntity::reputationImpactAsString))
            .setter(setter(Builder::reputationImpact))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReputationImpact").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(REPUTATION_ENTITY_REFERENCE_FIELD, REPUTATION_ENTITY_TYPE_FIELD,
                    REPUTATION_MANAGEMENT_POLICY_FIELD, CUSTOMER_MANAGED_STATUS_FIELD, AWS_SES_MANAGED_STATUS_FIELD,
                    SENDING_STATUS_AGGREGATE_FIELD, REPUTATION_IMPACT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String reputationEntityReference;

    private final String reputationEntityType;

    private final String reputationManagementPolicy;

    private final StatusRecord customerManagedStatus;

    private final StatusRecord awsSesManagedStatus;

    private final String sendingStatusAggregate;

    private final String reputationImpact;

    private ReputationEntity(BuilderImpl builder) {
        this.reputationEntityReference = builder.reputationEntityReference;
        this.reputationEntityType = builder.reputationEntityType;
        this.reputationManagementPolicy = builder.reputationManagementPolicy;
        this.customerManagedStatus = builder.customerManagedStatus;
        this.awsSesManagedStatus = builder.awsSesManagedStatus;
        this.sendingStatusAggregate = builder.sendingStatusAggregate;
        this.reputationImpact = builder.reputationImpact;
    }

    /**
     * <p>
     * The unique identifier for the reputation entity. For resource-type entities, this is the Amazon Resource Name
     * (ARN) of the resource.
     * </p>
     * 
     * @return The unique identifier for the reputation entity. For resource-type entities, this is the Amazon Resource
     *         Name (ARN) of the resource.
     */
    public final String reputationEntityReference() {
        return reputationEntityReference;
    }

    /**
     * <p>
     * The type of reputation entity. Currently, only <code>RESOURCE</code> type entities are supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #reputationEntityType} will return {@link ReputationEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #reputationEntityTypeAsString}.
     * </p>
     * 
     * @return The type of reputation entity. Currently, only <code>RESOURCE</code> type entities are supported.
     * @see ReputationEntityType
     */
    public final ReputationEntityType reputationEntityType() {
        return ReputationEntityType.fromValue(reputationEntityType);
    }

    /**
     * <p>
     * The type of reputation entity. Currently, only <code>RESOURCE</code> type entities are supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #reputationEntityType} will return {@link ReputationEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #reputationEntityTypeAsString}.
     * </p>
     * 
     * @return The type of reputation entity. Currently, only <code>RESOURCE</code> type entities are supported.
     * @see ReputationEntityType
     */
    public final String reputationEntityTypeAsString() {
        return reputationEntityType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the reputation management policy applied to this entity. This is an Amazon Web
     * Services Amazon SES-managed policy.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the reputation management policy applied to this entity. This is an
     *         Amazon Web Services Amazon SES-managed policy.
     */
    public final String reputationManagementPolicy() {
        return reputationManagementPolicy;
    }

    /**
     * <p>
     * The customer-managed status record for this reputation entity, including the current status, cause description,
     * and last updated timestamp.
     * </p>
     * 
     * @return The customer-managed status record for this reputation entity, including the current status, cause
     *         description, and last updated timestamp.
     */
    public final StatusRecord customerManagedStatus() {
        return customerManagedStatus;
    }

    /**
     * <p>
     * The Amazon Web Services Amazon SES-managed status record for this reputation entity, including the current
     * status, cause description, and last updated timestamp.
     * </p>
     * 
     * @return The Amazon Web Services Amazon SES-managed status record for this reputation entity, including the
     *         current status, cause description, and last updated timestamp.
     */
    public final StatusRecord awsSesManagedStatus() {
        return awsSesManagedStatus;
    }

    /**
     * <p>
     * The aggregate sending status that determines whether the entity is allowed to send emails. This status is derived
     * from both the customer-managed and Amazon Web Services Amazon SES-managed statuses. If either the
     * customer-managed status or the Amazon Web Services Amazon SES-managed status is <code>DISABLED</code>, the
     * aggregate status will be <code>DISABLED</code> and the entity will not be allowed to send emails. When the
     * customer-managed status is set to <code>REINSTATED</code>, the entity can continue sending even if there are
     * active reputation findings, provided the Amazon Web Services Amazon SES-managed status also permits sending. The
     * entity can only send emails when both statuses permit sending.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sendingStatusAggregate} will return {@link SendingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #sendingStatusAggregateAsString}.
     * </p>
     * 
     * @return The aggregate sending status that determines whether the entity is allowed to send emails. This status is
     *         derived from both the customer-managed and Amazon Web Services Amazon SES-managed statuses. If either the
     *         customer-managed status or the Amazon Web Services Amazon SES-managed status is <code>DISABLED</code>,
     *         the aggregate status will be <code>DISABLED</code> and the entity will not be allowed to send emails.
     *         When the customer-managed status is set to <code>REINSTATED</code>, the entity can continue sending even
     *         if there are active reputation findings, provided the Amazon Web Services Amazon SES-managed status also
     *         permits sending. The entity can only send emails when both statuses permit sending.
     * @see SendingStatus
     */
    public final SendingStatus sendingStatusAggregate() {
        return SendingStatus.fromValue(sendingStatusAggregate);
    }

    /**
     * <p>
     * The aggregate sending status that determines whether the entity is allowed to send emails. This status is derived
     * from both the customer-managed and Amazon Web Services Amazon SES-managed statuses. If either the
     * customer-managed status or the Amazon Web Services Amazon SES-managed status is <code>DISABLED</code>, the
     * aggregate status will be <code>DISABLED</code> and the entity will not be allowed to send emails. When the
     * customer-managed status is set to <code>REINSTATED</code>, the entity can continue sending even if there are
     * active reputation findings, provided the Amazon Web Services Amazon SES-managed status also permits sending. The
     * entity can only send emails when both statuses permit sending.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sendingStatusAggregate} will return {@link SendingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #sendingStatusAggregateAsString}.
     * </p>
     * 
     * @return The aggregate sending status that determines whether the entity is allowed to send emails. This status is
     *         derived from both the customer-managed and Amazon Web Services Amazon SES-managed statuses. If either the
     *         customer-managed status or the Amazon Web Services Amazon SES-managed status is <code>DISABLED</code>,
     *         the aggregate status will be <code>DISABLED</code> and the entity will not be allowed to send emails.
     *         When the customer-managed status is set to <code>REINSTATED</code>, the entity can continue sending even
     *         if there are active reputation findings, provided the Amazon Web Services Amazon SES-managed status also
     *         permits sending. The entity can only send emails when both statuses permit sending.
     * @see SendingStatus
     */
    public final String sendingStatusAggregateAsString() {
        return sendingStatusAggregate;
    }

    /**
     * <p>
     * The reputation impact level for this entity, representing the highest impact reputation finding currently active.
     * Reputation findings can be retrieved using the <code>ListRecommendations</code> operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reputationImpact}
     * will return {@link RecommendationImpact#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reputationImpactAsString}.
     * </p>
     * 
     * @return The reputation impact level for this entity, representing the highest impact reputation finding currently
     *         active. Reputation findings can be retrieved using the <code>ListRecommendations</code> operation.
     * @see RecommendationImpact
     */
    public final RecommendationImpact reputationImpact() {
        return RecommendationImpact.fromValue(reputationImpact);
    }

    /**
     * <p>
     * The reputation impact level for this entity, representing the highest impact reputation finding currently active.
     * Reputation findings can be retrieved using the <code>ListRecommendations</code> operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reputationImpact}
     * will return {@link RecommendationImpact#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reputationImpactAsString}.
     * </p>
     * 
     * @return The reputation impact level for this entity, representing the highest impact reputation finding currently
     *         active. Reputation findings can be retrieved using the <code>ListRecommendations</code> operation.
     * @see RecommendationImpact
     */
    public final String reputationImpactAsString() {
        return reputationImpact;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reputationEntityReference());
        hashCode = 31 * hashCode + Objects.hashCode(reputationEntityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reputationManagementPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(customerManagedStatus());
        hashCode = 31 * hashCode + Objects.hashCode(awsSesManagedStatus());
        hashCode = 31 * hashCode + Objects.hashCode(sendingStatusAggregateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reputationImpactAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReputationEntity)) {
            return false;
        }
        ReputationEntity other = (ReputationEntity) obj;
        return Objects.equals(reputationEntityReference(), other.reputationEntityReference())
                && Objects.equals(reputationEntityTypeAsString(), other.reputationEntityTypeAsString())
                && Objects.equals(reputationManagementPolicy(), other.reputationManagementPolicy())
                && Objects.equals(customerManagedStatus(), other.customerManagedStatus())
                && Objects.equals(awsSesManagedStatus(), other.awsSesManagedStatus())
                && Objects.equals(sendingStatusAggregateAsString(), other.sendingStatusAggregateAsString())
                && Objects.equals(reputationImpactAsString(), other.reputationImpactAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReputationEntity").add("ReputationEntityReference", reputationEntityReference())
                .add("ReputationEntityType", reputationEntityTypeAsString())
                .add("ReputationManagementPolicy", reputationManagementPolicy())
                .add("CustomerManagedStatus", customerManagedStatus()).add("AwsSesManagedStatus", awsSesManagedStatus())
                .add("SendingStatusAggregate", sendingStatusAggregateAsString())
                .add("ReputationImpact", reputationImpactAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReputationEntityReference":
            return Optional.ofNullable(clazz.cast(reputationEntityReference()));
        case "ReputationEntityType":
            return Optional.ofNullable(clazz.cast(reputationEntityTypeAsString()));
        case "ReputationManagementPolicy":
            return Optional.ofNullable(clazz.cast(reputationManagementPolicy()));
        case "CustomerManagedStatus":
            return Optional.ofNullable(clazz.cast(customerManagedStatus()));
        case "AwsSesManagedStatus":
            return Optional.ofNullable(clazz.cast(awsSesManagedStatus()));
        case "SendingStatusAggregate":
            return Optional.ofNullable(clazz.cast(sendingStatusAggregateAsString()));
        case "ReputationImpact":
            return Optional.ofNullable(clazz.cast(reputationImpactAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReputationEntityReference", REPUTATION_ENTITY_REFERENCE_FIELD);
        map.put("ReputationEntityType", REPUTATION_ENTITY_TYPE_FIELD);
        map.put("ReputationManagementPolicy", REPUTATION_MANAGEMENT_POLICY_FIELD);
        map.put("CustomerManagedStatus", CUSTOMER_MANAGED_STATUS_FIELD);
        map.put("AwsSesManagedStatus", AWS_SES_MANAGED_STATUS_FIELD);
        map.put("SendingStatusAggregate", SENDING_STATUS_AGGREGATE_FIELD);
        map.put("ReputationImpact", REPUTATION_IMPACT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReputationEntity, T> g) {
        return obj -> g.apply((ReputationEntity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReputationEntity> {
        /**
         * <p>
         * The unique identifier for the reputation entity. For resource-type entities, this is the Amazon Resource Name
         * (ARN) of the resource.
         * </p>
         * 
         * @param reputationEntityReference
         *        The unique identifier for the reputation entity. For resource-type entities, this is the Amazon
         *        Resource Name (ARN) of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reputationEntityReference(String reputationEntityReference);

        /**
         * <p>
         * The type of reputation entity. Currently, only <code>RESOURCE</code> type entities are supported.
         * </p>
         * 
         * @param reputationEntityType
         *        The type of reputation entity. Currently, only <code>RESOURCE</code> type entities are supported.
         * @see ReputationEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReputationEntityType
         */
        Builder reputationEntityType(String reputationEntityType);

        /**
         * <p>
         * The type of reputation entity. Currently, only <code>RESOURCE</code> type entities are supported.
         * </p>
         * 
         * @param reputationEntityType
         *        The type of reputation entity. Currently, only <code>RESOURCE</code> type entities are supported.
         * @see ReputationEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReputationEntityType
         */
        Builder reputationEntityType(ReputationEntityType reputationEntityType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the reputation management policy applied to this entity. This is an Amazon
         * Web Services Amazon SES-managed policy.
         * </p>
         * 
         * @param reputationManagementPolicy
         *        The Amazon Resource Name (ARN) of the reputation management policy applied to this entity. This is an
         *        Amazon Web Services Amazon SES-managed policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reputationManagementPolicy(String reputationManagementPolicy);

        /**
         * <p>
         * The customer-managed status record for this reputation entity, including the current status, cause
         * description, and last updated timestamp.
         * </p>
         * 
         * @param customerManagedStatus
         *        The customer-managed status record for this reputation entity, including the current status, cause
         *        description, and last updated timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerManagedStatus(StatusRecord customerManagedStatus);

        /**
         * <p>
         * The customer-managed status record for this reputation entity, including the current status, cause
         * description, and last updated timestamp.
         * </p>
         * This is a convenience method that creates an instance of the {@link StatusRecord.Builder} avoiding the need
         * to create one manually via {@link StatusRecord#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StatusRecord.Builder#build()} is called immediately and its
         * result is passed to {@link #customerManagedStatus(StatusRecord)}.
         * 
         * @param customerManagedStatus
         *        a consumer that will call methods on {@link StatusRecord.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerManagedStatus(StatusRecord)
         */
        default Builder customerManagedStatus(Consumer<StatusRecord.Builder> customerManagedStatus) {
            return customerManagedStatus(StatusRecord.builder().applyMutation(customerManagedStatus).build());
        }

        /**
         * <p>
         * The Amazon Web Services Amazon SES-managed status record for this reputation entity, including the current
         * status, cause description, and last updated timestamp.
         * </p>
         * 
         * @param awsSesManagedStatus
         *        The Amazon Web Services Amazon SES-managed status record for this reputation entity, including the
         *        current status, cause description, and last updated timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsSesManagedStatus(StatusRecord awsSesManagedStatus);

        /**
         * <p>
         * The Amazon Web Services Amazon SES-managed status record for this reputation entity, including the current
         * status, cause description, and last updated timestamp.
         * </p>
         * This is a convenience method that creates an instance of the {@link StatusRecord.Builder} avoiding the need
         * to create one manually via {@link StatusRecord#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StatusRecord.Builder#build()} is called immediately and its
         * result is passed to {@link #awsSesManagedStatus(StatusRecord)}.
         * 
         * @param awsSesManagedStatus
         *        a consumer that will call methods on {@link StatusRecord.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsSesManagedStatus(StatusRecord)
         */
        default Builder awsSesManagedStatus(Consumer<StatusRecord.Builder> awsSesManagedStatus) {
            return awsSesManagedStatus(StatusRecord.builder().applyMutation(awsSesManagedStatus).build());
        }

        /**
         * <p>
         * The aggregate sending status that determines whether the entity is allowed to send emails. This status is
         * derived from both the customer-managed and Amazon Web Services Amazon SES-managed statuses. If either the
         * customer-managed status or the Amazon Web Services Amazon SES-managed status is <code>DISABLED</code>, the
         * aggregate status will be <code>DISABLED</code> and the entity will not be allowed to send emails. When the
         * customer-managed status is set to <code>REINSTATED</code>, the entity can continue sending even if there are
         * active reputation findings, provided the Amazon Web Services Amazon SES-managed status also permits sending.
         * The entity can only send emails when both statuses permit sending.
         * </p>
         * 
         * @param sendingStatusAggregate
         *        The aggregate sending status that determines whether the entity is allowed to send emails. This status
         *        is derived from both the customer-managed and Amazon Web Services Amazon SES-managed statuses. If
         *        either the customer-managed status or the Amazon Web Services Amazon SES-managed status is
         *        <code>DISABLED</code>, the aggregate status will be <code>DISABLED</code> and the entity will not be
         *        allowed to send emails. When the customer-managed status is set to <code>REINSTATED</code>, the entity
         *        can continue sending even if there are active reputation findings, provided the Amazon Web Services
         *        Amazon SES-managed status also permits sending. The entity can only send emails when both statuses
         *        permit sending.
         * @see SendingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SendingStatus
         */
        Builder sendingStatusAggregate(String sendingStatusAggregate);

        /**
         * <p>
         * The aggregate sending status that determines whether the entity is allowed to send emails. This status is
         * derived from both the customer-managed and Amazon Web Services Amazon SES-managed statuses. If either the
         * customer-managed status or the Amazon Web Services Amazon SES-managed status is <code>DISABLED</code>, the
         * aggregate status will be <code>DISABLED</code> and the entity will not be allowed to send emails. When the
         * customer-managed status is set to <code>REINSTATED</code>, the entity can continue sending even if there are
         * active reputation findings, provided the Amazon Web Services Amazon SES-managed status also permits sending.
         * The entity can only send emails when both statuses permit sending.
         * </p>
         * 
         * @param sendingStatusAggregate
         *        The aggregate sending status that determines whether the entity is allowed to send emails. This status
         *        is derived from both the customer-managed and Amazon Web Services Amazon SES-managed statuses. If
         *        either the customer-managed status or the Amazon Web Services Amazon SES-managed status is
         *        <code>DISABLED</code>, the aggregate status will be <code>DISABLED</code> and the entity will not be
         *        allowed to send emails. When the customer-managed status is set to <code>REINSTATED</code>, the entity
         *        can continue sending even if there are active reputation findings, provided the Amazon Web Services
         *        Amazon SES-managed status also permits sending. The entity can only send emails when both statuses
         *        permit sending.
         * @see SendingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SendingStatus
         */
        Builder sendingStatusAggregate(SendingStatus sendingStatusAggregate);

        /**
         * <p>
         * The reputation impact level for this entity, representing the highest impact reputation finding currently
         * active. Reputation findings can be retrieved using the <code>ListRecommendations</code> operation.
         * </p>
         * 
         * @param reputationImpact
         *        The reputation impact level for this entity, representing the highest impact reputation finding
         *        currently active. Reputation findings can be retrieved using the <code>ListRecommendations</code>
         *        operation.
         * @see RecommendationImpact
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationImpact
         */
        Builder reputationImpact(String reputationImpact);

        /**
         * <p>
         * The reputation impact level for this entity, representing the highest impact reputation finding currently
         * active. Reputation findings can be retrieved using the <code>ListRecommendations</code> operation.
         * </p>
         * 
         * @param reputationImpact
         *        The reputation impact level for this entity, representing the highest impact reputation finding
         *        currently active. Reputation findings can be retrieved using the <code>ListRecommendations</code>
         *        operation.
         * @see RecommendationImpact
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationImpact
         */
        Builder reputationImpact(RecommendationImpact reputationImpact);
    }

    static final class BuilderImpl implements Builder {
        private String reputationEntityReference;

        private String reputationEntityType;

        private String reputationManagementPolicy;

        private StatusRecord customerManagedStatus;

        private StatusRecord awsSesManagedStatus;

        private String sendingStatusAggregate;

        private String reputationImpact;

        private BuilderImpl() {
        }

        private BuilderImpl(ReputationEntity model) {
            reputationEntityReference(model.reputationEntityReference);
            reputationEntityType(model.reputationEntityType);
            reputationManagementPolicy(model.reputationManagementPolicy);
            customerManagedStatus(model.customerManagedStatus);
            awsSesManagedStatus(model.awsSesManagedStatus);
            sendingStatusAggregate(model.sendingStatusAggregate);
            reputationImpact(model.reputationImpact);
        }

        public final String getReputationEntityReference() {
            return reputationEntityReference;
        }

        public final void setReputationEntityReference(String reputationEntityReference) {
            this.reputationEntityReference = reputationEntityReference;
        }

        @Override
        public final Builder reputationEntityReference(String reputationEntityReference) {
            this.reputationEntityReference = reputationEntityReference;
            return this;
        }

        public final String getReputationEntityType() {
            return reputationEntityType;
        }

        public final void setReputationEntityType(String reputationEntityType) {
            this.reputationEntityType = reputationEntityType;
        }

        @Override
        public final Builder reputationEntityType(String reputationEntityType) {
            this.reputationEntityType = reputationEntityType;
            return this;
        }

        @Override
        public final Builder reputationEntityType(ReputationEntityType reputationEntityType) {
            this.reputationEntityType(reputationEntityType == null ? null : reputationEntityType.toString());
            return this;
        }

        public final String getReputationManagementPolicy() {
            return reputationManagementPolicy;
        }

        public final void setReputationManagementPolicy(String reputationManagementPolicy) {
            this.reputationManagementPolicy = reputationManagementPolicy;
        }

        @Override
        public final Builder reputationManagementPolicy(String reputationManagementPolicy) {
            this.reputationManagementPolicy = reputationManagementPolicy;
            return this;
        }

        public final StatusRecord.Builder getCustomerManagedStatus() {
            return customerManagedStatus != null ? customerManagedStatus.toBuilder() : null;
        }

        public final void setCustomerManagedStatus(StatusRecord.BuilderImpl customerManagedStatus) {
            this.customerManagedStatus = customerManagedStatus != null ? customerManagedStatus.build() : null;
        }

        @Override
        public final Builder customerManagedStatus(StatusRecord customerManagedStatus) {
            this.customerManagedStatus = customerManagedStatus;
            return this;
        }

        public final StatusRecord.Builder getAwsSesManagedStatus() {
            return awsSesManagedStatus != null ? awsSesManagedStatus.toBuilder() : null;
        }

        public final void setAwsSesManagedStatus(StatusRecord.BuilderImpl awsSesManagedStatus) {
            this.awsSesManagedStatus = awsSesManagedStatus != null ? awsSesManagedStatus.build() : null;
        }

        @Override
        public final Builder awsSesManagedStatus(StatusRecord awsSesManagedStatus) {
            this.awsSesManagedStatus = awsSesManagedStatus;
            return this;
        }

        public final String getSendingStatusAggregate() {
            return sendingStatusAggregate;
        }

        public final void setSendingStatusAggregate(String sendingStatusAggregate) {
            this.sendingStatusAggregate = sendingStatusAggregate;
        }

        @Override
        public final Builder sendingStatusAggregate(String sendingStatusAggregate) {
            this.sendingStatusAggregate = sendingStatusAggregate;
            return this;
        }

        @Override
        public final Builder sendingStatusAggregate(SendingStatus sendingStatusAggregate) {
            this.sendingStatusAggregate(sendingStatusAggregate == null ? null : sendingStatusAggregate.toString());
            return this;
        }

        public final String getReputationImpact() {
            return reputationImpact;
        }

        public final void setReputationImpact(String reputationImpact) {
            this.reputationImpact = reputationImpact;
        }

        @Override
        public final Builder reputationImpact(String reputationImpact) {
            this.reputationImpact = reputationImpact;
            return this;
        }

        @Override
        public final Builder reputationImpact(RecommendationImpact reputationImpact) {
            this.reputationImpact(reputationImpact == null ? null : reputationImpact.toString());
            return this;
        }

        @Override
        public ReputationEntity build() {
            return new ReputationEntity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
