/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.http.auth.aws.signer.RegionSet;
import software.amazon.awssdk.services.sesv2.auth.scheme.SesV2AuthSchemeProvider;
import software.amazon.awssdk.services.sesv2.endpoints.SesV2EndpointProvider;

/**
 * This includes configuration specific to Amazon SES V2 that is supported by both {@link SesV2ClientBuilder} and
 * {@link SesV2AsyncClientBuilder}.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
public interface SesV2BaseClientBuilder<B extends SesV2BaseClientBuilder<B, C>, C> extends AwsClientBuilder<B, C> {
    /**
     * Set the {@link SesV2EndpointProvider} implementation that will be used by the client to determine the endpoint
     * for each request. This is optional; if none is provided a default implementation will be used the SDK.
     */
    default B endpointProvider(SesV2EndpointProvider endpointProvider) {
        throw new UnsupportedOperationException();
    }

    /**
     * Set the {@link SesV2AuthSchemeProvider} implementation that will be used by the client to resolve the auth scheme
     * for each request. This is optional; if none is provided a default implementation will be used the SDK.
     */
    default B authSchemeProvider(SesV2AuthSchemeProvider authSchemeProvider) {
        throw new UnsupportedOperationException();
    }

    /**
     * Sets the {@link RegionSet} to be used for operations using Sigv4a signing requests. This is optional; if not
     * provided, the following precedence is used:
     * <ol>
     * <li>{@link software.amazon.awssdk.core.SdkSystemSetting#AWS_SIGV4A_SIGNING_REGION_SET}.</li>
     * <li>as <code>sigv4a_signing_region_set</code> in the configuration file.</li>
     * <li>The region configured for the client.</li>
     * </ol>
     */
    default B sigv4aSigningRegionSet(RegionSet sigv4aSigningRegionSet) {
        throw new UnsupportedOperationException();
    }
}
