/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sesv2.SesV2Client;
import software.amazon.awssdk.services.sesv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.sesv2.model.ListTenantsRequest;
import software.amazon.awssdk.services.sesv2.model.ListTenantsResponse;
import software.amazon.awssdk.services.sesv2.model.TenantInfo;

public class ListTenantsIterable
implements SdkIterable<ListTenantsResponse> {
    private final SesV2Client client;
    private final ListTenantsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTenantsIterable(SesV2Client client, ListTenantsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTenantsResponseFetcher();
    }

    public Iterator<ListTenantsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TenantInfo> tenants() {
        Function<ListTenantsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tenants() != null) {
                return response.tenants().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTenantsResponseFetcher
    implements SyncPageFetcher<ListTenantsResponse> {
        private ListTenantsResponseFetcher() {
        }

        public boolean hasNextPage(ListTenantsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTenantsResponse nextPage(ListTenantsResponse previousPage) {
            if (previousPage == null) {
                return ListTenantsIterable.this.client.listTenants(ListTenantsIterable.this.firstRequest);
            }
            return ListTenantsIterable.this.client.listTenants((ListTenantsRequest)((Object)ListTenantsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

