/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.ExportSourceType;
import software.amazon.awssdk.services.sesv2.model.JobStatus;
import software.amazon.awssdk.services.sesv2.model.SesV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListExportJobsRequest
extends SesV2Request
implements ToCopyableBuilder<Builder, ListExportJobsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListExportJobsRequest.getter(ListExportJobsRequest::nextToken)).setter(ListExportJobsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PageSize").getter(ListExportJobsRequest.getter(ListExportJobsRequest::pageSize)).setter(ListExportJobsRequest.setter(Builder::pageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()}).build();
    private static final SdkField<String> EXPORT_SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportSourceType").getter(ListExportJobsRequest.getter(ListExportJobsRequest::exportSourceTypeAsString)).setter(ListExportJobsRequest.setter(Builder::exportSourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportSourceType").build()}).build();
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobStatus").getter(ListExportJobsRequest.getter(ListExportJobsRequest::jobStatusAsString)).setter(ListExportJobsRequest.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PAGE_SIZE_FIELD, EXPORT_SOURCE_TYPE_FIELD, JOB_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListExportJobsRequest.memberNameToFieldInitializer();
    private final String nextToken;
    private final Integer pageSize;
    private final String exportSourceType;
    private final String jobStatus;

    private ListExportJobsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.pageSize = builder.pageSize;
        this.exportSourceType = builder.exportSourceType;
        this.jobStatus = builder.jobStatus;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer pageSize() {
        return this.pageSize;
    }

    public final ExportSourceType exportSourceType() {
        return ExportSourceType.fromValue(this.exportSourceType);
    }

    public final String exportSourceTypeAsString() {
        return this.exportSourceType;
    }

    public final JobStatus jobStatus() {
        return JobStatus.fromValue(this.jobStatus);
    }

    public final String jobStatusAsString() {
        return this.jobStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportSourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExportJobsRequest)) {
            return false;
        }
        ListExportJobsRequest other = (ListExportJobsRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.exportSourceTypeAsString(), other.exportSourceTypeAsString()) && Objects.equals(this.jobStatusAsString(), other.jobStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListExportJobsRequest").add("NextToken", (Object)this.nextToken()).add("PageSize", (Object)this.pageSize()).add("ExportSourceType", (Object)this.exportSourceTypeAsString()).add("JobStatus", (Object)this.jobStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
            case "ExportSourceType": {
                return Optional.ofNullable(clazz.cast(this.exportSourceTypeAsString()));
            }
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("PageSize", PAGE_SIZE_FIELD);
        map.put("ExportSourceType", EXPORT_SOURCE_TYPE_FIELD);
        map.put("JobStatus", JOB_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListExportJobsRequest, T> g) {
        return obj -> g.apply((ListExportJobsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Request.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer pageSize;
        private String exportSourceType;
        private String jobStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExportJobsRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.pageSize(model.pageSize);
            this.exportSourceType(model.exportSourceType);
            this.jobStatus(model.jobStatus);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final String getExportSourceType() {
            return this.exportSourceType;
        }

        public final void setExportSourceType(String exportSourceType) {
            this.exportSourceType = exportSourceType;
        }

        @Override
        public final Builder exportSourceType(String exportSourceType) {
            this.exportSourceType = exportSourceType;
            return this;
        }

        @Override
        public final Builder exportSourceType(ExportSourceType exportSourceType) {
            this.exportSourceType(exportSourceType == null ? null : exportSourceType.toString());
            return this;
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListExportJobsRequest build() {
            return new ListExportJobsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SesV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListExportJobsRequest> {
        public Builder nextToken(String var1);

        public Builder pageSize(Integer var1);

        public Builder exportSourceType(String var1);

        public Builder exportSourceType(ExportSourceType var1);

        public Builder jobStatus(String var1);

        public Builder jobStatus(JobStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

